/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.geom.Quat4f;
import com.sun.javafx.geom.Vec2f;
import com.sun.javafx.geom.Vec3f;
import com.sun.prism.Mesh;
import com.sun.prism.impl.BaseGraphicsResource;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.MeshTempState;
import com.sun.prism.impl.MeshUtil;
import com.sun.prism.impl.MeshVertex;
import com.sun.prism.impl.PrismSettings;
import java.util.Arrays;
import java.util.HashMap;
import javafx.scene.shape.VertexFormat;
import sun.util.logging.PlatformLogger;

public abstract class BaseMesh
extends BaseGraphicsResource
implements Mesh {
    private int nVerts;
    private int nTVerts;
    private int nFaces;
    private float[] pos;
    private float[] uv;
    private int[] faces;
    private int[] smoothing;
    private boolean allSameSmoothing;
    private boolean allHardEdges;
    protected static final int POINT_SIZE = 3;
    protected static final int NORMAL_SIZE = 3;
    protected static final int TEXCOORD_SIZE = 2;
    protected static final int POINT_SIZE_VB = 3;
    protected static final int TEXCOORD_SIZE_VB = 2;
    protected static final int NORMAL_SIZE_VB = 4;
    protected static final int VERTEX_SIZE_VB = 9;
    public static final int FACE_MEMBERS_SIZE = 7;
    private boolean[] dirtyVertices;
    private float[] cachedNormals;
    private float[] cachedTangents;
    private float[] cachedBitangents;
    private float[] vertexBuffer;
    private int[] indexBuffer;
    private short[] indexBufferShort;
    private int indexBufferSize;
    private int numberOfVertices;
    private HashMap<Integer, MeshGeomComp2VB> point2vbMap;
    private HashMap<Integer, MeshGeomComp2VB> normal2vbMap;
    private HashMap<Integer, MeshGeomComp2VB> texCoord2vbMap;

    protected BaseMesh(Disposer.Record disposerRecord) {
        super(disposerRecord);
    }

    public abstract boolean buildNativeGeometry(float[] var1, int var2, int[] var3, int var4);

    public abstract boolean buildNativeGeometry(float[] var1, int var2, short[] var3, int var4);

    private boolean updateSkipMeshNormalGeometry(int[] posFromAndLengthIndices, int[] uvFromAndLengthIndices) {
        int startTexCoord = uvFromAndLengthIndices[0] / 2;
        int numTexCoords = uvFromAndLengthIndices[1] / 2;
        if (uvFromAndLengthIndices[1] % 2 > 0) {
            ++numTexCoords;
        }
        if (numTexCoords > 0) {
            for (int i = 0; i < numTexCoords; ++i) {
                int vbIndex;
                int texCoordOffset = (startTexCoord + i) * 2;
                MeshGeomComp2VB mt2vb = this.texCoord2vbMap.get(texCoordOffset);
                assert (mt2vb != null);
                if (mt2vb == null) continue;
                int[] locs = mt2vb.getLocs();
                int validLocs = mt2vb.getValidLocs();
                if (locs != null) {
                    for (int j = 0; j < validLocs; ++j) {
                        vbIndex = locs[j] * 9 + 3;
                        this.vertexBuffer[vbIndex] = this.uv[texCoordOffset];
                        this.vertexBuffer[vbIndex + 1] = this.uv[texCoordOffset + 1];
                    }
                    continue;
                }
                int loc = mt2vb.getLoc();
                vbIndex = loc * 9 + 3;
                this.vertexBuffer[vbIndex] = this.uv[texCoordOffset];
                this.vertexBuffer[vbIndex + 1] = this.uv[texCoordOffset + 1];
            }
        }
        int startPoint = posFromAndLengthIndices[0] / 3;
        int numPoints = posFromAndLengthIndices[1] / 3;
        if (posFromAndLengthIndices[1] % 3 > 0) {
            ++numPoints;
        }
        if (numPoints > 0) {
            for (int i = 0; i < numPoints; ++i) {
                int vbIndex;
                int pointOffset = (startPoint + i) * 3;
                MeshGeomComp2VB mp2vb = this.point2vbMap.get(pointOffset);
                assert (mp2vb != null);
                if (mp2vb == null) continue;
                int[] locs = mp2vb.getLocs();
                int validLocs = mp2vb.getValidLocs();
                if (locs != null) {
                    for (int j = 0; j < validLocs; ++j) {
                        vbIndex = locs[j] * 9;
                        this.vertexBuffer[vbIndex] = this.pos[pointOffset];
                        this.vertexBuffer[vbIndex + 1] = this.pos[pointOffset + 1];
                        this.vertexBuffer[vbIndex + 2] = this.pos[pointOffset + 2];
                    }
                    continue;
                }
                int loc = mp2vb.getLoc();
                vbIndex = loc * 9;
                this.vertexBuffer[vbIndex] = this.pos[pointOffset];
                this.vertexBuffer[vbIndex + 1] = this.pos[pointOffset + 1];
                this.vertexBuffer[vbIndex + 2] = this.pos[pointOffset + 2];
            }
        }
        if (this.indexBuffer != null) {
            return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBuffer, this.nFaces * 3);
        }
        return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBufferShort, this.nFaces * 3);
    }

    private boolean buildSkipMeshNormalGeometry() {
        HashMap<Long, Integer> face2vbMap = new HashMap<Long, Integer>();
        if (this.point2vbMap == null) {
            this.point2vbMap = new HashMap();
        } else {
            this.point2vbMap.clear();
        }
        if (this.texCoord2vbMap == null) {
            this.texCoord2vbMap = new HashMap();
        } else {
            this.texCoord2vbMap.clear();
        }
        this.vertexBuffer = new float[this.nVerts * 9];
        this.indexBuffer = new int[this.nFaces * 3];
        int ibCount = 0;
        int vbCount = 0;
        for (int faceCount = 0; faceCount < this.nFaces; ++faceCount) {
            int faceIndex = faceCount * 6;
            for (int i = 0; i < 3; ++i) {
                int vertexIndex = i * 2;
                int pointIndex = faceIndex + vertexIndex;
                int texCoordIndex = pointIndex + 1;
                long key = (long)this.faces[pointIndex] << 32 | (long)this.faces[texCoordIndex];
                Integer mf2vb = (Integer)face2vbMap.get(key);
                if (mf2vb == null) {
                    mf2vb = vbCount / 9;
                    face2vbMap.put(key, mf2vb);
                    if (this.vertexBuffer.length <= vbCount) {
                        float[] temp = new float[vbCount + 90];
                        System.arraycopy(this.vertexBuffer, 0, temp, 0, this.vertexBuffer.length);
                        this.vertexBuffer = temp;
                    }
                    int pointOffset = this.faces[pointIndex] * 3;
                    int texCoordOffset = this.faces[texCoordIndex] * 2;
                    this.vertexBuffer[vbCount] = this.pos[pointOffset];
                    this.vertexBuffer[vbCount + 1] = this.pos[pointOffset + 1];
                    this.vertexBuffer[vbCount + 2] = this.pos[pointOffset + 2];
                    this.vertexBuffer[vbCount + 3] = this.uv[texCoordOffset];
                    this.vertexBuffer[vbCount + 4] = this.uv[texCoordOffset + 1];
                    this.vertexBuffer[vbCount + 5] = 0.0f;
                    this.vertexBuffer[vbCount + 6] = 0.0f;
                    this.vertexBuffer[vbCount + 7] = 0.0f;
                    this.vertexBuffer[vbCount + 8] = 0.0f;
                    vbCount += 9;
                    MeshGeomComp2VB mp2vb = this.point2vbMap.get(pointOffset);
                    if (mp2vb == null) {
                        mp2vb = new MeshGeomComp2VB(pointOffset, mf2vb);
                        this.point2vbMap.put(pointOffset, mp2vb);
                    } else {
                        mp2vb.addLoc(mf2vb);
                    }
                    MeshGeomComp2VB mt2vb = this.texCoord2vbMap.get(texCoordOffset);
                    if (mt2vb == null) {
                        mt2vb = new MeshGeomComp2VB(texCoordOffset, mf2vb);
                        this.texCoord2vbMap.put(texCoordOffset, mt2vb);
                    } else {
                        mt2vb.addLoc(mf2vb);
                    }
                }
                this.indexBuffer[ibCount++] = mf2vb;
            }
        }
        this.numberOfVertices = vbCount / 9;
        if (this.numberOfVertices > 65536) {
            return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBuffer, this.nFaces * 3);
        }
        if (this.indexBufferShort == null || this.indexBufferShort.length < this.nFaces * 3) {
            this.indexBufferShort = new short[this.nFaces * 3];
        }
        int ii = 0;
        for (int i = 0; i < this.nFaces; ++i) {
            this.indexBufferShort[ii] = (short)this.indexBuffer[ii++];
            this.indexBufferShort[ii] = (short)this.indexBuffer[ii++];
            this.indexBufferShort[ii] = (short)this.indexBuffer[ii++];
        }
        this.indexBuffer = null;
        return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBufferShort, this.nFaces * 3);
    }

    private void convertNormalsToQuats(MeshTempState instance, int numberOfVertices, float[] normals, float[] tangents, float[] bitangents, float[] vertexBuffer, boolean[] dirtys) {
        Vec3f normal = instance.vec3f1;
        Vec3f tangent = instance.vec3f2;
        Vec3f bitangent = instance.vec3f3;
        int i = 0;
        int vbIndex = 0;
        while (i < numberOfVertices) {
            if (dirtys == null || dirtys[i]) {
                int index = i * 3;
                normal.x = normals[index];
                normal.y = normals[index + 1];
                normal.z = normals[index + 2];
                normal.normalize();
                tangent.x = tangents[index];
                tangent.y = tangents[index + 1];
                tangent.z = tangents[index + 2];
                bitangent.x = bitangents[index];
                bitangent.y = bitangents[index + 1];
                bitangent.z = bitangents[index + 2];
                instance.triNormals[0].set(normal);
                instance.triNormals[1].set(tangent);
                instance.triNormals[2].set(bitangent);
                MeshUtil.fixTSpace(instance.triNormals);
                this.buildVSQuat(instance.triNormals, instance.quat);
                vertexBuffer[vbIndex + 5] = instance.quat.x;
                vertexBuffer[vbIndex + 6] = instance.quat.y;
                vertexBuffer[vbIndex + 7] = instance.quat.z;
                vertexBuffer[vbIndex + 8] = instance.quat.w;
            }
            ++i;
            vbIndex += 9;
        }
    }

    private boolean doBuildPNTGeometry(float[] points, float[] normals, float[] texCoords, int[] faces) {
        if (this.point2vbMap == null) {
            this.point2vbMap = new HashMap();
        } else {
            this.point2vbMap.clear();
        }
        if (this.normal2vbMap == null) {
            this.normal2vbMap = new HashMap();
        } else {
            this.normal2vbMap.clear();
        }
        if (this.texCoord2vbMap == null) {
            this.texCoord2vbMap = new HashMap();
        } else {
            this.texCoord2vbMap.clear();
        }
        int vertexIndexSize = VertexFormat.POINT_NORMAL_TEXCOORD.getVertexIndexSize();
        int faceIndexSize = vertexIndexSize * 3;
        int pointIndexOffset = VertexFormat.POINT_NORMAL_TEXCOORD.getPointIndexOffset();
        int normalIndexOffset = VertexFormat.POINT_NORMAL_TEXCOORD.getNormalIndexOffset();
        int texCoordIndexOffset = VertexFormat.POINT_NORMAL_TEXCOORD.getTexCoordIndexOffset();
        int numPoints = points.length / 3;
        int numNormals = normals.length / 3;
        int numTexCoords = texCoords.length / 2;
        int numFaces = faces.length / faceIndexSize;
        assert (numPoints > 0 && numNormals > 0 && numTexCoords > 0 && numFaces > 0);
        this.cachedNormals = new float[numPoints * 3];
        this.cachedTangents = new float[numPoints * 3];
        this.cachedBitangents = new float[numPoints * 3];
        this.vertexBuffer = new float[numPoints * 9];
        this.indexBuffer = new int[numFaces * 3];
        int ibCount = 0;
        int vbCount = 0;
        MeshTempState instance = MeshTempState.getInstance();
        for (int i = 0; i < 3; ++i) {
            if (instance.triPoints[i] == null) {
                instance.triPoints[i] = new Vec3f();
            }
            if (instance.triTexCoords[i] != null) continue;
            instance.triTexCoords[i] = new Vec2f();
        }
        for (int faceCount = 0; faceCount < numFaces; ++faceCount) {
            int i;
            int faceIndex = faceCount * faceIndexSize;
            for (i = 0; i < 3; ++i) {
                int vertexIndex = faceIndex + i * vertexIndexSize;
                int pointIndex = vertexIndex + pointIndexOffset;
                int normalIndex = vertexIndex + normalIndexOffset;
                int texCoordIndex = vertexIndex + texCoordIndexOffset;
                Integer mf2vb = vbCount / 9;
                if (this.vertexBuffer.length <= vbCount) {
                    int numVertices = vbCount / 9;
                    int newNumVertices = numVertices + Math.max(numVertices >> 3, 6);
                    float[] temp = new float[newNumVertices * 9];
                    System.arraycopy(this.vertexBuffer, 0, temp, 0, this.vertexBuffer.length);
                    this.vertexBuffer = temp;
                    temp = new float[newNumVertices * 3];
                    System.arraycopy(this.cachedNormals, 0, temp, 0, this.cachedNormals.length);
                    this.cachedNormals = temp;
                    temp = new float[newNumVertices * 3];
                    System.arraycopy(this.cachedTangents, 0, temp, 0, this.cachedTangents.length);
                    this.cachedTangents = temp;
                    temp = new float[newNumVertices * 3];
                    System.arraycopy(this.cachedBitangents, 0, temp, 0, this.cachedBitangents.length);
                    this.cachedBitangents = temp;
                }
                int pointOffset = faces[pointIndex] * 3;
                int normalOffset = faces[normalIndex] * 3;
                int texCoordOffset = faces[texCoordIndex] * 2;
                instance.triPointIndex[i] = pointOffset;
                instance.triTexCoordIndex[i] = texCoordOffset;
                instance.triVerts[i] = vbCount / 9;
                this.vertexBuffer[vbCount] = points[pointOffset];
                this.vertexBuffer[vbCount + 1] = points[pointOffset + 1];
                this.vertexBuffer[vbCount + 2] = points[pointOffset + 2];
                this.vertexBuffer[vbCount + 3] = texCoords[texCoordOffset];
                this.vertexBuffer[vbCount + 4] = texCoords[texCoordOffset + 1];
                int index = instance.triVerts[i] * 3;
                this.cachedNormals[index] = normals[normalOffset];
                this.cachedNormals[index + 1] = normals[normalOffset + 1];
                this.cachedNormals[index + 2] = normals[normalOffset + 2];
                vbCount += 9;
                MeshGeomComp2VB mp2vb = this.point2vbMap.get(pointOffset);
                if (mp2vb == null) {
                    mp2vb = new MeshGeomComp2VB(pointOffset, mf2vb);
                    this.point2vbMap.put(pointOffset, mp2vb);
                } else {
                    mp2vb.addLoc(mf2vb);
                }
                MeshGeomComp2VB mn2vb = this.normal2vbMap.get(normalOffset);
                if (mn2vb == null) {
                    mn2vb = new MeshGeomComp2VB(normalOffset, mf2vb);
                    this.normal2vbMap.put(normalOffset, mn2vb);
                } else {
                    mn2vb.addLoc(mf2vb);
                }
                MeshGeomComp2VB mt2vb = this.texCoord2vbMap.get(texCoordOffset);
                if (mt2vb == null) {
                    mt2vb = new MeshGeomComp2VB(texCoordOffset, mf2vb);
                    this.texCoord2vbMap.put(texCoordOffset, mt2vb);
                } else {
                    mt2vb.addLoc(mf2vb);
                }
                this.indexBuffer[ibCount++] = mf2vb;
            }
            for (i = 0; i < 3; ++i) {
                instance.triPoints[i].x = points[instance.triPointIndex[i]];
                instance.triPoints[i].y = points[instance.triPointIndex[i] + 1];
                instance.triPoints[i].z = points[instance.triPointIndex[i] + 2];
                instance.triTexCoords[i].x = texCoords[instance.triTexCoordIndex[i]];
                instance.triTexCoords[i].y = texCoords[instance.triTexCoordIndex[i] + 1];
            }
            MeshUtil.computeTBNNormalized(instance.triPoints[0], instance.triPoints[1], instance.triPoints[2], instance.triTexCoords[0], instance.triTexCoords[1], instance.triTexCoords[2], instance.triNormals);
            for (i = 0; i < 3; ++i) {
                int index = instance.triVerts[i] * 3;
                this.cachedTangents[index] = instance.triNormals[1].x;
                this.cachedTangents[index + 1] = instance.triNormals[1].y;
                this.cachedTangents[index + 2] = instance.triNormals[1].z;
                this.cachedBitangents[index] = instance.triNormals[2].x;
                this.cachedBitangents[index + 1] = instance.triNormals[2].y;
                this.cachedBitangents[index + 2] = instance.triNormals[2].z;
            }
        }
        this.numberOfVertices = vbCount / 9;
        this.convertNormalsToQuats(instance, this.numberOfVertices, this.cachedNormals, this.cachedTangents, this.cachedBitangents, this.vertexBuffer, null);
        this.indexBufferSize = numFaces * 3;
        if (this.numberOfVertices > 65536) {
            return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBuffer, this.indexBufferSize);
        }
        if (this.indexBufferShort == null || this.indexBufferShort.length < this.indexBufferSize) {
            this.indexBufferShort = new short[this.indexBufferSize];
        }
        int ii = 0;
        for (int i = 0; i < numFaces; ++i) {
            this.indexBufferShort[ii] = (short)this.indexBuffer[ii++];
            this.indexBufferShort[ii] = (short)this.indexBuffer[ii++];
            this.indexBufferShort[ii] = (short)this.indexBuffer[ii++];
        }
        this.indexBuffer = null;
        return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBufferShort, this.indexBufferSize);
    }

    private boolean updatePNTGeometry(float[] points, int[] pointsFromAndLengthIndices, float[] normals, int[] normalsFromAndLengthIndices, float[] texCoords, int[] texCoordsFromAndLengthIndices) {
        int vbIndex;
        if (this.dirtyVertices == null) {
            this.dirtyVertices = new boolean[this.numberOfVertices];
        }
        Arrays.fill(this.dirtyVertices, false);
        int startPoint = pointsFromAndLengthIndices[0] / 3;
        int numPoints = pointsFromAndLengthIndices[1] / 3;
        if (pointsFromAndLengthIndices[1] % 3 > 0) {
            ++numPoints;
        }
        if (numPoints > 0) {
            for (int i = 0; i < numPoints; ++i) {
                int pointOffset = (startPoint + i) * 3;
                MeshGeomComp2VB mp2vb = this.point2vbMap.get(pointOffset);
                assert (mp2vb != null);
                if (mp2vb == null) continue;
                int[] locs = mp2vb.getLocs();
                int validLocs = mp2vb.getValidLocs();
                if (locs != null) {
                    for (int j = 0; j < validLocs; ++j) {
                        vbIndex = locs[j] * 9;
                        this.vertexBuffer[vbIndex] = points[pointOffset];
                        this.vertexBuffer[vbIndex + 1] = points[pointOffset + 1];
                        this.vertexBuffer[vbIndex + 2] = points[pointOffset + 2];
                        this.dirtyVertices[locs[j]] = true;
                    }
                    continue;
                }
                int loc = mp2vb.getLoc();
                vbIndex = loc * 9;
                this.vertexBuffer[vbIndex] = points[pointOffset];
                this.vertexBuffer[vbIndex + 1] = points[pointOffset + 1];
                this.vertexBuffer[vbIndex + 2] = points[pointOffset + 2];
                this.dirtyVertices[loc] = true;
            }
        }
        int startTexCoord = texCoordsFromAndLengthIndices[0] / 2;
        int numTexCoords = texCoordsFromAndLengthIndices[1] / 2;
        if (texCoordsFromAndLengthIndices[1] % 2 > 0) {
            ++numTexCoords;
        }
        if (numTexCoords > 0) {
            for (int i = 0; i < numTexCoords; ++i) {
                int vbIndex2;
                int texCoordOffset = (startTexCoord + i) * 2;
                MeshGeomComp2VB mt2vb = this.texCoord2vbMap.get(texCoordOffset);
                assert (mt2vb != null);
                if (mt2vb == null) continue;
                int[] locs = mt2vb.getLocs();
                int validLocs = mt2vb.getValidLocs();
                if (locs != null) {
                    for (int j = 0; j < validLocs; ++j) {
                        vbIndex2 = locs[j] * 9 + 3;
                        this.vertexBuffer[vbIndex2] = texCoords[texCoordOffset];
                        this.vertexBuffer[vbIndex2 + 1] = texCoords[texCoordOffset + 1];
                        this.dirtyVertices[locs[j]] = true;
                    }
                    continue;
                }
                int loc = mt2vb.getLoc();
                vbIndex2 = loc * 9 + 3;
                this.vertexBuffer[vbIndex2] = texCoords[texCoordOffset];
                this.vertexBuffer[vbIndex2 + 1] = texCoords[texCoordOffset + 1];
                this.dirtyVertices[loc] = true;
            }
        }
        int startNormal = normalsFromAndLengthIndices[0] / 3;
        int numNormals = normalsFromAndLengthIndices[1] / 3;
        if (normalsFromAndLengthIndices[1] % 3 > 0) {
            ++numNormals;
        }
        if (numNormals > 0) {
            MeshTempState instance = MeshTempState.getInstance();
            for (int i = 0; i < numNormals; ++i) {
                int index;
                int normalOffset = (startNormal + i) * 3;
                MeshGeomComp2VB mn2vb = this.normal2vbMap.get(normalOffset);
                assert (mn2vb != null);
                if (mn2vb == null) continue;
                int[] locs = mn2vb.getLocs();
                int validLocs = mn2vb.getValidLocs();
                if (locs != null) {
                    for (int j = 0; j < validLocs; ++j) {
                        index = locs[j] * 3;
                        this.cachedNormals[index] = normals[normalOffset];
                        this.cachedNormals[index + 1] = normals[normalOffset + 1];
                        this.cachedNormals[index + 2] = normals[normalOffset + 2];
                        this.dirtyVertices[locs[j]] = true;
                    }
                    continue;
                }
                int loc = mn2vb.getLoc();
                index = loc * 3;
                this.cachedNormals[index] = normals[normalOffset];
                this.cachedNormals[index + 1] = normals[normalOffset + 1];
                this.cachedNormals[index + 2] = normals[normalOffset + 2];
                this.dirtyVertices[loc] = true;
            }
        }
        MeshTempState instance = MeshTempState.getInstance();
        for (int i = 0; i < 3; ++i) {
            if (instance.triPoints[i] == null) {
                instance.triPoints[i] = new Vec3f();
            }
            if (instance.triTexCoords[i] != null) continue;
            instance.triTexCoords[i] = new Vec2f();
        }
        for (int j = 0; j < this.numberOfVertices; j += 3) {
            if (!this.dirtyVertices[j] && !this.dirtyVertices[j + 1] && !this.dirtyVertices[j + 2]) continue;
            vbIndex = j * 9;
            for (int i = 0; i < 3; ++i) {
                instance.triPoints[i].x = this.vertexBuffer[vbIndex];
                instance.triPoints[i].y = this.vertexBuffer[vbIndex + 1];
                instance.triPoints[i].z = this.vertexBuffer[vbIndex + 2];
                instance.triTexCoords[i].x = this.vertexBuffer[vbIndex + 3];
                instance.triTexCoords[i].y = this.vertexBuffer[vbIndex + 3 + 1];
                vbIndex += 9;
            }
            MeshUtil.computeTBNNormalized(instance.triPoints[0], instance.triPoints[1], instance.triPoints[2], instance.triTexCoords[0], instance.triTexCoords[1], instance.triTexCoords[2], instance.triNormals);
            int index = j * 3;
            for (int i = 0; i < 3; ++i) {
                this.cachedTangents[index] = instance.triNormals[1].x;
                this.cachedTangents[index + 1] = instance.triNormals[1].y;
                this.cachedTangents[index + 2] = instance.triNormals[1].z;
                this.cachedBitangents[index] = instance.triNormals[2].x;
                this.cachedBitangents[index + 1] = instance.triNormals[2].y;
                this.cachedBitangents[index + 2] = instance.triNormals[2].z;
                index += 3;
            }
        }
        this.convertNormalsToQuats(instance, this.numberOfVertices, this.cachedNormals, this.cachedTangents, this.cachedBitangents, this.vertexBuffer, this.dirtyVertices);
        if (this.indexBuffer != null) {
            return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBuffer, this.indexBufferSize);
        }
        return this.buildNativeGeometry(this.vertexBuffer, this.numberOfVertices * 9, this.indexBufferShort, this.indexBufferSize);
    }

    @Override
    public boolean buildGeometry(boolean userDefinedNormals, float[] points, int[] pointsFromAndLengthIndices, float[] normals, int[] normalsFromAndLengthIndices, float[] texCoords, int[] texCoordsFromAndLengthIndices, int[] faces, int[] facesFromAndLengthIndices, int[] faceSmoothingGroups, int[] faceSmoothingGroupsFromAndLengthIndices) {
        if (userDefinedNormals) {
            return this.buildPNTGeometry(points, pointsFromAndLengthIndices, normals, normalsFromAndLengthIndices, texCoords, texCoordsFromAndLengthIndices, faces, facesFromAndLengthIndices);
        }
        return this.buildPTGeometry(points, pointsFromAndLengthIndices, texCoords, texCoordsFromAndLengthIndices, faces, facesFromAndLengthIndices, faceSmoothingGroups, faceSmoothingGroupsFromAndLengthIndices);
    }

    private boolean buildPNTGeometry(float[] points, int[] pointsFromAndLengthIndices, float[] normals, int[] normalsFromAndLengthIndices, float[] texCoords, int[] texCoordsFromAndLengthIndices, int[] faces, int[] facesFromAndLengthIndices) {
        boolean buildGeom;
        boolean updatePoints = pointsFromAndLengthIndices[1] > 0;
        boolean updateNormals = normalsFromAndLengthIndices[1] > 0;
        boolean updateTexCoords = texCoordsFromAndLengthIndices[1] > 0;
        boolean updateFaces = facesFromAndLengthIndices[1] > 0;
        boolean bl = buildGeom = !updatePoints && !updateNormals && !updateTexCoords && !updateFaces;
        if (updateFaces) {
            buildGeom = true;
        }
        if (!(buildGeom || this.vertexBuffer == null || this.indexBuffer == null && this.indexBufferShort == null)) {
            return this.updatePNTGeometry(points, pointsFromAndLengthIndices, normals, normalsFromAndLengthIndices, texCoords, texCoordsFromAndLengthIndices);
        }
        return this.doBuildPNTGeometry(points, normals, texCoords, faces);
    }

    private boolean buildPTGeometry(float[] pos, int[] posFromAndLengthIndices, float[] uv, int[] uvFromAndLengthIndices, int[] faces, int[] facesFromAndLengthIndices, int[] smoothing, int[] smoothingFromAndLengthIndices) {
        this.nVerts = pos.length / 3;
        this.nTVerts = uv.length / 2;
        this.nFaces = faces.length / (VertexFormat.POINT_TEXCOORD.getVertexIndexSize() * 3);
        assert (this.nVerts > 0 && this.nFaces > 0 && this.nTVerts > 0);
        this.pos = pos;
        this.uv = uv;
        this.faces = faces;
        Object object = this.smoothing = (Object)(smoothing.length == this.nFaces ? smoothing : null);
        if (PrismSettings.skipMeshNormalComputation) {
            boolean buildGeom;
            boolean updatePoints = posFromAndLengthIndices[1] > 0;
            boolean updateTexCoords = uvFromAndLengthIndices[1] > 0;
            boolean updateFaces = facesFromAndLengthIndices[1] > 0;
            boolean updateSmoothing = smoothingFromAndLengthIndices[1] > 0;
            boolean bl = buildGeom = !updatePoints && !updateTexCoords && !updateFaces && !updateSmoothing;
            if (updateFaces || updateSmoothing) {
                buildGeom = true;
            }
            if (!(buildGeom || this.vertexBuffer == null || this.indexBuffer == null && this.indexBufferShort == null)) {
                return this.updateSkipMeshNormalGeometry(posFromAndLengthIndices, uvFromAndLengthIndices);
            }
            return this.buildSkipMeshNormalGeometry();
        }
        MeshTempState instance = MeshTempState.getInstance();
        if (instance.pool == null || instance.pool.length < this.nFaces * 3) {
            instance.pool = new MeshVertex[this.nFaces * 3];
        }
        if (instance.indexBuffer == null || instance.indexBuffer.length < this.nFaces * 3) {
            instance.indexBuffer = new int[this.nFaces * 3];
        }
        if (instance.pVertex == null || instance.pVertex.length < this.nVerts) {
            instance.pVertex = new MeshVertex[this.nVerts];
        } else {
            Arrays.fill(instance.pVertex, 0, instance.pVertex.length, null);
        }
        this.checkSmoothingGroup();
        this.computeTBNormal(instance.pool, instance.pVertex, instance.indexBuffer);
        int nNewVerts = MeshVertex.processVertices(instance.pVertex, this.nVerts, this.allHardEdges, this.allSameSmoothing);
        if (instance.vertexBuffer == null || instance.vertexBuffer.length < nNewVerts * 9) {
            instance.vertexBuffer = new float[nNewVerts * 9];
        }
        this.buildVertexBuffer(instance.pVertex, instance.vertexBuffer);
        if (nNewVerts > 65536) {
            this.buildIndexBuffer(instance.pool, instance.indexBuffer, null);
            return this.buildNativeGeometry(instance.vertexBuffer, nNewVerts * 9, instance.indexBuffer, this.nFaces * 3);
        }
        if (instance.indexBufferShort == null || instance.indexBufferShort.length < this.nFaces * 3) {
            instance.indexBufferShort = new short[this.nFaces * 3];
        }
        this.buildIndexBuffer(instance.pool, instance.indexBuffer, instance.indexBufferShort);
        return this.buildNativeGeometry(instance.vertexBuffer, nNewVerts * 9, instance.indexBufferShort, this.nFaces * 3);
    }

    private void computeTBNormal(MeshVertex[] pool, MeshVertex[] pVertex, int[] indexBuffer) {
        MeshTempState instance = MeshTempState.getInstance();
        int[] smFace = instance.smFace;
        int[] triVerts = instance.triVerts;
        Vec3f[] triPoints = instance.triPoints;
        Vec2f[] triTexCoords = instance.triTexCoords;
        Vec3f[] triNormals = instance.triNormals;
        String logname = BaseMesh.class.getName();
        int nDeadFaces = 0;
        int poolIndex = 0;
        for (int f = 0; f < this.nFaces; ++f) {
            int i;
            int index = f * 3;
            smFace = this.getFace(f, smFace);
            triVerts[0] = smFace[FaceMembers.POINT0.ordinal()];
            triVerts[1] = smFace[FaceMembers.POINT1.ordinal()];
            triVerts[2] = smFace[FaceMembers.POINT2.ordinal()];
            if (MeshUtil.isDeadFace(triVerts) && PlatformLogger.getLogger(logname).isLoggable(PlatformLogger.Level.FINE)) {
                PlatformLogger.getLogger(logname).fine("Dead face [" + triVerts[0] + ", " + triVerts[1] + ", " + triVerts[2] + "] @ face group " + f + "; nEmptyFaces = " + ++nDeadFaces);
            }
            for (i = 0; i < 3; ++i) {
                triPoints[i] = this.getVertex(triVerts[i], triPoints[i]);
            }
            triVerts[0] = smFace[FaceMembers.TEXCOORD0.ordinal()];
            triVerts[1] = smFace[FaceMembers.TEXCOORD1.ordinal()];
            triVerts[2] = smFace[FaceMembers.TEXCOORD2.ordinal()];
            for (i = 0; i < 3; ++i) {
                triTexCoords[i] = this.getTVertex(triVerts[i], triTexCoords[i]);
            }
            MeshUtil.computeTBNNormalized(triPoints[0], triPoints[1], triPoints[2], triTexCoords[0], triTexCoords[1], triTexCoords[2], triNormals);
            for (int j = 0; j < 3; ++j) {
                int pIdx;
                pool[poolIndex] = pool[poolIndex] == null ? new MeshVertex() : pool[poolIndex];
                for (int i2 = 0; i2 < 3; ++i2) {
                    pool[poolIndex].norm[i2].set(triNormals[i2]);
                }
                pool[poolIndex].smGroup = smFace[FaceMembers.SMOOTHING_GROUP.ordinal()];
                pool[poolIndex].fIdx = f;
                pool[poolIndex].tVert = triVerts[j];
                pool[poolIndex].index = -1;
                int ii = j == 0 ? FaceMembers.POINT0.ordinal() : (j == 1 ? FaceMembers.POINT1.ordinal() : FaceMembers.POINT2.ordinal());
                pool[poolIndex].pVert = pIdx = smFace[ii];
                indexBuffer[index + j] = pIdx;
                pool[poolIndex].next = pVertex[pIdx];
                pVertex[pIdx] = pool[poolIndex];
                ++poolIndex;
            }
        }
    }

    private void buildVSQuat(Vec3f[] tm, Quat4f quat) {
        Vec3f v = MeshTempState.getInstance().vec3f1;
        v.cross(tm[1], tm[2]);
        float d = tm[0].dot(v);
        if (d < 0.0f) {
            tm[2].mul(-1.0f);
        }
        MeshUtil.buildQuat(tm, quat);
        if (d < 0.0f) {
            if (quat.w == 0.0f) {
                quat.w = 1.0E-10f;
            }
            quat.scale(-1.0f);
        }
    }

    private void buildVertexBuffer(MeshVertex[] pVerts, float[] vertexBuffer) {
        Quat4f quat = MeshTempState.getInstance().quat;
        int idLast = 0;
        int index = 0;
        for (int i = 0; i < this.nVerts; ++i) {
            MeshVertex v = pVerts[i];
            while (v != null) {
                if (v.index == idLast) {
                    int ind = v.pVert * 3;
                    vertexBuffer[index++] = this.pos[ind];
                    vertexBuffer[index++] = this.pos[ind + 1];
                    vertexBuffer[index++] = this.pos[ind + 2];
                    ind = v.tVert * 2;
                    vertexBuffer[index++] = this.uv[ind];
                    vertexBuffer[index++] = this.uv[ind + 1];
                    this.buildVSQuat(v.norm, quat);
                    vertexBuffer[index++] = quat.x;
                    vertexBuffer[index++] = quat.y;
                    vertexBuffer[index++] = quat.z;
                    vertexBuffer[index++] = quat.w;
                    ++idLast;
                }
                v = v.next;
            }
        }
    }

    private void buildIndexBuffer(MeshVertex[] pool, int[] indexBuffer, short[] indexBufferShort) {
        for (int i = 0; i < this.nFaces; ++i) {
            int j;
            int index = i * 3;
            if (indexBuffer[index] != -1) {
                for (j = 0; j < 3; ++j) {
                    assert (pool[index].fIdx == i);
                    if (indexBufferShort != null) {
                        indexBufferShort[index + j] = (short)pool[index + j].index;
                    } else {
                        indexBuffer[index + j] = pool[index + j].index;
                    }
                    pool[index + j].next = null;
                }
                continue;
            }
            for (j = 0; j < 3; ++j) {
                if (indexBufferShort != null) {
                    indexBufferShort[index + j] = 0;
                    continue;
                }
                indexBuffer[index + j] = 0;
            }
        }
    }

    public int getNumVerts() {
        return this.nVerts;
    }

    public int getNumTVerts() {
        return this.nTVerts;
    }

    public int getNumFaces() {
        return this.nFaces;
    }

    public Vec3f getVertex(int pIdx, Vec3f vertex) {
        if (vertex == null) {
            vertex = new Vec3f();
        }
        int index = pIdx * 3;
        vertex.set(this.pos[index], this.pos[index + 1], this.pos[index + 2]);
        return vertex;
    }

    public Vec2f getTVertex(int tIdx, Vec2f texCoord) {
        if (texCoord == null) {
            texCoord = new Vec2f();
        }
        int index = tIdx * 2;
        texCoord.set(this.uv[index], this.uv[index + 1]);
        return texCoord;
    }

    private void checkSmoothingGroup() {
        if (this.smoothing == null || this.smoothing.length == 0) {
            this.allSameSmoothing = true;
            this.allHardEdges = false;
            return;
        }
        int i = 0;
        while (i + 1 < this.smoothing.length) {
            if (this.smoothing[i] != this.smoothing[i + 1]) {
                this.allSameSmoothing = false;
                this.allHardEdges = false;
                return;
            }
            ++i;
        }
        if (this.smoothing[0] == 0) {
            this.allSameSmoothing = false;
            this.allHardEdges = true;
        } else {
            this.allSameSmoothing = true;
            this.allHardEdges = false;
        }
    }

    public int[] getFace(int fIdx, int[] face) {
        int index = fIdx * 6;
        if (face == null || face.length < 7) {
            face = new int[7];
        }
        for (int i = 0; i < 6; ++i) {
            face[i] = this.faces[index + i];
        }
        face[6] = this.smoothing != null ? this.smoothing[fIdx] : 1;
        return face;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    boolean test_isVertexBufferNull() {
        return this.vertexBuffer == null;
    }

    int test_getVertexBufferLength() {
        return this.vertexBuffer.length;
    }

    int test_getNumberOfVertices() {
        return this.numberOfVertices;
    }

    class MeshGeomComp2VB {
        private final int key;
        private final int loc;
        private int[] locs;
        private int validLocs;

        MeshGeomComp2VB(int key, int loc) {
            assert (loc >= 0);
            this.key = key;
            this.loc = loc;
            this.locs = null;
            this.validLocs = 0;
        }

        void addLoc(int loc) {
            if (this.locs == null) {
                this.locs = new int[3];
                this.locs[0] = this.loc;
                this.locs[1] = loc;
                this.validLocs = 2;
            } else if (this.locs.length > this.validLocs) {
                this.locs[this.validLocs] = loc;
                ++this.validLocs;
            } else {
                int[] temp = new int[this.validLocs * 2];
                System.arraycopy(this.locs, 0, temp, 0, this.locs.length);
                this.locs = temp;
                this.locs[this.validLocs] = loc;
                ++this.validLocs;
            }
        }

        int getKey() {
            return this.key;
        }

        int getLoc() {
            return this.loc;
        }

        int[] getLocs() {
            return this.locs;
        }

        int getValidLocs() {
            return this.validLocs;
        }
    }

    public static enum FaceMembers {
        POINT0,
        TEXCOORD0,
        POINT1,
        TEXCOORD1,
        POINT2,
        TEXCOORD2,
        SMOOTHING_GROUP;

    }
}

