/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.StringFormatter;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class BooleanExpression
implements ObservableBooleanValue {
    @Override
    public Boolean getValue() {
        return this.get();
    }

    public static BooleanExpression booleanExpression(final ObservableBooleanValue value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof BooleanExpression ? (BooleanExpression)value : new BooleanBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected boolean computeValue() {
                return value.get();
            }

            @Override
            public ObservableList<ObservableBooleanValue> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    public static BooleanExpression booleanExpression(final ObservableValue<Boolean> value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof BooleanExpression ? (BooleanExpression)value : new BooleanBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected boolean computeValue() {
                Boolean val = (Boolean)value.getValue();
                return val == null ? false : val;
            }

            @Override
            public ObservableList<ObservableValue<Boolean>> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    public BooleanBinding and(ObservableBooleanValue other) {
        return Bindings.and(this, other);
    }

    public BooleanBinding or(ObservableBooleanValue other) {
        return Bindings.or(this, other);
    }

    public BooleanBinding not() {
        return Bindings.not(this);
    }

    public BooleanBinding isEqualTo(ObservableBooleanValue other) {
        return Bindings.equal(this, other);
    }

    public BooleanBinding isNotEqualTo(ObservableBooleanValue other) {
        return Bindings.notEqual(this, other);
    }

    public StringBinding asString() {
        return (StringBinding)StringFormatter.convert(this);
    }

    public ObjectExpression<Boolean> asObject() {
        return new ObjectBinding<Boolean>(){
            {
                this.bind(BooleanExpression.this);
            }

            @Override
            public void dispose() {
                this.unbind(BooleanExpression.this);
            }

            @Override
            protected Boolean computeValue() {
                return BooleanExpression.this.getValue();
            }
        };
    }
}

