/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.canvas;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.IllegalPathStateException;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.IntToBytePixelConverter;
import com.sun.javafx.image.PixelConverter;
import com.sun.javafx.image.PixelGetter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.ByteBgraPre;
import com.sun.javafx.sg.prism.GrowableDataBuffer;
import com.sun.javafx.tk.Toolkit;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import javafx.geometry.NodeOrientation;
import javafx.geometry.VPos;
import javafx.scene.canvas.Canvas;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Affine;

public final class GraphicsContext {
    Canvas theCanvas;
    Path2D path;
    boolean pathDirty;
    State curState;
    LinkedList<State> stateStack;
    LinkedList<Path2D> clipStack;
    private float[] coords = new float[6];
    private static final byte[] pgtype = new byte[]{41, 42, 43, 44, 45};
    private static final int[] numsegs = new int[]{2, 2, 4, 6, 0};
    private float[] polybuf = new float[512];
    private boolean txdirty;
    private PixelWriter writer;

    GraphicsContext(Canvas theCanvas) {
        this.theCanvas = theCanvas;
        this.path = new Path2D();
        this.pathDirty = true;
        this.curState = new State();
        this.stateStack = new LinkedList();
        this.clipStack = new LinkedList();
    }

    private GrowableDataBuffer getBuffer() {
        return this.theCanvas.getBuffer();
    }

    private void markPathDirty() {
        this.pathDirty = true;
    }

    private void writePath(byte command) {
        this.updateTransform();
        GrowableDataBuffer buf = this.getBuffer();
        if (this.pathDirty) {
            buf.putByte((byte)40);
            PathIterator pi = this.path.getPathIterator(null);
            while (!pi.isDone()) {
                int pitype = pi.currentSegment(this.coords);
                buf.putByte(pgtype[pitype]);
                for (int i = 0; i < numsegs[pitype]; ++i) {
                    buf.putFloat(this.coords[i]);
                }
                pi.next();
            }
            buf.putByte((byte)46);
            this.pathDirty = false;
        }
        buf.putByte(command);
    }

    private void writePaint(Paint p, byte command) {
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte(command);
        buf.putObject(Toolkit.getPaintAccessor().getPlatformPaint(p));
    }

    private void writeArcType(ArcType closure) {
        byte type;
        switch (closure) {
            case OPEN: {
                type = 0;
                break;
            }
            case CHORD: {
                type = 1;
                break;
            }
            case ROUND: {
                type = 2;
                break;
            }
            default: {
                return;
            }
        }
        this.writeParam(type, (byte)15);
    }

    private void writeRectParams(GrowableDataBuffer buf, double x, double y, double w, double h, byte command) {
        buf.putByte(command);
        buf.putFloat((float)x);
        buf.putFloat((float)y);
        buf.putFloat((float)w);
        buf.putFloat((float)h);
    }

    private void writeOp4(double x, double y, double w, double h, byte command) {
        this.updateTransform();
        this.writeRectParams(this.getBuffer(), x, y, w, h, command);
    }

    private void writeOp6(double x, double y, double w, double h, double v1, double v2, byte command) {
        this.updateTransform();
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte(command);
        buf.putFloat((float)x);
        buf.putFloat((float)y);
        buf.putFloat((float)w);
        buf.putFloat((float)h);
        buf.putFloat((float)v1);
        buf.putFloat((float)v2);
    }

    private void flushPolyBuf(GrowableDataBuffer buf, float[] polybuf, int n, byte command) {
        this.curState.transform.transform(polybuf, 0, polybuf, 0, n / 2);
        for (int i = 0; i < n; i += 2) {
            buf.putByte(command);
            buf.putFloat(polybuf[i]);
            buf.putFloat(polybuf[i + 1]);
            command = (byte)42;
        }
    }

    private void writePoly(double[] xPoints, double[] yPoints, int nPoints, boolean close, byte command) {
        if (xPoints == null || yPoints == null) {
            return;
        }
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte((byte)40);
        int pos = 0;
        int polycmd = 41;
        for (int i = 0; i < nPoints; ++i) {
            if (pos >= this.polybuf.length) {
                this.flushPolyBuf(buf, this.polybuf, pos, (byte)polycmd);
                pos = 0;
                polycmd = 42;
            }
            this.polybuf[pos++] = (float)xPoints[i];
            this.polybuf[pos++] = (float)yPoints[i];
        }
        this.flushPolyBuf(buf, this.polybuf, pos, (byte)polycmd);
        if (close) {
            buf.putByte((byte)45);
        }
        buf.putByte((byte)46);
        this.updateTransform();
        buf.putByte(command);
        this.markPathDirty();
    }

    private void writeImage(Image img, double dx, double dy, double dw, double dh) {
        if (img == null || img.getProgress() < 1.0) {
            return;
        }
        Object platformImg = img.impl_getPlatformImage();
        if (platformImg == null) {
            return;
        }
        this.updateTransform();
        GrowableDataBuffer buf = this.getBuffer();
        this.writeRectParams(buf, dx, dy, dw, dh, (byte)50);
        buf.putObject(platformImg);
    }

    private void writeImage(Image img, double dx, double dy, double dw, double dh, double sx, double sy, double sw, double sh) {
        if (img == null || img.getProgress() < 1.0) {
            return;
        }
        Object platformImg = img.impl_getPlatformImage();
        if (platformImg == null) {
            return;
        }
        this.updateTransform();
        GrowableDataBuffer buf = this.getBuffer();
        this.writeRectParams(buf, dx, dy, dw, dh, (byte)51);
        buf.putFloat((float)sx);
        buf.putFloat((float)sy);
        buf.putFloat((float)sw);
        buf.putFloat((float)sh);
        buf.putObject(platformImg);
    }

    private void writeText(String text, double x, double y, double maxWidth, byte command) {
        if (text == null) {
            return;
        }
        this.updateTransform();
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte(command);
        buf.putFloat((float)x);
        buf.putFloat((float)y);
        buf.putFloat((float)maxWidth);
        buf.putBoolean(this.theCanvas.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT);
        buf.putObject(text);
    }

    void writeParam(double v, byte command) {
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte(command);
        buf.putFloat((float)v);
    }

    private void writeParam(byte v, byte command) {
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte(command);
        buf.putByte(v);
    }

    private void updateTransform() {
        if (this.txdirty) {
            this.txdirty = false;
            GrowableDataBuffer buf = this.getBuffer();
            buf.putByte((byte)11);
            buf.putDouble(this.curState.transform.getMxx());
            buf.putDouble(this.curState.transform.getMxy());
            buf.putDouble(this.curState.transform.getMxt());
            buf.putDouble(this.curState.transform.getMyx());
            buf.putDouble(this.curState.transform.getMyy());
            buf.putDouble(this.curState.transform.getMyt());
        }
    }

    void updateDimensions() {
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte((byte)71);
        buf.putFloat((float)this.theCanvas.getWidth());
        buf.putFloat((float)this.theCanvas.getHeight());
    }

    private void reset() {
        GrowableDataBuffer buf = this.getBuffer();
        if (buf.writeValuePosition() > 1024 || this.theCanvas.isRendererFallingBehind()) {
            buf.reset();
            buf.putByte((byte)70);
            this.updateDimensions();
            this.txdirty = true;
            this.pathDirty = true;
            State s = this.curState;
            int numClipPaths = this.curState.numClipPaths;
            this.curState = new State();
            for (int i = 0; i < numClipPaths; ++i) {
                Path2D clip = this.clipStack.get(i);
                buf.putByte((byte)13);
                buf.putObject(clip);
            }
            this.curState.numClipPaths = numClipPaths;
            s.restore(this);
        }
    }

    private void resetIfCovers(Paint p, double x, double y, double w, double h) {
        Affine2D tx = this.curState.transform;
        if (tx.isTranslateOrIdentity()) {
            y += tx.getMyt();
            if ((x += tx.getMxt()) > 0.0 || y > 0.0 || x + w < this.theCanvas.getWidth() || y + h < this.theCanvas.getHeight()) {
                return;
            }
        } else {
            return;
        }
        if (p != null) {
            if (this.curState.blendop != BlendMode.SRC_OVER) {
                return;
            }
            if (!p.isOpaque() || this.curState.globalAlpha < 1.0) {
                return;
            }
        }
        if (this.curState.numClipPaths > 0) {
            return;
        }
        if (this.curState.effect != null) {
            return;
        }
        this.reset();
    }

    public Canvas getCanvas() {
        return this.theCanvas;
    }

    public void save() {
        this.stateStack.push(this.curState.copy());
    }

    public void restore() {
        if (!this.stateStack.isEmpty()) {
            State savedState = this.stateStack.pop();
            savedState.restore(this);
            this.txdirty = true;
        }
    }

    public void translate(double x, double y) {
        this.curState.transform.translate(x, y);
        this.txdirty = true;
    }

    public void scale(double x, double y) {
        this.curState.transform.scale(x, y);
        this.txdirty = true;
    }

    public void rotate(double degrees) {
        this.curState.transform.rotate(Math.toRadians(degrees));
        this.txdirty = true;
    }

    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.curState.transform.concatenate(mxx, mxy, mxt, myx, myy, myt);
        this.txdirty = true;
    }

    public void transform(Affine xform) {
        if (xform == null) {
            return;
        }
        this.curState.transform.concatenate(xform.getMxx(), xform.getMxy(), xform.getTx(), xform.getMyx(), xform.getMyy(), xform.getTy());
        this.txdirty = true;
    }

    public void setTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.curState.transform.setTransform(mxx, myx, mxy, myy, mxt, myt);
        this.txdirty = true;
    }

    public void setTransform(Affine xform) {
        this.curState.transform.setTransform(xform.getMxx(), xform.getMyx(), xform.getMxy(), xform.getMyy(), xform.getTx(), xform.getTy());
        this.txdirty = true;
    }

    public Affine getTransform(Affine xform) {
        if (xform == null) {
            xform = new Affine();
        }
        xform.setMxx(this.curState.transform.getMxx());
        xform.setMxy(this.curState.transform.getMxy());
        xform.setMxz(0.0);
        xform.setTx(this.curState.transform.getMxt());
        xform.setMyx(this.curState.transform.getMyx());
        xform.setMyy(this.curState.transform.getMyy());
        xform.setMyz(0.0);
        xform.setTy(this.curState.transform.getMyt());
        xform.setMzx(0.0);
        xform.setMzy(0.0);
        xform.setMzz(1.0);
        xform.setTz(0.0);
        return xform;
    }

    public Affine getTransform() {
        return this.getTransform(null);
    }

    public void setGlobalAlpha(double alpha) {
        if (this.curState.globalAlpha != alpha) {
            this.curState.globalAlpha = alpha;
            alpha = alpha > 1.0 ? 1.0 : (alpha < 0.0 ? 0.0 : alpha);
            this.writeParam(alpha, (byte)0);
        }
    }

    public double getGlobalAlpha() {
        return this.curState.globalAlpha;
    }

    public void setGlobalBlendMode(BlendMode op) {
        if (op != null && op != this.curState.blendop) {
            GrowableDataBuffer buf = this.getBuffer();
            this.curState.blendop = op;
            buf.putByte((byte)1);
            buf.putObject((Object)Blend.impl_getToolkitMode(op));
        }
    }

    public BlendMode getGlobalBlendMode() {
        return this.curState.blendop;
    }

    public void setFill(Paint p) {
        if (p != null && this.curState.fill != p) {
            this.curState.fill = p;
            this.writePaint(p, (byte)2);
        }
    }

    public Paint getFill() {
        return this.curState.fill;
    }

    public void setStroke(Paint p) {
        if (p != null && this.curState.stroke != p) {
            this.curState.stroke = p;
            this.writePaint(p, (byte)3);
        }
    }

    public Paint getStroke() {
        return this.curState.stroke;
    }

    public void setLineWidth(double lw) {
        if (lw > 0.0 && lw < Double.POSITIVE_INFINITY && this.curState.linewidth != lw) {
            this.curState.linewidth = lw;
            this.writeParam(lw, (byte)4);
        }
    }

    public double getLineWidth() {
        return this.curState.linewidth;
    }

    public void setLineCap(StrokeLineCap cap) {
        if (cap != null && this.curState.linecap != cap) {
            byte v;
            switch (cap) {
                case BUTT: {
                    v = 0;
                    break;
                }
                case ROUND: {
                    v = 1;
                    break;
                }
                case SQUARE: {
                    v = 2;
                    break;
                }
                default: {
                    return;
                }
            }
            this.curState.linecap = cap;
            this.writeParam(v, (byte)5);
        }
    }

    public StrokeLineCap getLineCap() {
        return this.curState.linecap;
    }

    public void setLineJoin(StrokeLineJoin join) {
        if (join != null && this.curState.linejoin != join) {
            byte v;
            switch (join) {
                case MITER: {
                    v = 0;
                    break;
                }
                case BEVEL: {
                    v = 2;
                    break;
                }
                case ROUND: {
                    v = 1;
                    break;
                }
                default: {
                    return;
                }
            }
            this.curState.linejoin = join;
            this.writeParam(v, (byte)6);
        }
    }

    public StrokeLineJoin getLineJoin() {
        return this.curState.linejoin;
    }

    public void setMiterLimit(double ml) {
        if (ml > 0.0 && ml < Double.POSITIVE_INFINITY && this.curState.miterlimit != ml) {
            this.curState.miterlimit = ml;
            this.writeParam(ml, (byte)7);
        }
    }

    public double getMiterLimit() {
        return this.curState.miterlimit;
    }

    public void setLineDashes(double ... dashes) {
        if (dashes == null || dashes.length == 0) {
            if (this.curState.dashes == null) {
                return;
            }
            this.curState.dashes = null;
        } else {
            boolean allZeros = true;
            for (int i = 0; i < dashes.length; ++i) {
                double d = dashes[i];
                if (d >= 0.0 && d < Double.POSITIVE_INFINITY) {
                    if (!(d > 0.0)) continue;
                    allZeros = false;
                    continue;
                }
                return;
            }
            if (allZeros) {
                if (this.curState.dashes == null) {
                    return;
                }
                this.curState.dashes = null;
            } else {
                int dashlen = dashes.length;
                if ((dashlen & 1) == 0) {
                    this.curState.dashes = Arrays.copyOf(dashes, dashlen);
                } else {
                    this.curState.dashes = Arrays.copyOf(dashes, dashlen * 2);
                    System.arraycopy(dashes, 0, this.curState.dashes, dashlen, dashlen);
                }
            }
        }
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte((byte)17);
        buf.putObject(this.curState.dashes);
    }

    public double[] getLineDashes() {
        if (this.curState.dashes == null) {
            return null;
        }
        return Arrays.copyOf(this.curState.dashes, this.curState.dashes.length);
    }

    public void setLineDashOffset(double dashOffset) {
        if (dashOffset > Double.NEGATIVE_INFINITY && dashOffset < Double.POSITIVE_INFINITY) {
            this.curState.dashOffset = dashOffset;
            this.writeParam(dashOffset, (byte)18);
        }
    }

    public double getLineDashOffset() {
        return this.curState.dashOffset;
    }

    public void setFont(Font f) {
        if (f != null && this.curState.font != f) {
            this.curState.font = f;
            GrowableDataBuffer buf = this.getBuffer();
            buf.putByte((byte)8);
            buf.putObject(f.impl_getNativeFont());
        }
    }

    public Font getFont() {
        return this.curState.font;
    }

    public void setFontSmoothingType(FontSmoothingType fontsmoothing) {
        if (fontsmoothing != null && fontsmoothing != this.curState.fontsmoothing) {
            this.curState.fontsmoothing = fontsmoothing;
            this.writeParam((byte)fontsmoothing.ordinal(), (byte)19);
        }
    }

    public FontSmoothingType getFontSmoothingType() {
        return this.curState.fontsmoothing;
    }

    public void setTextAlign(TextAlignment align) {
        if (align != null && this.curState.textalign != align) {
            byte a;
            switch (align) {
                case LEFT: {
                    a = 0;
                    break;
                }
                case CENTER: {
                    a = 1;
                    break;
                }
                case RIGHT: {
                    a = 2;
                    break;
                }
                case JUSTIFY: {
                    a = 3;
                    break;
                }
                default: {
                    return;
                }
            }
            this.curState.textalign = align;
            this.writeParam(a, (byte)9);
        }
    }

    public TextAlignment getTextAlign() {
        return this.curState.textalign;
    }

    public void setTextBaseline(VPos baseline) {
        if (baseline != null && this.curState.textbaseline != baseline) {
            byte b;
            switch (baseline) {
                case TOP: {
                    b = 0;
                    break;
                }
                case CENTER: {
                    b = 1;
                    break;
                }
                case BASELINE: {
                    b = 2;
                    break;
                }
                case BOTTOM: {
                    b = 3;
                    break;
                }
                default: {
                    return;
                }
            }
            this.curState.textbaseline = baseline;
            this.writeParam(b, (byte)10);
        }
    }

    public VPos getTextBaseline() {
        return this.curState.textbaseline;
    }

    public void fillText(String text, double x, double y) {
        this.writeText(text, x, y, 0.0, (byte)35);
    }

    public void strokeText(String text, double x, double y) {
        this.writeText(text, x, y, 0.0, (byte)36);
    }

    public void fillText(String text, double x, double y, double maxWidth) {
        if (maxWidth <= 0.0) {
            return;
        }
        this.writeText(text, x, y, maxWidth, (byte)35);
    }

    public void strokeText(String text, double x, double y, double maxWidth) {
        if (maxWidth <= 0.0) {
            return;
        }
        this.writeText(text, x, y, maxWidth, (byte)36);
    }

    public void setFillRule(FillRule fillRule) {
        if (fillRule != null && this.curState.fillRule != fillRule) {
            byte b = fillRule == FillRule.EVEN_ODD ? (byte)1 : 0;
            this.curState.fillRule = fillRule;
            this.writeParam(b, (byte)16);
        }
    }

    public FillRule getFillRule() {
        return this.curState.fillRule;
    }

    public void setImageSmoothing(boolean imageSmoothing) {
        if (this.curState.imageSmoothing != imageSmoothing) {
            this.curState.imageSmoothing = imageSmoothing;
            GrowableDataBuffer buf = this.getBuffer();
            buf.putByte((byte)20);
            buf.putBoolean(this.curState.imageSmoothing);
        }
    }

    public boolean isImageSmoothing() {
        return this.curState.imageSmoothing;
    }

    public void beginPath() {
        this.path.reset();
        this.markPathDirty();
    }

    public void moveTo(double x0, double y0) {
        this.coords[0] = (float)x0;
        this.coords[1] = (float)y0;
        this.curState.transform.transform(this.coords, 0, this.coords, 0, 1);
        this.path.moveTo(this.coords[0], this.coords[1]);
        this.markPathDirty();
    }

    public void lineTo(double x1, double y1) {
        this.coords[0] = (float)x1;
        this.coords[1] = (float)y1;
        this.curState.transform.transform(this.coords, 0, this.coords, 0, 1);
        if (this.path.getNumCommands() == 0) {
            this.path.moveTo(this.coords[0], this.coords[1]);
        }
        this.path.lineTo(this.coords[0], this.coords[1]);
        this.markPathDirty();
    }

    public void quadraticCurveTo(double xc, double yc, double x1, double y1) {
        this.coords[0] = (float)xc;
        this.coords[1] = (float)yc;
        this.coords[2] = (float)x1;
        this.coords[3] = (float)y1;
        this.curState.transform.transform(this.coords, 0, this.coords, 0, 2);
        if (this.path.getNumCommands() == 0) {
            this.path.moveTo(this.coords[0], this.coords[1]);
        }
        this.path.quadTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3]);
        this.markPathDirty();
    }

    public void bezierCurveTo(double xc1, double yc1, double xc2, double yc2, double x1, double y1) {
        this.coords[0] = (float)xc1;
        this.coords[1] = (float)yc1;
        this.coords[2] = (float)xc2;
        this.coords[3] = (float)yc2;
        this.coords[4] = (float)x1;
        this.coords[5] = (float)y1;
        this.curState.transform.transform(this.coords, 0, this.coords, 0, 3);
        if (this.path.getNumCommands() == 0) {
            this.path.moveTo(this.coords[0], this.coords[1]);
        }
        this.path.curveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3], this.coords[4], this.coords[5]);
        this.markPathDirty();
    }

    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        if (this.path.getNumCommands() == 0) {
            this.moveTo(x1, y1);
            this.lineTo(x1, y1);
        } else if (!this.tryArcTo((float)x1, (float)y1, (float)x2, (float)y2, (float)radius)) {
            this.lineTo(x1, y1);
        }
    }

    private static double lenSq(double x0, double y0, double x1, double y1) {
        return (x1 -= x0) * x1 + (y1 -= y0) * y1;
    }

    private boolean tryArcTo(float x1, float y1, float x2, float y2, float radius) {
        boolean ccw;
        double ty1;
        double ty0;
        double my;
        double tx1;
        float y0;
        float x0;
        if (this.curState.transform.isTranslateOrIdentity()) {
            x0 = (float)((double)this.path.getCurrentX() - this.curState.transform.getMxt());
            y0 = (float)((double)this.path.getCurrentY() - this.curState.transform.getMyt());
        } else {
            this.coords[0] = this.path.getCurrentX();
            this.coords[1] = this.path.getCurrentY();
            try {
                this.curState.transform.inverseTransform(this.coords, 0, this.coords, 0, 1);
            }
            catch (NoninvertibleTransformException e) {
                return false;
            }
            x0 = this.coords[0];
            y0 = this.coords[1];
        }
        double lsq01 = GraphicsContext.lenSq(x0, y0, x1, y1);
        double lsq12 = GraphicsContext.lenSq(x1, y1, x2, y2);
        double lsq02 = GraphicsContext.lenSq(x0, y0, x2, y2);
        double len01 = Math.sqrt(lsq01);
        double len12 = Math.sqrt(lsq12);
        double cosnum = lsq01 + lsq12 - lsq02;
        double cosden = 2.0 * len01 * len12;
        if (cosden == 0.0 || radius <= 0.0f) {
            return false;
        }
        double cos_2theta = cosnum / cosden;
        double tansq_den = 1.0 + cos_2theta;
        if (tansq_den == 0.0) {
            return false;
        }
        double tansq_theta = (1.0 - cos_2theta) / tansq_den;
        double A = (double)radius / Math.sqrt(tansq_theta);
        double tx0 = (double)x1 + A / len01 * (double)(x0 - x1);
        double mx = (tx0 + (tx1 = (double)x1 + A / len12 * (double)(x2 - x1))) / 2.0;
        double lenratioden = GraphicsContext.lenSq(mx, my = ((ty0 = (double)y1 + A / len01 * (double)(y0 - y1)) + (ty1 = (double)y1 + A / len12 * (double)(y2 - y1))) / 2.0, x1, y1);
        if (lenratioden == 0.0) {
            return false;
        }
        double lenratio = GraphicsContext.lenSq(mx, my, tx0, ty0) / lenratioden;
        double cx = mx + (mx - (double)x1) * lenratio;
        double cy = my + (my - (double)y1) * lenratio;
        if (cx != cx || cy != cy) {
            return false;
        }
        if (tx0 != (double)x0 || ty0 != (double)y0) {
            this.lineTo(tx0, ty0);
        }
        double coshalfarc = Math.sqrt((1.0 - cos_2theta) / 2.0);
        boolean bl = ccw = (ty0 - cy) * (tx1 - cx) > (ty1 - cy) * (tx0 - cx);
        if (cos_2theta <= 0.0) {
            double sinhalfarc = Math.sqrt((1.0 + cos_2theta) / 2.0);
            double cv = 1.3333333333333333 * sinhalfarc / (1.0 + coshalfarc);
            if (ccw) {
                cv = -cv;
            }
            double cpx0 = tx0 - cv * (ty0 - cy);
            double cpy0 = ty0 + cv * (tx0 - cx);
            double cpx1 = tx1 + cv * (ty1 - cy);
            double cpy1 = ty1 - cv * (tx1 - cx);
            this.bezierCurveTo(cpx0, cpy0, cpx1, cpy1, tx1, ty1);
        } else {
            double sinqtrarc = Math.sqrt((1.0 - coshalfarc) / 2.0);
            double cosqtrarc = Math.sqrt((1.0 + coshalfarc) / 2.0);
            double cv = 1.3333333333333333 * sinqtrarc / (1.0 + cosqtrarc);
            if (ccw) {
                cv = -cv;
            }
            double midratio = (double)radius / Math.sqrt(lenratioden);
            double midarcx = cx + ((double)x1 - mx) * midratio;
            double midarcy = cy + ((double)y1 - my) * midratio;
            double cpx0 = tx0 - cv * (ty0 - cy);
            double cpy0 = ty0 + cv * (tx0 - cx);
            double cpx1 = midarcx + cv * (midarcy - cy);
            double cpy1 = midarcy - cv * (midarcx - cx);
            this.bezierCurveTo(cpx0, cpy0, cpx1, cpy1, midarcx, midarcy);
            cpx0 = midarcx - cv * (midarcy - cy);
            cpy0 = midarcy + cv * (midarcx - cx);
            cpx1 = tx1 + cv * (ty1 - cy);
            cpy1 = ty1 - cv * (tx1 - cx);
            this.bezierCurveTo(cpx0, cpy0, cpx1, cpy1, tx1, ty1);
        }
        return true;
    }

    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
        Arc2D arc = new Arc2D((float)(centerX - radiusX), (float)(centerY - radiusY), (float)(radiusX * 2.0), (float)(radiusY * 2.0), (float)startAngle, (float)length, 0);
        this.path.append(arc.getPathIterator(this.curState.transform), true);
        this.markPathDirty();
    }

    public void rect(double x, double y, double w, double h) {
        this.coords[0] = (float)x;
        this.coords[1] = (float)y;
        this.coords[2] = (float)w;
        this.coords[3] = 0.0f;
        this.coords[4] = 0.0f;
        this.coords[5] = (float)h;
        this.curState.transform.deltaTransform(this.coords, 0, this.coords, 0, 3);
        float x0 = this.coords[0] + (float)this.curState.transform.getMxt();
        float y0 = this.coords[1] + (float)this.curState.transform.getMyt();
        float dx1 = this.coords[2];
        float dy1 = this.coords[3];
        float dx2 = this.coords[4];
        float dy2 = this.coords[5];
        this.path.moveTo(x0, y0);
        this.path.lineTo(x0 + dx1, y0 + dy1);
        this.path.lineTo(x0 + dx1 + dx2, y0 + dy1 + dy2);
        this.path.lineTo(x0 + dx2, y0 + dy2);
        this.path.closePath();
        this.markPathDirty();
    }

    public void appendSVGPath(String svgpath) {
        boolean skipMoveto;
        boolean prependMoveto;
        block17: {
            if (svgpath == null) {
                return;
            }
            prependMoveto = true;
            skipMoveto = true;
            block9: for (int i = 0; i < svgpath.length(); ++i) {
                switch (svgpath.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block9;
                    }
                    case 'M': {
                        skipMoveto = false;
                        prependMoveto = false;
                        break block17;
                    }
                    case 'm': {
                        if (this.path.getNumCommands() == 0) {
                            prependMoveto = false;
                        }
                        skipMoveto = false;
                    }
                }
            }
        }
        Path2D p2d = new Path2D();
        if (prependMoveto && this.path.getNumCommands() > 0) {
            float y0;
            float x0;
            if (this.curState.transform.isTranslateOrIdentity()) {
                x0 = (float)((double)this.path.getCurrentX() - this.curState.transform.getMxt());
                y0 = (float)((double)this.path.getCurrentY() - this.curState.transform.getMyt());
            } else {
                this.coords[0] = this.path.getCurrentX();
                this.coords[1] = this.path.getCurrentY();
                try {
                    this.curState.transform.inverseTransform(this.coords, 0, this.coords, 0, 1);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
                x0 = this.coords[0];
                y0 = this.coords[1];
            }
            p2d.moveTo(x0, y0);
        } else {
            skipMoveto = false;
        }
        try {
            p2d.appendSVGPath(svgpath);
            PathIterator pi = p2d.getPathIterator(this.curState.transform);
            if (skipMoveto) {
                pi.next();
            }
            this.path.append(pi, false);
        }
        catch (IllegalPathStateException | IllegalArgumentException runtimeException) {
            // empty catch block
        }
    }

    public void closePath() {
        if (this.path.getNumCommands() > 0) {
            this.path.closePath();
            this.markPathDirty();
        }
    }

    public void fill() {
        this.writePath((byte)47);
    }

    public void stroke() {
        this.writePath((byte)48);
    }

    public void clip() {
        Path2D clip = new Path2D(this.path);
        this.clipStack.addLast(clip);
        ++this.curState.numClipPaths;
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte((byte)13);
        buf.putObject(clip);
    }

    public boolean isPointInPath(double x, double y) {
        return this.path.contains((float)x, (float)y);
    }

    public void clearRect(double x, double y, double w, double h) {
        if (w != 0.0 && h != 0.0) {
            this.resetIfCovers(null, x, y, w, h);
            this.writeOp4(x, y, w, h, (byte)27);
        }
    }

    public void fillRect(double x, double y, double w, double h) {
        if (w != 0.0 && h != 0.0) {
            this.resetIfCovers(this.curState.fill, x, y, w, h);
            this.writeOp4(x, y, w, h, (byte)25);
        }
    }

    public void strokeRect(double x, double y, double w, double h) {
        if (w != 0.0 || h != 0.0) {
            this.writeOp4(x, y, w, h, (byte)26);
        }
    }

    public void fillOval(double x, double y, double w, double h) {
        if (w != 0.0 && h != 0.0) {
            this.writeOp4(x, y, w, h, (byte)29);
        }
    }

    public void strokeOval(double x, double y, double w, double h) {
        if (w != 0.0 || h != 0.0) {
            this.writeOp4(x, y, w, h, (byte)30);
        }
    }

    public void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
        if (w != 0.0 && h != 0.0 && closure != null) {
            this.writeArcType(closure);
            this.writeOp6(x, y, w, h, startAngle, arcExtent, (byte)33);
        }
    }

    public void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
        if (w != 0.0 && h != 0.0 && closure != null) {
            this.writeArcType(closure);
            this.writeOp6(x, y, w, h, startAngle, arcExtent, (byte)34);
        }
    }

    public void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        if (w != 0.0 && h != 0.0) {
            this.writeOp6(x, y, w, h, arcWidth, arcHeight, (byte)31);
        }
    }

    public void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        if (w != 0.0 && h != 0.0) {
            this.writeOp6(x, y, w, h, arcWidth, arcHeight, (byte)32);
        }
    }

    public void strokeLine(double x1, double y1, double x2, double y2) {
        this.writeOp4(x1, y1, x2, y2, (byte)28);
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints >= 3) {
            this.writePoly(xPoints, yPoints, nPoints, true, (byte)47);
        }
    }

    public void strokePolygon(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints >= 2) {
            this.writePoly(xPoints, yPoints, nPoints, true, (byte)48);
        }
    }

    public void strokePolyline(double[] xPoints, double[] yPoints, int nPoints) {
        if (nPoints >= 2) {
            this.writePoly(xPoints, yPoints, nPoints, false, (byte)48);
        }
    }

    public void drawImage(Image img, double x, double y) {
        if (img == null) {
            return;
        }
        double sw = img.getWidth();
        double sh = img.getHeight();
        this.writeImage(img, x, y, sw, sh);
    }

    public void drawImage(Image img, double x, double y, double w, double h) {
        this.writeImage(img, x, y, w, h);
    }

    public void drawImage(Image img, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        this.writeImage(img, dx, dy, dw, dh, sx, sy, sw, sh);
    }

    public PixelWriter getPixelWriter() {
        if (this.writer == null) {
            this.writer = new PixelWriter(){

                @Override
                public PixelFormat<ByteBuffer> getPixelFormat() {
                    return PixelFormat.getByteBgraPreInstance();
                }

                private BytePixelSetter getSetter() {
                    return ByteBgraPre.setter;
                }

                @Override
                public void setArgb(int x, int y, int argb) {
                    GrowableDataBuffer buf = GraphicsContext.this.getBuffer();
                    buf.putByte((byte)52);
                    buf.putInt(x);
                    buf.putInt(y);
                    buf.putInt(argb);
                }

                @Override
                public void setColor(int x, int y, Color c) {
                    if (c == null) {
                        throw new NullPointerException("Color cannot be null");
                    }
                    int a = (int)Math.round(c.getOpacity() * 255.0);
                    int r = (int)Math.round(c.getRed() * 255.0);
                    int g = (int)Math.round(c.getGreen() * 255.0);
                    int b = (int)Math.round(c.getBlue() * 255.0);
                    this.setArgb(x, y, a << 24 | r << 16 | g << 8 | b);
                }

                private void writePixelBuffer(int x, int y, int w, int h, byte[] pixels) {
                    GrowableDataBuffer buf = GraphicsContext.this.getBuffer();
                    buf.putByte((byte)53);
                    buf.putInt(x);
                    buf.putInt(y);
                    buf.putInt(w);
                    buf.putInt(h);
                    buf.putObject(pixels);
                }

                private int[] checkBounds(int x, int y, int w, int h, PixelFormat<? extends Buffer> pf, int scan) {
                    int cw = (int)Math.ceil(GraphicsContext.this.theCanvas.getWidth());
                    int ch = (int)Math.ceil(GraphicsContext.this.theCanvas.getHeight());
                    if (x >= 0 && y >= 0 && x + w <= cw && y + h <= ch) {
                        return null;
                    }
                    int offset = 0;
                    if (x < 0) {
                        if ((w += x) < 0) {
                            return null;
                        }
                        if (pf != null) {
                            switch (pf.getType()) {
                                case BYTE_BGRA: 
                                case BYTE_BGRA_PRE: {
                                    offset -= x * 4;
                                    break;
                                }
                                case BYTE_RGB: {
                                    offset -= x * 3;
                                    break;
                                }
                                case BYTE_INDEXED: 
                                case INT_ARGB: 
                                case INT_ARGB_PRE: {
                                    offset -= x;
                                    break;
                                }
                                default: {
                                    throw new InternalError("unknown Pixel Format");
                                }
                            }
                        }
                        x = 0;
                    }
                    if (y < 0) {
                        if ((h += y) < 0) {
                            return null;
                        }
                        offset -= y * scan;
                        y = 0;
                    }
                    if (x + w > cw && (w = cw - x) < 0) {
                        return null;
                    }
                    if (y + h > ch && (h = ch - y) < 0) {
                        return null;
                    }
                    return new int[]{x, y, w, h, offset};
                }

                @Override
                public <T extends Buffer> void setPixels(int x, int y, int w, int h, PixelFormat<T> pixelformat, T buffer, int scan) {
                    if (pixelformat == null) {
                        throw new NullPointerException("PixelFormat cannot be null");
                    }
                    if (buffer == null) {
                        throw new NullPointerException("Buffer cannot be null");
                    }
                    if (w <= 0 || h <= 0) {
                        return;
                    }
                    int offset = buffer.position();
                    int[] adjustments = this.checkBounds(x, y, w, h, pixelformat, scan);
                    if (adjustments != null) {
                        x = adjustments[0];
                        y = adjustments[1];
                        w = adjustments[2];
                        h = adjustments[3];
                        offset += adjustments[4];
                    }
                    byte[] pixels = new byte[w * h * 4];
                    ByteBuffer dst = ByteBuffer.wrap(pixels);
                    PixelGetter<T> getter = PixelUtils.getGetter(pixelformat);
                    PixelConverter<T, ByteBuffer> converter = PixelUtils.getConverter(getter, this.getSetter());
                    converter.convert(buffer, offset, scan, dst, 0, w * 4, w, h);
                    this.writePixelBuffer(x, y, w, h, pixels);
                }

                @Override
                public void setPixels(int x, int y, int w, int h, PixelFormat<ByteBuffer> pixelformat, byte[] buffer, int offset, int scanlineStride) {
                    if (pixelformat == null) {
                        throw new NullPointerException("PixelFormat cannot be null");
                    }
                    if (buffer == null) {
                        throw new NullPointerException("Buffer cannot be null");
                    }
                    if (w <= 0 || h <= 0) {
                        return;
                    }
                    int[] adjustments = this.checkBounds(x, y, w, h, pixelformat, scanlineStride);
                    if (adjustments != null) {
                        x = adjustments[0];
                        y = adjustments[1];
                        w = adjustments[2];
                        h = adjustments[3];
                        offset += adjustments[4];
                    }
                    byte[] pixels = new byte[w * h * 4];
                    BytePixelGetter getter = PixelUtils.getByteGetter(pixelformat);
                    ByteToBytePixelConverter converter = PixelUtils.getB2BConverter(getter, this.getSetter());
                    converter.convert(buffer, offset, scanlineStride, pixels, 0, w * 4, w, h);
                    this.writePixelBuffer(x, y, w, h, pixels);
                }

                @Override
                public void setPixels(int x, int y, int w, int h, PixelFormat<IntBuffer> pixelformat, int[] buffer, int offset, int scanlineStride) {
                    if (pixelformat == null) {
                        throw new NullPointerException("PixelFormat cannot be null");
                    }
                    if (buffer == null) {
                        throw new NullPointerException("Buffer cannot be null");
                    }
                    if (w <= 0 || h <= 0) {
                        return;
                    }
                    int[] adjustments = this.checkBounds(x, y, w, h, pixelformat, scanlineStride);
                    if (adjustments != null) {
                        x = adjustments[0];
                        y = adjustments[1];
                        w = adjustments[2];
                        h = adjustments[3];
                        offset += adjustments[4];
                    }
                    byte[] pixels = new byte[w * h * 4];
                    IntPixelGetter getter = PixelUtils.getIntGetter(pixelformat);
                    IntToBytePixelConverter converter = PixelUtils.getI2BConverter(getter, this.getSetter());
                    converter.convert(buffer, offset, scanlineStride, pixels, 0, w * 4, w, h);
                    this.writePixelBuffer(x, y, w, h, pixels);
                }

                @Override
                public void setPixels(int dstx, int dsty, int w, int h, PixelReader reader, int srcx, int srcy) {
                    if (reader == null) {
                        throw new NullPointerException("Reader cannot be null");
                    }
                    if (w <= 0 || h <= 0) {
                        return;
                    }
                    int[] adjustments = this.checkBounds(dstx, dsty, w, h, null, 0);
                    if (adjustments != null) {
                        int newx = adjustments[0];
                        int newy = adjustments[1];
                        srcx += newx - dstx;
                        srcy += newy - dsty;
                        dstx = newx;
                        dsty = newy;
                        w = adjustments[2];
                        h = adjustments[3];
                    }
                    byte[] pixels = new byte[w * h * 4];
                    reader.getPixels(srcx, srcy, w, h, PixelFormat.getByteBgraPreInstance(), pixels, 0, w * 4);
                    this.writePixelBuffer(dstx, dsty, w, h, pixels);
                }
            };
        }
        return this.writer;
    }

    public void setEffect(Effect e) {
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte((byte)12);
        if (e == null) {
            this.curState.effect = null;
            buf.putObject(null);
        } else {
            this.curState.effect = e.impl_copy();
            this.curState.effect.impl_sync();
            buf.putObject(this.curState.effect.impl_getImpl());
        }
    }

    public Effect getEffect(Effect e) {
        return this.curState.effect == null ? null : this.curState.effect.impl_copy();
    }

    public void applyEffect(Effect e) {
        if (e == null) {
            return;
        }
        GrowableDataBuffer buf = this.getBuffer();
        buf.putByte((byte)60);
        Effect effect = e.impl_copy();
        effect.impl_sync();
        buf.putObject(effect.impl_getImpl());
    }

    static class State {
        double globalAlpha;
        BlendMode blendop;
        Affine2D transform;
        Paint fill;
        Paint stroke;
        double linewidth;
        StrokeLineCap linecap;
        StrokeLineJoin linejoin;
        double miterlimit;
        double[] dashes;
        double dashOffset;
        int numClipPaths;
        Font font;
        FontSmoothingType fontsmoothing;
        TextAlignment textalign;
        VPos textbaseline;
        Effect effect;
        FillRule fillRule;
        boolean imageSmoothing = true;

        State() {
            this.init();
        }

        final void init() {
            this.set(1.0, BlendMode.SRC_OVER, new Affine2D(), Color.BLACK, Color.BLACK, 1.0, StrokeLineCap.SQUARE, StrokeLineJoin.MITER, 10.0, null, 0.0, 0, Font.getDefault(), FontSmoothingType.GRAY, TextAlignment.LEFT, VPos.BASELINE, null, FillRule.NON_ZERO, true);
        }

        State(State copy) {
            this.set(copy.globalAlpha, copy.blendop, new Affine2D(copy.transform), copy.fill, copy.stroke, copy.linewidth, copy.linecap, copy.linejoin, copy.miterlimit, copy.dashes, copy.dashOffset, copy.numClipPaths, copy.font, copy.fontsmoothing, copy.textalign, copy.textbaseline, copy.effect, copy.fillRule, copy.imageSmoothing);
        }

        final void set(double globalAlpha, BlendMode blendop, Affine2D transform, Paint fill, Paint stroke, double linewidth, StrokeLineCap linecap, StrokeLineJoin linejoin, double miterlimit, double[] dashes, double dashOffset, int numClipPaths, Font font, FontSmoothingType smoothing, TextAlignment align, VPos baseline, Effect effect, FillRule fillRule, boolean imageSmoothing) {
            this.globalAlpha = globalAlpha;
            this.blendop = blendop;
            this.transform = transform;
            this.fill = fill;
            this.stroke = stroke;
            this.linewidth = linewidth;
            this.linecap = linecap;
            this.linejoin = linejoin;
            this.miterlimit = miterlimit;
            this.dashes = dashes;
            this.dashOffset = dashOffset;
            this.numClipPaths = numClipPaths;
            this.font = font;
            this.fontsmoothing = smoothing;
            this.textalign = align;
            this.textbaseline = baseline;
            this.effect = effect;
            this.fillRule = fillRule;
            this.imageSmoothing = imageSmoothing;
        }

        State copy() {
            return new State(this);
        }

        void restore(GraphicsContext ctx) {
            ctx.setGlobalAlpha(this.globalAlpha);
            ctx.setGlobalBlendMode(this.blendop);
            ctx.setTransform(this.transform.getMxx(), this.transform.getMyx(), this.transform.getMxy(), this.transform.getMyy(), this.transform.getMxt(), this.transform.getMyt());
            ctx.setFill(this.fill);
            ctx.setStroke(this.stroke);
            ctx.setLineWidth(this.linewidth);
            ctx.setLineCap(this.linecap);
            ctx.setLineJoin(this.linejoin);
            ctx.setMiterLimit(this.miterlimit);
            ctx.setLineDashes(this.dashes);
            ctx.setLineDashOffset(this.dashOffset);
            GrowableDataBuffer buf = ctx.getBuffer();
            while (ctx.curState.numClipPaths > this.numClipPaths) {
                --ctx.curState.numClipPaths;
                ctx.clipStack.removeLast();
                buf.putByte((byte)14);
            }
            ctx.setFillRule(this.fillRule);
            ctx.setFont(this.font);
            ctx.setFontSmoothingType(this.fontsmoothing);
            ctx.setTextAlign(this.textalign);
            ctx.setTextBaseline(this.textbaseline);
            ctx.setEffect(this.effect);
            ctx.setImageSmoothing(this.imageSmoothing);
        }
    }
}

