/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.converters.URLConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGImageView;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.image.Image;

@DefaultProperty(value="image")
public class ImageView
extends Node {
    private ObjectProperty<Image> image;
    private Image oldImage;
    private StringProperty imageUrl = null;
    private final AbstractNotifyListener platformImageChangeListener = new AbstractNotifyListener(){

        @Override
        public void invalidated(Observable valueModel) {
            ImageView.this.invalidateWidthHeight();
            ImageView.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
            ImageView.this.impl_geomChanged();
        }
    };
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty fitWidth;
    private DoubleProperty fitHeight;
    private BooleanProperty preserveRatio;
    private BooleanProperty smooth;
    public static final boolean SMOOTH_DEFAULT = Toolkit.getToolkit().getDefaultImageSmooth();
    private ObjectProperty<Rectangle2D> viewport;
    private double destWidth;
    private double destHeight;
    private boolean validWH;
    private static final String DEFAULT_STYLE_CLASS = "image-view";

    public ImageView() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.IMAGE_VIEW);
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
    }

    public ImageView(String url) {
        this(new Image(url));
    }

    public ImageView(Image image) {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.IMAGE_VIEW);
        this.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.setImage(image);
    }

    public final void setImage(Image value) {
        this.imageProperty().set(value);
    }

    public final Image getImage() {
        return this.image == null ? null : (Image)this.image.get();
    }

    public final ObjectProperty<Image> imageProperty() {
        if (this.image == null) {
            this.image = new ObjectPropertyBase<Image>(){
                private boolean needsListeners = false;

                @Override
                public void invalidated() {
                    boolean dimensionChanged;
                    Image _image = (Image)this.get();
                    boolean bl = dimensionChanged = _image == null || ImageView.this.oldImage == null || ImageView.this.oldImage.getWidth() != _image.getWidth() || ImageView.this.oldImage.getHeight() != _image.getHeight();
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(ImageView.this.oldImage).removeListener(ImageView.this.platformImageChangeListener.getWeakListener());
                    }
                    this.needsListeners = _image != null && (_image.isAnimation() || _image.getProgress() < 1.0);
                    ImageView.this.oldImage = _image;
                    if (this.needsListeners) {
                        Toolkit.getImageAccessor().getImageProperty(_image).addListener(ImageView.this.platformImageChangeListener.getWeakListener());
                    }
                    if (dimensionChanged) {
                        ImageView.this.invalidateWidthHeight();
                        ImageView.this.impl_geomChanged();
                    }
                    ImageView.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "image";
                }
            };
        }
        return this.image;
    }

    private StringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new StyleableStringProperty(){

                @Override
                protected void invalidated() {
                    String imageUrl = this.get();
                    if (imageUrl != null) {
                        ImageView.this.setImage(StyleManager.getInstance().getCachedImage(imageUrl));
                    } else {
                        ImageView.this.setImage(null);
                    }
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "imageUrl";
                }

                @Override
                public CssMetaData<ImageView, String> getCssMetaData() {
                    return StyleableProperties.IMAGE;
                }
            };
        }
        return this.imageUrl;
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setFitWidth(double value) {
        this.fitWidthProperty().set(value);
    }

    public final double getFitWidth() {
        return this.fitWidth == null ? 0.0 : this.fitWidth.get();
    }

    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.invalidateWidthHeight();
                    ImageView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "fitWidth";
                }
            };
        }
        return this.fitWidth;
    }

    public final void setFitHeight(double value) {
        this.fitHeightProperty().set(value);
    }

    public final double getFitHeight() {
        return this.fitHeight == null ? 0.0 : this.fitHeight.get();
    }

    public final DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.invalidateWidthHeight();
                    ImageView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "fitHeight";
                }
            };
        }
        return this.fitHeight;
    }

    public final void setPreserveRatio(boolean value) {
        this.preserveRatioProperty().set(value);
    }

    public final boolean isPreserveRatio() {
        return this.preserveRatio == null ? false : this.preserveRatio.get();
    }

    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.invalidateWidthHeight();
                    ImageView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "preserveRatio";
                }
            };
        }
        return this.preserveRatio;
    }

    public final void setSmooth(boolean value) {
        this.smoothProperty().set(value);
    }

    public final boolean isSmooth() {
        return this.smooth == null ? SMOOTH_DEFAULT : this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new BooleanPropertyBase(SMOOTH_DEFAULT){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_SMOOTH);
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "smooth";
                }
            };
        }
        return this.smooth;
    }

    public final void setViewport(Rectangle2D value) {
        this.viewportProperty().set(value);
    }

    public final Rectangle2D getViewport() {
        return this.viewport == null ? null : (Rectangle2D)this.viewport.get();
    }

    public final ObjectProperty<Rectangle2D> viewportProperty() {
        if (this.viewport == null) {
            this.viewport = new ObjectPropertyBase<Rectangle2D>(){

                @Override
                protected void invalidated() {
                    ImageView.this.invalidateWidthHeight();
                    ImageView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "viewport";
                }
            };
        }
        return this.viewport;
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGImageView();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        this.recomputeWidthHeight();
        bounds = bounds.deriveWithNewBounds((float)this.getX(), (float)this.getY(), 0.0f, (float)(this.getX() + this.destWidth), (float)(this.getY() + this.destHeight), 0.0f);
        bounds = tx.transform(bounds, bounds);
        return bounds;
    }

    private void invalidateWidthHeight() {
        this.validWH = false;
    }

    private void recomputeWidthHeight() {
        if (this.validWH) {
            return;
        }
        Image localImage = this.getImage();
        Rectangle2D localViewport = this.getViewport();
        double w = 0.0;
        double h = 0.0;
        if (localViewport != null && localViewport.getWidth() > 0.0 && localViewport.getHeight() > 0.0) {
            w = localViewport.getWidth();
            h = localViewport.getHeight();
        } else if (localImage != null) {
            w = localImage.getWidth();
            h = localImage.getHeight();
        }
        double localFitWidth = this.getFitWidth();
        double localFitHeight = this.getFitHeight();
        if (this.isPreserveRatio() && w > 0.0 && h > 0.0 && (localFitWidth > 0.0 || localFitHeight > 0.0)) {
            if (localFitWidth <= 0.0 || localFitHeight > 0.0 && localFitWidth * h > localFitHeight * w) {
                w = w * localFitHeight / h;
                h = localFitHeight;
            } else {
                h = h * localFitWidth / w;
                w = localFitWidth;
            }
        } else {
            if (localFitWidth > 0.0) {
                w = localFitWidth;
            }
            if (localFitHeight > 0.0) {
                h = localFitHeight;
            }
        }
        this.destWidth = w;
        this.destHeight = h;
        this.validWH = true;
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double localX, double localY) {
        if (this.getImage() == null) {
            return false;
        }
        this.recomputeWidthHeight();
        double dx = localX - this.getX();
        double dy = localY - this.getY();
        Image localImage = this.getImage();
        double srcWidth = localImage.getWidth();
        double srcHeight = localImage.getHeight();
        double viewWidth = srcWidth;
        double viewHeight = srcHeight;
        double vw = 0.0;
        double vh = 0.0;
        double vminx = 0.0;
        double vminy = 0.0;
        Rectangle2D localViewport = this.getViewport();
        if (localViewport != null) {
            vw = localViewport.getWidth();
            vh = localViewport.getHeight();
            vminx = localViewport.getMinX();
            vminy = localViewport.getMinY();
        }
        if (vw > 0.0 && vh > 0.0) {
            viewWidth = vw;
            viewHeight = vh;
        }
        dx = vminx + dx * viewWidth / this.destWidth;
        dy = vminy + dy * viewHeight / this.destHeight;
        if (dx < 0.0 || dy < 0.0 || dx >= srcWidth || dy >= srcHeight || dx < vminx || dy < vminy || dx >= vminx + viewWidth || dy >= vminy + viewHeight) {
            return false;
        }
        return Toolkit.getToolkit().imageContains(localImage.impl_getPlatformImage(), (float)dx, (float)dy);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ImageView.getClassCssMetaData();
    }

    void updateViewport() {
        this.recomputeWidthHeight();
        if (this.getImage() == null || this.getImage().impl_getPlatformImage() == null) {
            return;
        }
        Rectangle2D localViewport = this.getViewport();
        NGImageView peer = (NGImageView)this.impl_getPeer();
        if (localViewport != null) {
            peer.setViewport((float)localViewport.getMinX(), (float)localViewport.getMinY(), (float)localViewport.getWidth(), (float)localViewport.getHeight(), (float)this.destWidth, (float)this.destHeight);
        } else {
            peer.setViewport(0.0f, 0.0f, 0.0f, 0.0f, (float)this.destWidth, (float)this.destHeight);
        }
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        NGImageView peer = (NGImageView)this.impl_getPeer();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            peer.setX((float)this.getX());
            peer.setY((float)this.getY());
        }
        if (this.impl_isDirty(DirtyBits.NODE_SMOOTH)) {
            peer.setSmooth(this.isSmooth());
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            peer.setImage(this.getImage() != null ? this.getImage().impl_getPlatformImage() : null);
        }
        if (this.impl_isDirty(DirtyBits.NODE_VIEWPORT) || this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            this.updateViewport();
        }
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm alg, MXNodeAlgorithmContext ctx) {
        return alg.processLeafNode(this, ctx);
    }

    private static class StyleableProperties {
        private static final CssMetaData<ImageView, String> IMAGE = new CssMetaData<ImageView, String>("-fx-image", URLConverter.getInstance()){

            @Override
            public boolean isSettable(ImageView n) {
                return n.image == null || !n.image.isBound();
            }

            @Override
            public StyleableProperty<String> getStyleableProperty(ImageView n) {
                return (StyleableProperty)((Object)n.imageUrlProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Node.getClassCssMetaData());
            styleables.add(IMAGE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

