/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.TouchPoint;

public final class TouchEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<TouchEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "TOUCH");
    public static final EventType<TouchEvent> TOUCH_PRESSED = new EventType<TouchEvent>(ANY, "TOUCH_PRESSED");
    public static final EventType<TouchEvent> TOUCH_MOVED = new EventType<TouchEvent>(ANY, "TOUCH_MOVED");
    public static final EventType<TouchEvent> TOUCH_RELEASED = new EventType<TouchEvent>(ANY, "TOUCH_RELEASED");
    public static final EventType<TouchEvent> TOUCH_STATIONARY = new EventType<TouchEvent>(ANY, "TOUCH_STATIONARY");
    private final int eventSetId;
    private final boolean shiftDown;
    private final boolean controlDown;
    private final boolean altDown;
    private final boolean metaDown;
    private final TouchPoint touchPoint;
    private final List<TouchPoint> touchPoints;

    public TouchEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<TouchEvent> eventType, @NamedArg(value="touchPoint") TouchPoint touchPoint, @NamedArg(value="touchPoints") List<TouchPoint> touchPoints, @NamedArg(value="eventSetId") int eventSetId, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown) {
        super(source, target, (EventType<? extends InputEvent>)eventType);
        this.touchPoints = touchPoints != null ? Collections.unmodifiableList(touchPoints) : null;
        this.eventSetId = eventSetId;
        this.shiftDown = shiftDown;
        this.controlDown = controlDown;
        this.altDown = altDown;
        this.metaDown = metaDown;
        this.touchPoint = touchPoint;
    }

    public TouchEvent(@NamedArg(value="eventType") EventType<TouchEvent> eventType, @NamedArg(value="touchPoint") TouchPoint touchPoint, @NamedArg(value="touchPoints") List<TouchPoint> touchPoints, @NamedArg(value="eventSetId") int eventSetId, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown) {
        this(null, null, eventType, touchPoint, touchPoints, eventSetId, shiftDown, controlDown, altDown, metaDown);
    }

    public int getTouchCount() {
        return this.touchPoints.size();
    }

    private static void recomputeToSource(TouchEvent event, Object oldSource, Object newSource) {
        for (TouchPoint tp : event.touchPoints) {
            tp.recomputeToSource(oldSource, newSource);
        }
    }

    @Override
    public TouchEvent copyFor(Object newSource, EventTarget newTarget) {
        TouchEvent e = (TouchEvent)super.copyFor(newSource, newTarget);
        TouchEvent.recomputeToSource(e, this.getSource(), newSource);
        return e;
    }

    public TouchEvent copyFor(Object newSource, EventTarget newTarget, EventType<TouchEvent> type) {
        TouchEvent e = this.copyFor(newSource, newTarget);
        e.eventType = type;
        return e;
    }

    public EventType<TouchEvent> getEventType() {
        return super.getEventType();
    }

    public final int getEventSetId() {
        return this.eventSetId;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public TouchPoint getTouchPoint() {
        return this.touchPoint;
    }

    public List<TouchPoint> getTouchPoints() {
        return this.touchPoints;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TouchEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", touchCount = ").append(this.getTouchCount());
        sb.append(", eventSetId = ").append(this.getEventSetId());
        sb.append(", touchPoint = ").append(this.getTouchPoint().toString());
        return sb.append("]").toString();
    }
}

