/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.Point2D;
import java.lang.ref.SoftReference;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.Font2D;
import sun.font.FontManagerNativeLibrary;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.GlyphLayout;
import sun.font.PhysicalFont;
import sun.font.TextRecord;
import sun.font.TrueTypeFont;

public final class SunLayoutEngine
implements GlyphLayout.LayoutEngine,
GlyphLayout.LayoutEngineFactory {
    private GlyphLayout.LayoutEngineKey key;
    private static GlyphLayout.LayoutEngineFactory instance;
    private SoftReference cacheref = new SoftReference<Object>(null);
    static WeakHashMap<Font2D, Boolean> aatInfo;

    private static native void initGVIDs();

    public static GlyphLayout.LayoutEngineFactory instance() {
        if (instance == null) {
            instance = new SunLayoutEngine();
        }
        return instance;
    }

    private SunLayoutEngine() {
    }

    @Override
    public GlyphLayout.LayoutEngine getEngine(Font2D font2D, int n, int n2) {
        return this.getEngine(new GlyphLayout.LayoutEngineKey(font2D, n, n2));
    }

    @Override
    public GlyphLayout.LayoutEngine getEngine(GlyphLayout.LayoutEngineKey layoutEngineKey) {
        GlyphLayout.LayoutEngine layoutEngine;
        ConcurrentHashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine> concurrentHashMap = (ConcurrentHashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine>)this.cacheref.get();
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine>();
            this.cacheref = new SoftReference(concurrentHashMap);
        }
        if ((layoutEngine = (GlyphLayout.LayoutEngine)concurrentHashMap.get(layoutEngineKey)) == null) {
            GlyphLayout.LayoutEngineKey layoutEngineKey2 = layoutEngineKey.copy();
            layoutEngine = new SunLayoutEngine(layoutEngineKey2);
            concurrentHashMap.put(layoutEngineKey2, layoutEngine);
        }
        return layoutEngine;
    }

    private SunLayoutEngine(GlyphLayout.LayoutEngineKey layoutEngineKey) {
        this.key = layoutEngineKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAAT(Font2D font2D) {
        Object object;
        Boolean bl;
        WeakHashMap<Font2D, Boolean> weakHashMap = aatInfo;
        synchronized (weakHashMap) {
            bl = aatInfo.get(font2D);
        }
        if (bl != null) {
            return bl;
        }
        boolean bl2 = false;
        if (font2D instanceof TrueTypeFont) {
            object = (TrueTypeFont)font2D;
            bl2 = ((TrueTypeFont)object).getDirectoryEntry(1836020344) != null || ((TrueTypeFont)object).getDirectoryEntry(1836020340) != null;
        } else if (font2D instanceof PhysicalFont) {
            object = (PhysicalFont)font2D;
            bl2 = ((Font2D)object).getTableBytes(1836020344) != null || ((Font2D)object).getTableBytes(1836020340) != null;
        }
        object = aatInfo;
        synchronized (object) {
            aatInfo.put(font2D, bl2);
        }
        return bl2;
    }

    @Override
    public void layout(FontStrikeDesc fontStrikeDesc, float[] fArray, int n, int n2, TextRecord textRecord, int n3, Point2D.Float float_, GlyphLayout.GVData gVData) {
        Font2D font2D = this.key.font();
        FontStrike fontStrike = font2D.getStrike(fontStrikeDesc);
        long l = (n3 & Integer.MIN_VALUE) != 0 && this.isAAT(font2D) ? 0L : font2D.getLayoutTableCache();
        SunLayoutEngine.nativeLayout(font2D, fontStrike, fArray, n, n2, textRecord.text, textRecord.start, textRecord.limit, textRecord.min, textRecord.max, this.key.script(), this.key.lang(), n3, float_, gVData, font2D.getUnitsPerEm(), l);
    }

    private static native void nativeLayout(Font2D var0, FontStrike var1, float[] var2, int var3, int var4, char[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Point2D.Float var13, GlyphLayout.GVData var14, long var15, long var17);

    static {
        FontManagerNativeLibrary.load();
        SunLayoutEngine.initGVIDs();
        aatInfo = new WeakHashMap();
    }
}

