/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalCharLongMapOps;
import net.openhft.koloboke.collect.map.CharLongMap;
import net.openhft.koloboke.function.CharLongConsumer;
import net.openhft.koloboke.function.CharLongPredicate;

public final class CommonCharLongMapOps {
    public static boolean containsAllEntries(final InternalCharLongMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharLongMap) {
            CharLongMap m2 = (CharLongMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalCharLongMapOps) {
                return ((InternalCharLongMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new CharLongPredicate(){

                public boolean test(char a, long b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), (Long)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalCharLongMapOps map, Map<? extends Character, ? extends Long> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharLongMap) {
            if (another instanceof InternalCharLongMapOps) {
                ((InternalCharLongMapOps)another).reversePutAllTo(map);
            } else {
                ((CharLongMap)another).forEach(new CharLongConsumer(){

                    public void accept(char key, long value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Character, ? extends Long> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue());
            }
        }
    }

    private CommonCharLongMapOps() {
    }
}

