/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl;

import java.util.Map;
import net.openhft.koloboke.collect.impl.Containers;
import net.openhft.koloboke.collect.impl.InternalFloatIntMapOps;
import net.openhft.koloboke.collect.map.FloatIntMap;
import net.openhft.koloboke.function.FloatIntConsumer;
import net.openhft.koloboke.function.FloatIntPredicate;

public final class CommonFloatIntMapOps {
    public static boolean containsAllEntries(final InternalFloatIntMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof FloatIntMap) {
            FloatIntMap m2 = (FloatIntMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalFloatIntMapOps) {
                return ((InternalFloatIntMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new FloatIntPredicate(){

                public boolean test(float a, int b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Float)e.getKey()).floatValue(), (int)((Integer)e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalFloatIntMapOps map, Map<? extends Float, ? extends Integer> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof FloatIntMap) {
            if (another instanceof InternalFloatIntMapOps) {
                ((InternalFloatIntMapOps)another).reversePutAllTo(map);
            } else {
                ((FloatIntMap)another).forEach(new FloatIntConsumer(){

                    public void accept(float key, int value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Float, ? extends Integer> e : another.entrySet()) {
                map.justPut(e.getKey().floatValue(), (int)e.getValue());
            }
        }
    }

    private CommonFloatIntMapOps() {
    }
}

