/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ShortCollection;
import net.openhft.koloboke.collect.ShortCursor;
import net.openhft.koloboke.collect.ShortIterator;
import net.openhft.koloboke.collect.impl.hash.ImmutableParallelKVShortQHashSO;
import net.openhft.koloboke.collect.set.ShortSet;
import net.openhft.koloboke.collect.set.hash.HashShortSet;
import net.openhft.koloboke.function.ShortConsumer;
import net.openhft.koloboke.function.ShortPredicate;

public abstract class ImmutableParallelKVShortQHashGO
extends ImmutableParallelKVShortQHashSO {
    @Override
    @Nonnull
    public int[] table() {
        return this.table;
    }

    @Override
    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            action.accept((Short)key);
        }
    }

    public void forEach(ShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            action.accept(key);
        }
    }

    public boolean forEachWhile(ShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    public boolean allContainingIn(ShortCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ShortCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            changed |= c.add(key);
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ShortSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            changed |= s.removeShort(key);
        }
        return changed;
    }

    public ShortIterator iterator() {
        return new NoRemovedIterator();
    }

    public ShortCursor setCursor() {
        return new NoRemovedCursor();
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public short[] toShortArray() {
        int size = this.size();
        short[] result = new short[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        return result;
    }

    @Nonnull
    public short[] toArray(short[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new short[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0;
            }
            return a;
        }
        int resultIndex = 0;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            hashCode += key;
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        short free = this.freeValue;
        int[] tab = this.table;
        long base = INT_BASE + SHORT_KEY_OFFSET;
        long off = (long)tab.length << 2;
        while ((off -= 4L) >= 0L) {
            short key = U.getShort(tab, base + off);
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(short var1);

    public boolean removeIf(Predicate<? super Short> filter) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortPredicate filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashShortSet thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashShortSet thisC, @Nonnull ShortCollection c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashShortSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ShortCollection) {
            return this.retainAll(thisC, (ShortCollection)c);
        }
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashShortSet thisC, @Nonnull ShortCollection c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements ShortCursor {
        final int[] tab;
        final short free;
        int index;
        short curKey;

        NoRemovedCursor() {
            short free;
            this.tab = ImmutableParallelKVShortQHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableParallelKVShortQHashGO.this.freeValue);
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] tab = this.tab;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements ShortIterator {
        final int[] tab;
        final short free;
        int nextIndex;
        short next;

        NoRemovedIterator() {
            this.tab = ImmutableParallelKVShortQHashGO.this.table;
            int[] tab = ImmutableParallelKVShortQHashGO.this.table;
            short free = this.free = ImmutableParallelKVShortQHashGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                short key = (short)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] tab = this.tab;
                short free = this.free;
                short prev = this.next;
                while (--nextI >= 0) {
                    int entry = tab[nextI];
                    short key = (short)entry;
                    if (key == free) continue;
                    this.next = key;
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept((Short)key);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] tab = this.tab;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                short key = (short)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

