/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntToLongFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.LongCollection;
import net.openhft.koloboke.collect.LongCursor;
import net.openhft.koloboke.collect.LongIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractLongValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonIntLongMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalIntLongMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashSeparateKVIntLongMapSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVIntLongQHash;
import net.openhft.koloboke.collect.map.IntLongCursor;
import net.openhft.koloboke.collect.set.LongSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.IntLongConsumer;
import net.openhft.koloboke.function.IntLongPredicate;
import net.openhft.koloboke.function.IntLongToLongFunction;

public class ImmutableQHashSeparateKVIntLongMapGO
extends ImmutableQHashSeparateKVIntLongMapSO {
    @Override
    final void copy(SeparateKVIntLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVIntLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public long defaultValue() {
        return 0L;
    }

    @Override
    public boolean containsEntry(int key, long value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public long get(int key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Long getOrDefault(Object key, Long defaultValue) {
        int index = this.index((Integer)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public long getOrDefault(int key, long defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Long> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept((Integer)key, (Long)vals[i]);
        }
    }

    public void forEach(IntLongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(IntLongPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public IntLongCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonIntLongMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalIntLongMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalIntLongMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Integer, Long>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public LongCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            long val = vals[i];
            hashCode += key ^ (int)(val ^ val >>> 32);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int free = this.freeValue;
        int[] keys = this.set;
        long[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Long put(Integer key, Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long put(int key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long putIfAbsent(Integer key, Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long putIfAbsent(int key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(int key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long compute(Integer key, BiFunction<? super Integer, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long compute(int key, IntLongToLongFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long computeIfAbsent(Integer key, Function<? super Integer, ? extends Long> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long computeIfAbsent(int key, IntToLongFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long computeIfPresent(Integer key, BiFunction<? super Integer, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long computeIfPresent(int key, IntLongToLongFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long merge(Integer key, Long value, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long merge(int key, long value, LongBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public long addValue(int key, long value) {
        throw new UnsupportedOperationException();
    }

    public long addValue(int key, long addition, long defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Integer, ? extends Long> m) {
        CommonIntLongMapOps.putAll(this, m);
    }

    @Override
    public Long replace(Integer key, Long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long replace(int key, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Integer key, Long oldValue, Long newValue) {
        return this.replace((int)key, (long)oldValue, (long)newValue);
    }

    @Override
    public boolean replace(int key, long oldValue, long newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Long, ? extends Long> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(IntLongToLongFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Long remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public long remove(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Integer)key, (Long)value);
    }

    public boolean remove(int key, long value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(IntLongPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements IntLongCursor {
        final int[] keys;
        final long[] vals;
        final int free;
        int index;
        int curKey;
        long curValue;

        NoRemovedMapCursor() {
            int free;
            this.keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue);
        }

        public void forEachForward(IntLongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int key() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public long value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(long value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements LongCursor {
        final int[] keys;
        final long[] vals;
        final int free;
        int index;
        int curKey;
        long curValue;

        NoRemovedValueCursor() {
            int free;
            this.keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue);
        }

        public void forEachForward(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements LongIterator {
        final int[] keys;
        final long[] vals;
        final int free;
        int nextIndex;
        long next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            int free = this.free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public long nextLong() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] keys = this.keys;
                int free = this.free;
                long prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Long> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Long)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(LongConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Long next() {
            return this.nextLong();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Integer, Long>> {
        final int[] keys;
        final long[] vals;
        final int free;
        int index;
        int curKey;
        long curValue;

        NoRemovedEntryCursor() {
            int free;
            this.keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Integer, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Integer, Long> elem() {
            int curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            int[] keys = this.keys;
            int free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Integer, Long>> {
        final int[] keys;
        final long[] vals;
        final int free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            int free = this.free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Integer, Long>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int[] keys = this.keys;
            long[] vals = this.vals;
            int free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Integer, Long> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int[] keys = this.keys;
                int free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    int key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractLongValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVIntLongMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVIntLongMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVIntLongMapGO.this.containsValue(o);
        }

        public boolean contains(long v) {
            return ImmutableQHashSeparateKVIntLongMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Long)vals[i]);
            }
        }

        public void forEach(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(LongPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(LongCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(LongCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(LongSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeLong(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public LongIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public LongCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public long[] toLongArray() {
            int size = this.size();
            long[] result = new long[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public long[] toArray(long[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new long[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0L;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0L;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeLong((Long)o);
        }

        public boolean removeLong(long v) {
            return ImmutableQHashSeparateKVIntLongMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVIntLongMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Long> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(LongPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends IntLongEntry {
        private int key;
        private long value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, long value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends IntLongEntry {
        private final int key;
        private final long value;

        ImmutableEntry(int key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public long value() {
            return this.value;
        }
    }

    abstract class IntLongEntry
    extends AbstractEntry<Integer, Long> {
        IntLongEntry() {
        }

        abstract int key();

        @Override
        public final Integer getKey() {
            return this.key();
        }

        abstract long value();

        @Override
        public final Long getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = (Integer)e2.getKey();
                long v2 = (Long)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Integer, Long>>
    implements HashObjSet<Map.Entry<Integer, Long>>,
    InternalObjCollectionOps<Map.Entry<Integer, Long>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Integer, Long>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVIntLongMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVIntLongMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVIntLongMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVIntLongMapGO.this.containsEntry((Integer)e.getKey(), (Long)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Integer, Long>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Integer, Long>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Integer, Long>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Integer, Long>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Integer, Long>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableQHashSeparateKVIntLongMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int free = ImmutableQHashSeparateKVIntLongMapGO.this.freeValue;
            int[] keys = ImmutableQHashSeparateKVIntLongMapGO.this.set;
            long[] vals = ImmutableQHashSeparateKVIntLongMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVIntLongMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                int key = (Integer)e.getKey();
                long value = (Long)e.getValue();
                return ImmutableQHashSeparateKVIntLongMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Integer, Long>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVIntLongMapGO.this.clear();
        }
    }
}

