/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.IntCollection;
import net.openhft.koloboke.collect.IntCursor;
import net.openhft.koloboke.collect.IntIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractIntValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.CommonShortIntMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalShortIntMapOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.ImmutableQHashSeparateKVShortIntMapSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVShortIntQHash;
import net.openhft.koloboke.collect.map.ShortIntCursor;
import net.openhft.koloboke.collect.set.IntSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.ShortIntConsumer;
import net.openhft.koloboke.function.ShortIntPredicate;
import net.openhft.koloboke.function.ShortIntToIntFunction;
import net.openhft.koloboke.function.ShortToIntFunction;

public class ImmutableQHashSeparateKVShortIntMapGO
extends ImmutableQHashSeparateKVShortIntMapSO {
    @Override
    final void copy(SeparateKVShortIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVShortIntQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    @Override
    public boolean containsEntry(short key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Integer get(Object key) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public int get(short key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        int index = this.index((Short)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public int getOrDefault(short key, int defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Short, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept((Short)key, (Integer)vals[i]);
        }
    }

    public void forEach(ShortIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(ShortIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        short free = this.freeValue;
        short[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ShortIntCursor cursor() {
        return new NoRemovedMapCursor();
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonShortIntMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalShortIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        short free = this.freeValue;
        short[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalShortIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        short free = this.freeValue;
        short[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Short, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        short free = this.freeValue;
        short[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        short free = this.freeValue;
        short[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            short key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    public Integer put(Short key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int put(short key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer putIfAbsent(Short key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int putIfAbsent(short key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void justPut(short key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer compute(Short key, BiFunction<? super Short, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int compute(short key, ShortIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer computeIfAbsent(Short key, Function<? super Short, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfAbsent(short key, ShortToIntFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer computeIfPresent(Short key, BiFunction<? super Short, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfPresent(short key, ShortIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer merge(Short key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int merge(short key, int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int addValue(short key, int value) {
        throw new UnsupportedOperationException();
    }

    public int addValue(short key, int addition, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends Short, ? extends Integer> m) {
        CommonShortIntMapOps.putAll(this, m);
    }

    @Override
    public Integer replace(Short key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int replace(short key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(Short key, Integer oldValue, Integer newValue) {
        return this.replace((short)key, (int)oldValue, (int)newValue);
    }

    @Override
    public boolean replace(short key, int oldValue, int newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(BiFunction<? super Short, ? super Integer, ? extends Integer> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ShortIntToIntFunction function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(short key) {
        throw new UnsupportedOperationException();
    }

    public int remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Short)key, (Integer)value);
    }

    public boolean remove(short key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ShortIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ShortIntCursor {
        final short[] keys;
        final int[] vals;
        final short free;
        int index;
        short curKey;
        int curValue;

        NoRemovedMapCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue);
        }

        public void forEachForward(ShortIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            int[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short key() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final short[] keys;
        final int[] vals;
        final short free;
        int index;
        short curKey;
        int curValue;

        NoRemovedValueCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            int[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final short[] keys;
        final int[] vals;
        final short free;
        int nextIndex;
        int next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            short free = this.free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                short[] keys = this.keys;
                short free = this.free;
                int prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            int[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            int[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Short, Integer>> {
        final short[] keys;
        final int[] vals;
        final short free;
        int index;
        short curKey;
        int curValue;

        NoRemovedEntryCursor() {
            short free;
            this.keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Short, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            int[] vals = this.vals;
            short free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Short, Integer> elem() {
            short curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            short[] keys = this.keys;
            short free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Short, Integer>> {
        final short[] keys;
        final int[] vals;
        final short free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            short free = this.free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                short key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Short, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            short[] keys = this.keys;
            int[] vals = this.vals;
            short free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Short, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                short[] keys = this.keys;
                short free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    short key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVShortIntMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVShortIntMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVShortIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return ImmutableQHashSeparateKVShortIntMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeInt(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public IntCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return ImmutableQHashSeparateKVShortIntMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVShortIntMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ShortIntEntry {
        private short key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(short key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ShortIntEntry {
        private final short key;
        private final int value;

        ImmutableEntry(short key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class ShortIntEntry
    extends AbstractEntry<Short, Integer> {
        ShortIntEntry() {
        }

        abstract short key();

        @Override
        public final Short getKey() {
            return this.key();
        }

        abstract int value();

        @Override
        public final Integer getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                short k2 = (Short)e2.getKey();
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Short, Integer>>
    implements HashObjSet<Map.Entry<Short, Integer>>,
    InternalObjCollectionOps<Map.Entry<Short, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Short, Integer>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVShortIntMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return ImmutableQHashSeparateKVShortIntMapGO.this.size();
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVShortIntMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVShortIntMapGO.this.containsEntry((Short)e.getKey(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Short, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                action.accept(new ImmutableEntry(key, vals[i]));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Short, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || predicate.test(new ImmutableEntry(key, vals[i]))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Short, Integer>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Short, Integer>> cursor() {
            return new NoRemovedEntryCursor();
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Short, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return ImmutableQHashSeparateKVShortIntMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            short free = ImmutableQHashSeparateKVShortIntMapGO.this.freeValue;
            short[] keys = ImmutableQHashSeparateKVShortIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVShortIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                short key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVShortIntMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                short key = (Short)e.getKey();
                int value = (Integer)e.getValue();
                return ImmutableQHashSeparateKVShortIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Short, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ImmutableQHashSeparateKVShortIntMapGO.this.clear();
        }
    }
}

