/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCollection;
import net.openhft.koloboke.collect.CharCursor;
import net.openhft.koloboke.collect.impl.CommonCharCollectionOps;
import net.openhft.koloboke.collect.impl.CommonSetOps;
import net.openhft.koloboke.collect.impl.InternalCharCollectionOps;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableCharLHashSetSO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVCharLHash;
import net.openhft.koloboke.collect.set.CharSet;
import net.openhft.koloboke.collect.set.hash.HashCharSet;

public class MutableLHashCharSetGO
extends MutableCharLHashSetSO
implements HashCharSet,
InternalCharCollectionOps {
    @Override
    final void copy(SeparateKVCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonCharCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public CharCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Character e) {
        return this.add(e.charValue());
    }

    public boolean add(char key) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVCharKeyMixing.mix(key) & capacityMask;
        char cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != free) {
                if (cur != key) continue;
                return false;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Character> c) {
        return CommonCharCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeChar(((Character)key).charValue());
    }

    @Override
    boolean justRemove(char key) {
        return this.removeChar(key);
    }

    public boolean removeChar(char key) {
        char free = this.freeValue;
        if (key != free) {
            char keyToShift;
            int indexToRemove;
            char[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVCharKeyMixing.mix(key) & capacityMask;
            char cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                    if (cur != free) continue;
                    return false;
                }
            }
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != free) {
                if ((LHash.SeparateKVCharKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = free;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            InternalCharCollectionOps c2;
            if (c instanceof InternalCharCollectionOps && (c2 = (InternalCharCollectionOps)((Object)c)).size() < this.size()) {
                return c2.reverseRemoveAllFrom((CharSet)this);
            }
            return this.removeAll((HashCharSet)this, (CharCollection)c);
        }
        return this.removeAll((HashCharSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

