/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCollection;
import net.openhft.koloboke.collect.CharCursor;
import net.openhft.koloboke.collect.CharIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.FloatCollection;
import net.openhft.koloboke.collect.FloatCursor;
import net.openhft.koloboke.collect.FloatIterator;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractCharValueView;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonFloatCharMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalFloatCharMapOps;
import net.openhft.koloboke.collect.impl.InternalFloatCollectionOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.LHash;
import net.openhft.koloboke.collect.impl.hash.MutableLHashSeparateKVFloatCharMapSO;
import net.openhft.koloboke.collect.impl.hash.MutableSeparateKVFloatLHashGO;
import net.openhft.koloboke.collect.impl.hash.SeparateKVFloatCharLHash;
import net.openhft.koloboke.collect.map.FloatCharCursor;
import net.openhft.koloboke.collect.set.CharSet;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashFloatSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.CharBinaryOperator;
import net.openhft.koloboke.function.CharConsumer;
import net.openhft.koloboke.function.CharPredicate;
import net.openhft.koloboke.function.FloatCharConsumer;
import net.openhft.koloboke.function.FloatCharPredicate;
import net.openhft.koloboke.function.FloatCharToCharFunction;
import net.openhft.koloboke.function.FloatPredicate;
import net.openhft.koloboke.function.FloatToCharFunction;

public class MutableLHashSeparateKVFloatCharMapGO
extends MutableLHashSeparateKVFloatCharMapSO {
    @Override
    final void copy(SeparateKVFloatCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVFloatCharLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public char defaultValue() {
        return '\u0000';
    }

    @Override
    public boolean containsEntry(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public boolean containsEntry(int key, char value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return null;
    }

    public char get(float key) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    @Override
    public Character getOrDefault(Object key, Character defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int index = this.index(k);
        if (index >= 0) {
            return Character.valueOf(this.values[index]);
        }
        return defaultValue;
    }

    public char getOrDefault(float key, char defaultValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Float, ? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), Character.valueOf(vals[i]));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatCharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatCharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatCharCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatCharMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalFloatCharMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalFloatCharMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Float, Character>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public CharCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        char[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            int index = LHash.SeparateKVFloatKeyMixing.mix(key) & capacityMask;
            if (newKeys[index] != 0x7FFFFFFE) {
                while (newKeys[index = index - 1 & capacityMask] != 0x7FFFFFFE) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Character put(Float key, Character value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, value.charValue());
        if (index < 0) {
            return null;
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value.charValue();
        return Character.valueOf(prevValue);
    }

    @Override
    public char put(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        char[] vals = this.values;
        char prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    @Override
    public Character putIfAbsent(Float key, Character value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.insert(k, value.charValue());
        if (index < 0) {
            return null;
        }
        return Character.valueOf(this.values[index]);
    }

    @Override
    public char putIfAbsent(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    @Override
    public void justPut(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public void justPut(int key, char value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Character compute(Float key, BiFunction<? super Float, ? super Character, ? extends Character> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue.charValue();
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), Character.valueOf(vals[index]))) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public char compute(float key, FloatCharToCharFunction remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                newValue = remappingFunction.applyAsChar(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                keys[index] = k;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(Float.intBitsToFloat(k), vals[index]);
        return newValue;
    }

    @Override
    public Character computeIfAbsent(Float key, Function<? super Float, ? extends Character> mappingFunction) {
        Character value;
        int k = Float.floatToIntBits(key.floatValue());
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int[] keys = this.set;
        char[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
        int cur = keys[index];
        if (cur == k) {
            return Character.valueOf(vals[index]);
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return Character.valueOf(vals[index]);
            } while (cur != 0x7FFFFFFE);
        }
        if ((value = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value.charValue();
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public char computeIfAbsent(float key, FloatToCharFunction mappingFunction) {
        int k = Float.floatToIntBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        int[] keys = this.set;
        char[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
        int cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return vals[index];
            } while (cur != 0x7FFFFFFE);
        }
        char value = mappingFunction.applyAsChar(Float.intBitsToFloat(k));
        this.incrementModCount();
        keys[index] = k;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    @Override
    public Character computeIfPresent(Float key, BiFunction<? super Float, ? super Character, ? extends Character> remappingFunction) {
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            Character newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), Character.valueOf(vals[index]));
            if (newValue != null) {
                vals[index] = newValue.charValue();
                return newValue;
            }
            this.removeAt(index);
            return null;
        }
        return null;
    }

    public char computeIfPresent(float key, FloatCharToCharFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            char newValue;
            char[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsChar(Float.intBitsToFloat(k), vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Character merge(Float key, Character value, BiFunction<? super Character, ? super Character, ? extends Character> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value.charValue();
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(vals[index]), value)) != null) {
            vals[index] = newValue.charValue();
            return newValue;
        }
        this.removeAt(index);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public char merge(float key, char value, CharBinaryOperator remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsChar(vals[index], value);
        return newValue;
    }

    public char addValue(float key, char value) {
        char newValue;
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return value;
        }
        char[] vals = this.values;
        vals[index] = newValue = (char)(vals[index] + value);
        return newValue;
    }

    public char addValue(float key, char addition, char defaultValue) {
        char newValue;
        char value;
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value = (char)(defaultValue + addition));
        if (index < 0) {
            return value;
        }
        char[] vals = this.values;
        vals[index] = newValue = (char)(vals[index] + addition);
        return newValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Float, ? extends Character> m) {
        CommonFloatCharMapOps.putAll(this, m);
    }

    @Override
    public Character replace(Float key, Character value) {
        int k = Float.floatToIntBits(key.floatValue());
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value.charValue();
            return Character.valueOf(oldValue);
        }
        return null;
    }

    @Override
    public char replace(float key, char value) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            char oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    @Override
    public boolean replace(Float key, Character oldValue, Character newValue) {
        return this.replace(key.floatValue(), oldValue.charValue(), newValue.charValue());
    }

    @Override
    public boolean replace(float key, char oldValue, char newValue) {
        int k = Float.floatToIntBits(key);
        int index = this.index(k);
        if (index >= 0) {
            char[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Float, ? super Character, ? extends Character> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = function.apply(Float.valueOf(Float.intBitsToFloat(key)), Character.valueOf(vals[i])).charValue();
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatCharToCharFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        int[] keys = this.set;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            vals[i] = function.applyAsChar(Float.intBitsToFloat(key), vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        int keyToShift;
        int indexToRemove;
        int[] keys = this.set;
        char[] vals = this.values;
        int capacityMask = keys.length - 1;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
    }

    @Override
    public Character remove(Object key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(((Float)key).floatValue());
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return null;
            }
        }
        char[] vals = this.values;
        char val = vals[index];
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
        return Character.valueOf(val);
    }

    @Override
    public boolean justRemove(float key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        char[] vals = this.values;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
        return true;
    }

    @Override
    public boolean justRemove(int key) {
        int keyToShift;
        int indexToRemove;
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(key) & capacityMask;
        int cur = keys[index];
        if (cur != key) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        char[] vals = this.values;
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
        return true;
    }

    public char remove(float key) {
        int keyToShift;
        int indexToRemove;
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return this.defaultValue();
            }
        }
        char[] vals = this.values;
        char val = vals[index];
        this.incrementModCount();
        int indexToShift = indexToRemove = index;
        int shiftDistance = 1;
        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                keys[indexToRemove] = keyToShift;
                vals[indexToRemove] = vals[indexToShift];
                indexToRemove = indexToShift;
                shiftDistance = 1;
                continue;
            }
            ++shiftDistance;
            if (indexToShift != 1 + index) continue;
            throw new ConcurrentModificationException();
        }
        keys[indexToRemove] = 0x7FFFFFFE;
        this.postRemoveHook();
        return val;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), ((Character)value).charValue());
    }

    public boolean remove(float key, char value) {
        char[] vals;
        int k = Float.floatToIntBits(key);
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVFloatKeyMixing.mix(k) & capacityMask;
        int cur = keys[index];
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        if ((vals = this.values)[index] == value) {
            int keyToShift;
            int indexToRemove;
            this.incrementModCount();
            int indexToShift = indexToRemove = index;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + index) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = 0x7FFFFFFE;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeIf(FloatCharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key), vals[i])) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Float> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !filter.test(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(FloatPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !filter.test(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.removeAll(thisC, (InternalFloatCollectionOps)((Object)c));
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !c.contains(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.removeAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !c.contains(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block11: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof FloatCollection) {
            return this.retainAll(thisC, (FloatCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains(Float.valueOf(Float.intBitsToFloat(key)))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.retainAll(thisC, (InternalFloatCollectionOps)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block13: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat(key))) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        int[] keys = this.set;
        int capacityMask = keys.length - 1;
        int firstDelayedRemoved = -1;
        char[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            block12: {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    int keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                        if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                keys[indexToRemove] = Integer.MAX_VALUE;
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            keys[indexToRemove] = keyToShift;
                            vals[indexToRemove] = vals[indexToShift];
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    keys[indexToRemove] = 0x7FFFFFFE;
                    this.postRemoveHook();
                } else {
                    keys[i] = Integer.MAX_VALUE;
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    void closeDelayedRemoved(int firstDelayedRemoved) {
        int[] keys = this.set;
        char[] vals = this.values;
        int capacityMask = keys.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            int keyToShift;
            int indexToRemove;
            if (keys[i] != Integer.MAX_VALUE) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                if (keyToShift != Integer.MAX_VALUE && (LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    keys[indexToRemove] = keyToShift;
                    vals[indexToRemove] = vals[indexToShift];
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            keys[indexToRemove] = 0x7FFFFFFE;
            this.postRemoveHook();
        }
    }

    @Override
    public FloatIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public FloatCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedKeyCursor(mc);
    }

    class NoRemovedMapCursor
    implements FloatCharCursor {
        int[] keys;
        char[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatCharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public char value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(char value) {
            if (this.curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.vals[this.index] = value;
            if (this.vals == MutableLHashSeparateKVFloatCharMapGO.this.values) return;
            MutableLHashSeparateKVFloatCharMapGO.this.values[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            int[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatCharMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueCursor
    implements CharCursor {
        int[] keys;
        char[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public char elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            int[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatCharMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedValueIterator
    implements CharIterator {
        int[] keys;
        char[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] >= 0x7FFFFFFE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] >= 0x7FFFFFFE) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatCharMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = vals[indexToShift];
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatCharMapGO.this.justRemove(keys[index]);
            }
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Character>> {
        int[] keys;
        char[] vals;
        final int capacityMask;
        int expectedModCount;
        int index;
        int curKey;
        char curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.index = keys.length;
            this.vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry2(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Character> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry2(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                int[] keys = this.keys;
                for (int i = this.index - 1; i >= 0; --i) {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            int[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatCharMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatCharMapGO.this.justRemove(curKey);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, int key, char value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(char newValue) {
                if (NoRemovedEntryCursor.this.vals == MutableLHashSeparateKVFloatCharMapGO.this.values) {
                    NoRemovedEntryCursor.this.vals[NoRemovedEntryCursor.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVFloatCharMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Character>> {
        int[] keys;
        char[] vals;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            this.capacityMask = keys.length - 1;
            this.vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                int key = keys[nextI];
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry2(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Character>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] keys = this.keys;
            char[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry2(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Character> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                    this.index = nextI;
                    int[] keys = this.keys;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int key = keys[nextI];
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry2(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatCharMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = new MutableEntry2(MutableLHashSeparateKVFloatCharMapGO.this.modCount(), indexToShift, keyToShift, vals[indexToShift]);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatCharMapGO.this.justRemove(keys[index]);
            }
        }

        class MutableEntry2
        extends MutableEntry {
            MutableEntry2(int modCount, int index, int key, char value) {
                super(modCount, index, key, value);
            }

            @Override
            void updateValueInTable(char newValue) {
                if (NoRemovedEntryIterator.this.vals == MutableLHashSeparateKVFloatCharMapGO.this.values) {
                    NoRemovedEntryIterator.this.vals[NoRemovedEntryIterator.this.index] = newValue;
                } else {
                    MutableLHashSeparateKVFloatCharMapGO.this.justPut(this.key, newValue);
                    if (this.modCount != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    class ValueView
    extends AbstractCharValueView {
        ValueView() {
        }

        @Override
        public int size() {
            return MutableLHashSeparateKVFloatCharMapGO.this.size();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVFloatCharMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableLHashSeparateKVFloatCharMapGO.this.containsValue(o);
        }

        public boolean contains(char v) {
            return MutableLHashSeparateKVFloatCharMapGO.this.containsValue(v);
        }

        @Override
        public void forEach(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(Character.valueOf(vals[i]));
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                action.accept(vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(CharPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(CharCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(CharCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(CharSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                changed |= s.removeChar(vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public CharIterator iterator() {
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public CharCursor cursor() {
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = Character.valueOf(vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public char[] toCharArray() {
            int size = this.size();
            char[] result = new char[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public char[] toArray(char[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new char[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = '\u0000';
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = '\u0000';
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] >= 0x7FFFFFFE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.removeChar(((Character)o).charValue());
        }

        public boolean removeChar(char v) {
            return MutableLHashSeparateKVFloatCharMapGO.this.removeValue(v);
        }

        @Override
        public void clear() {
            MutableLHashSeparateKVFloatCharMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super Character> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFE || !filter.test(Character.valueOf(vals[i]))) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(CharPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFE || !filter.test(vals[i])) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.removeAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] >= 0x7FFFFFFE || !c.contains(Character.valueOf(vals[i]))) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    if (keys[i] >= 0x7FFFFFFE || !c.contains(vals[i])) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof CharCollection) {
                return this.retainAll((CharCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    if (keys[i] >= 0x7FFFFFFE || c.contains(Character.valueOf(vals[i]))) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(CharCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    if (keys[i] >= 0x7FFFFFFE || c.contains(vals[i])) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends FloatCharEntry {
        private int key;
        private char value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, char value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatCharEntry {
        final int modCount;
        private final int index;
        final int key;
        private char value;

        MutableEntry(int modCount, int index, int key, char value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public Character setValue(Character newValue) {
            char unwrappedNewValue;
            if (this.modCount != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            char oldValue = this.value;
            this.value = unwrappedNewValue = newValue.charValue();
            this.updateValueInTable(unwrappedNewValue);
            return Character.valueOf(oldValue);
        }

        void updateValueInTable(char newValue) {
            MutableLHashSeparateKVFloatCharMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class FloatCharEntry
    extends AbstractEntry<Float, Character> {
        FloatCharEntry() {
        }

        abstract int key();

        @Override
        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract char value();

        @Override
        public final Character getValue() {
            return Character.valueOf(this.value());
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                char v2 = ((Character)e2.getValue()).charValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ Primitives.hashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Character>>
    implements HashObjSet<Map.Entry<Float, Character>>,
    InternalObjCollectionOps<Map.Entry<Float, Character>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Character>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableLHashSeparateKVFloatCharMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableLHashSeparateKVFloatCharMapGO.this.size();
        }

        public double currentLoad() {
            return MutableLHashSeparateKVFloatCharMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableLHashSeparateKVFloatCharMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), ((Character)e.getValue()).charValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Character>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Character>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                terminated = true;
                break;
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Float, Character>> iterator() {
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Character>> cursor() {
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Character>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableLHashSeparateKVFloatCharMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                int key = keys[i];
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableLHashSeparateKVFloatCharMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                char value = ((Character)e.getValue()).charValue();
                return MutableLHashSeparateKVFloatCharMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Character>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block11: {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block11;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block13: {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE || !c.contains(e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block13;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableLHashSeparateKVFloatCharMapGO.this.modCount();
            int[] keys = MutableLHashSeparateKVFloatCharMapGO.this.set;
            int capacityMask = keys.length - 1;
            int firstDelayedRemoved = -1;
            char[] vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                block12: {
                    int key = keys[i];
                    if (key >= 0x7FFFFFFE || c.contains(e.with(key, vals[i]))) continue;
                    MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                    ++mc;
                    if (firstDelayedRemoved < 0) {
                        int keyToShift;
                        int indexToRemove;
                        int indexToShift = indexToRemove = i;
                        int shiftDistance = 1;
                        while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                            if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                                if (indexToShift > indexToRemove) {
                                    firstDelayedRemoved = i;
                                    keys[indexToRemove] = Integer.MAX_VALUE;
                                    break block12;
                                }
                                if (indexToRemove == i) {
                                    ++i;
                                }
                                keys[indexToRemove] = keyToShift;
                                vals[indexToRemove] = vals[indexToShift];
                                indexToRemove = indexToShift;
                                shiftDistance = 1;
                                continue;
                            }
                            ++shiftDistance;
                            if (indexToShift != 1 + i) continue;
                            throw new ConcurrentModificationException();
                        }
                        keys[indexToRemove] = 0x7FFFFFFE;
                        MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                    } else {
                        keys[i] = Integer.MAX_VALUE;
                    }
                }
                changed = true;
            }
            if (firstDelayedRemoved >= 0) {
                MutableLHashSeparateKVFloatCharMapGO.this.closeDelayedRemoved(firstDelayedRemoved);
            }
            if (mc != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableLHashSeparateKVFloatCharMapGO.this.clear();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVFloatLHashGO.NoRemovedCursor {
        char[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableLHashSeparateKVFloatCharMapGO.this, mc);
            this.vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int curKey = this.curKey;
            if (curKey == 0x7FFFFFFE) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = 0x7FFFFFFE;
            int index = this.index;
            int[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatCharMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatCharMapGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVFloatLHashGO.NoRemovedIterator {
        char[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableLHashSeparateKVFloatCharMapGO.this, mc);
            this.vals = MutableLHashSeparateKVFloatCharMapGO.this.values;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableLHashSeparateKVFloatCharMapGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            int[] keys = this.keys;
            char[] vals = this.vals;
            if (keys == MutableLHashSeparateKVFloatCharMapGO.this.set) {
                int keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableLHashSeparateKVFloatCharMapGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = keys[indexToShift = indexToShift - 1 & capacityMask]) != 0x7FFFFFFE) {
                    if ((LHash.SeparateKVFloatKeyMixing.mix(keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.keys == keys) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.keys = Arrays.copyOf(keys, slotsToCopy);
                                    this.vals = Arrays.copyOf(vals, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        this.keys[indexToRemove] = 0x7FFFFFFE;
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = Float.intBitsToFloat(keyToShift);
                                }
                            }
                        }
                        keys[indexToRemove] = keyToShift;
                        vals[indexToRemove] = vals[indexToShift];
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                keys[indexToRemove] = 0x7FFFFFFE;
                MutableLHashSeparateKVFloatCharMapGO.this.postRemoveHook();
                return;
            } else {
                MutableLHashSeparateKVFloatCharMapGO.this.justRemove(keys[index]);
            }
        }
    }
}

