/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCollection;
import net.openhft.koloboke.collect.CharCursor;
import net.openhft.koloboke.collect.CharIterator;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.MutableParallelKVCharQHashSO;
import net.openhft.koloboke.collect.set.CharSet;
import net.openhft.koloboke.collect.set.hash.HashCharSet;
import net.openhft.koloboke.function.CharConsumer;
import net.openhft.koloboke.function.CharPredicate;

public abstract class MutableParallelKVCharQHashGO
extends MutableParallelKVCharQHashSO {
    @Override
    @Nonnull
    public int[] table() {
        return this.table;
    }

    @Override
    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Character> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                action.accept(Character.valueOf(key));
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                action.accept(Character.valueOf(key));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                action.accept(key);
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                action.accept(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed || predicate.test(key)) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(CharCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed || c.contains(key)) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(CharCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                changed |= c.add(key);
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                changed |= c.add(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(CharSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                changed |= s.removeChar(key);
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                changed |= s.removeChar(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public CharIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedIterator(mc);
        }
        return new NoRemovedIterator(mc);
    }

    public CharCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedCursor(mc);
        }
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                result[resultIndex++] = Character.valueOf(key);
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                result[resultIndex++] = Character.valueOf(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                a[resultIndex++] = Character.valueOf(key);
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                a[resultIndex++] = Character.valueOf(key);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public char[] toCharArray() {
        int size = this.size();
        char[] result = new char[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                result[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                result[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public char[] toArray(char[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new char[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = '\u0000';
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                a[resultIndex++] = key;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                a[resultIndex++] = key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = '\u0000';
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                hashCode += key;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                hashCode += key;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed) continue;
                sb.append(' ').append(key).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(char var1);

    public boolean removeIf(Predicate<? super Character> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || !filter.test(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed || !filter.test(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(CharPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || !c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed || !c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll(thisC, (CharCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed || c.contains(Character.valueOf(key))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashCharSet thisC, @Nonnull CharCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        long base = INT_BASE + CHAR_KEY_OFFSET;
        if (this.noRemoved()) {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            long off = (long)tab.length << 2;
            while ((off -= 4L) >= 0L) {
                char key = U.getChar(tab, base + off);
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, base + off, removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedCursor
    implements CharCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;

        SomeRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVCharQHashGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableParallelKVCharQHashGO.this.freeValue;
            this.removed = MutableParallelKVCharQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVCharQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVCharQHashGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableParallelKVCharQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableParallelKVCharQHashGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableParallelKVCharQHashGO.this.postRemoveHook();
        }
    }

    class SomeRemovedIterator
    implements CharIterator {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        SomeRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVCharQHashGO.this.table;
            int[] tab = MutableParallelKVCharQHashGO.this.table;
            char free = this.free = MutableParallelKVCharQHashGO.this.freeValue;
            char removed = this.removed = MutableParallelKVCharQHashGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVCharQHashGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char removed = this.removed;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free || key == removed) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(Character.valueOf(key));
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVCharQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVCharQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVCharQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVCharQHashGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableParallelKVCharQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements CharCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;

        NoRemovedCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVCharQHashGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableParallelKVCharQHashGO.this.freeValue;
            this.removed = MutableParallelKVCharQHashGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVCharQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVCharQHashGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableParallelKVCharQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableParallelKVCharQHashGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableParallelKVCharQHashGO.this.postRemoveHook();
        }
    }

    class NoRemovedIterator
    implements CharIterator {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        char next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVCharQHashGO.this.table;
            int[] tab = MutableParallelKVCharQHashGO.this.table;
            char free = this.free = MutableParallelKVCharQHashGO.this.freeValue;
            this.removed = MutableParallelKVCharQHashGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public char nextChar() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableParallelKVCharQHashGO.this.modCount()) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Character> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(Character.valueOf(key));
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVCharQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(CharConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVCharQHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableParallelKVCharQHashGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableParallelKVCharQHashGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableParallelKVCharQHashGO.this.postRemoveHook();
        }
    }
}

