/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.koloboke.collect.hash.HashOverflowException;
import net.openhft.koloboke.collect.impl.PrimitiveConstants;
import net.openhft.koloboke.collect.impl.ShortArrays;
import net.openhft.koloboke.collect.impl.UnsafeConstants;
import net.openhft.koloboke.collect.impl.hash.HashConfigWrapper;
import net.openhft.koloboke.collect.impl.hash.MutableQHash;
import net.openhft.koloboke.collect.impl.hash.ParallelKVShortQHash;
import net.openhft.koloboke.collect.impl.hash.QHash;

public abstract class MutableParallelKVShortQHashSO
extends MutableQHash
implements ParallelKVShortQHash,
PrimitiveConstants,
UnsafeConstants {
    short freeValue;
    short removedValue;
    int[] table;

    void copy(ParallelKVShortQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.table = (int[])hash.table().clone();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    void move(ParallelKVShortQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.table = hash.table();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    final void init(HashConfigWrapper configWrapper, int size, short freeValue, short removedValue) {
        this.freeValue = freeValue;
        this.removedValue = removedValue;
        super.init(configWrapper, size);
    }

    @Override
    public short freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return true;
    }

    @Override
    public short removedValue() {
        return this.removedValue;
    }

    public boolean contains(Object key) {
        return this.contains((Short)key);
    }

    public boolean contains(short key) {
        return this.index(key) >= 0;
    }

    int index(short key) {
        short free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVShortKeyMixing.mix(key) % capacity;
            int entry = tab[index];
            short cur = (short)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (short)(entry = tab[bIndex])) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (short)(entry = tab[fIndex])) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private short findNewFreeOrRemoved() {
        short newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 65534) {
                throw new HashOverflowException();
            }
            short free = this.freeValue;
            short removed = this.removedValue;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 49152) {
                int nf = ((Random)random).nextInt(65536) * 21859;
                for (int i = 0; i < 65536; ++i) {
                    newFree = (short)(nf += 21859);
                    if (newFree == free || newFree == removed || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (short)((Random)random).nextInt()) == free || newFree == removed || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    short changeFree() {
        int mc = this.modCount();
        short newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ShortArrays.replaceAllKeys(this.table, this.freeValue, newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    short changeRemoved() {
        int mc = this.modCount();
        short newRemoved = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ++mc;
        if (!this.noRemoved()) {
            ShortArrays.replaceAllKeys(this.table, this.removedValue, newRemoved);
        }
        this.removedValue = newRemoved;
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newRemoved;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new int[capacity];
        if (this.freeValue != 0) {
            ShortArrays.fillKeys(this.table, this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        ShortArrays.fillKeys(this.table, this.freeValue);
    }

    @Override
    void removeAt(int index) {
        U.putShort(this.table, INT_BASE + SHORT_KEY_OFFSET + ((long)index << 2), this.removedValue);
    }
}

