/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.ByteCollection;
import net.openhft.koloboke.collect.ByteCursor;
import net.openhft.koloboke.collect.ByteIterator;
import net.openhft.koloboke.collect.Equivalence;
import net.openhft.koloboke.collect.ObjCollection;
import net.openhft.koloboke.collect.ObjCursor;
import net.openhft.koloboke.collect.ObjIterator;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.impl.AbstractEntry;
import net.openhft.koloboke.collect.impl.AbstractObjValueView;
import net.openhft.koloboke.collect.impl.AbstractSetView;
import net.openhft.koloboke.collect.impl.CommonByteObjMapOps;
import net.openhft.koloboke.collect.impl.CommonMapOps;
import net.openhft.koloboke.collect.impl.CommonObjCollectionOps;
import net.openhft.koloboke.collect.impl.InternalByteObjMapOps;
import net.openhft.koloboke.collect.impl.InternalObjCollectionOps;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.MutableQHashSeparateKVByteObjMapSO;
import net.openhft.koloboke.collect.impl.hash.MutableSeparateKVByteQHashGO;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVByteObjQHash;
import net.openhft.koloboke.collect.map.ByteObjCursor;
import net.openhft.koloboke.collect.set.ObjSet;
import net.openhft.koloboke.collect.set.hash.HashByteSet;
import net.openhft.koloboke.collect.set.hash.HashObjSet;
import net.openhft.koloboke.function.ByteFunction;
import net.openhft.koloboke.function.ByteObjConsumer;
import net.openhft.koloboke.function.ByteObjFunction;
import net.openhft.koloboke.function.ByteObjPredicate;
import net.openhft.koloboke.function.BytePredicate;

public class MutableQHashSeparateKVByteObjMapGO<V>
extends MutableQHashSeparateKVByteObjMapSO<V> {
    @Override
    final void copy(SeparateKVByteObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteObjQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public Equivalence<V> valueEquivalence() {
        return Equivalence.defaultEquality();
    }

    @Override
    public boolean containsEntry(byte key, Object value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.nullableValueEquals(this.values[index], value);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    public V get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return null;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    public V getOrDefault(byte key, V defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return (V)this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Byte, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteObjConsumer<? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ByteObjPredicate<? super V> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ByteObjCursor<V> cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    @Override
    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteObjMapOps.containsAllEntries(this, m);
    }

    @Override
    public boolean allEntriesContainingIn(InternalByteObjMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    @Override
    public void reversePutAllTo(InternalByteObjMapOps<? super V> m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @Nonnull
    public HashObjSet<Map.Entry<Byte, V>> entrySet() {
        return new EntryView();
    }

    @Override
    @Nonnull
    public ObjCollection<V> values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals(this, o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                hashCode += key ^ this.nullableValueHashCode(vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += key ^ this.nullableValueHashCode(vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Map)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                Object val = vals[i];
                sb.append(val != this ? val : "(this Map)");
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        byte[] newKeys = this.set;
        int capacity = newKeys.length;
        Object[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public V put(Byte key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    @Override
    public V put(byte key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        Object[] vals = this.values;
        Object prevValue = vals[index];
        vals[index] = value;
        return (V)prevValue;
    }

    @Override
    public V putIfAbsent(Byte key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    @Override
    public V putIfAbsent(byte key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return (V)this.values[index];
    }

    @Override
    public void justPut(byte key, V value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    @Override
    public V compute(Byte key, BiFunction<? super Byte, ? super V, ? extends V> remappingFunction) {
        V newValue;
        int index;
        Object[] vals;
        byte removed;
        byte k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                V newValue2;
                block29: {
                    if (cur != free) {
                        V newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(k, vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        vals[index] = null;
        this.postRemoveHook();
        return null;
    }

    public V compute(byte key, ByteObjFunction<? super V, ? extends V> remappingFunction) {
        Object newValue;
        int index;
        Object[] vals;
        byte removed;
        block28: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                Object newValue2;
                block29: {
                    if (cur != free) {
                        Object newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(key, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = key;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return (V)newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(key, null)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return (V)newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(key, vals[index])) != null) {
            vals[index] = newValue;
            return (V)newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        vals[index] = null;
        this.postRemoveHook();
        return null;
    }

    @Override
    public V computeIfAbsent(Byte key, Function<? super Byte, ? extends V> mappingFunction) {
        Object val;
        int index;
        Object[] vals;
        byte k;
        block29: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                V value;
                block30: {
                    if (cur != free) {
                        V value2;
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((value2 = mappingFunction.apply(k)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = value2;
                            this.postRemovedSlotInsertHook();
                            return value2;
                        }
                        return null;
                    }
                }
                if ((value = mappingFunction.apply(k)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = value;
                    this.postFreeSlotInsertHook();
                    return value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        V value = mappingFunction.apply(k);
        if (value != null) {
            vals[index] = value;
            return value;
        }
        return null;
    }

    public V computeIfAbsent(byte key, ByteFunction<? extends V> mappingFunction) {
        Object val;
        int index;
        Object[] vals;
        block29: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                Object value;
                block30: {
                    if (cur != free) {
                        Object value2;
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block30;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block30;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block29;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block30;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((value2 = mappingFunction.apply(key)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = key;
                            vals[firstRemoved] = value2;
                            this.postRemovedSlotInsertHook();
                            return (V)value2;
                        }
                        return null;
                    }
                }
                if ((value = mappingFunction.apply(key)) != null) {
                    this.incrementModCount();
                    keys[index] = key;
                    vals[index] = value;
                    this.postFreeSlotInsertHook();
                    return (V)value;
                }
                return null;
            }
        }
        if ((val = vals[index]) != null) {
            return (V)val;
        }
        Object value = mappingFunction.apply(key);
        if (value != null) {
            vals[index] = value;
            return (V)value;
        }
        return null;
    }

    @Override
    public V computeIfPresent(Byte key, BiFunction<? super Byte, ? super V, ? extends V> remappingFunction) {
        byte k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                V newValue = remappingFunction.apply(k, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return newValue;
                }
                this.incrementModCount();
                this.set[index] = this.removedValue;
                vals[index] = null;
                this.postRemoveHook();
                return null;
            }
            return null;
        }
        return null;
    }

    public V computeIfPresent(byte key, ByteObjFunction<? super V, ? extends V> remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object val = vals[index];
            if (val != null) {
                Object newValue = remappingFunction.apply(key, val);
                if (newValue != null) {
                    vals[index] = newValue;
                    return (V)newValue;
                }
                this.incrementModCount();
                this.set[index] = this.removedValue;
                vals[index] = null;
                this.postRemoveHook();
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public V merge(Byte key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object val;
        int index;
        Object[] vals;
        byte removed;
        block28: {
            byte k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                block29: {
                    if (cur != free) {
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            V newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return null;
        }
        vals[index] = value;
        return value;
    }

    @Override
    public V merge(byte key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object val;
        int index;
        Object[] vals;
        byte removed;
        block28: {
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                block29: {
                    if (cur != free) {
                        int firstRemoved;
                        int bIndex;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((val = vals[index]) != null) {
            V newValue = remappingFunction.apply(val, value);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return null;
        }
        vals[index] = value;
        return value;
    }

    @Override
    public void putAll(@Nonnull Map<? extends Byte, ? extends V> m) {
        CommonByteObjMapOps.putAll(this, m);
    }

    @Override
    public V replace(Byte key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public V replace(byte key, V value) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            Object oldValue = vals[index];
            vals[index] = value;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public boolean replace(Byte key, V oldValue, V newValue) {
        return this.replace((byte)key, oldValue, newValue);
    }

    @Override
    public boolean replace(byte key, V oldValue, V newValue) {
        int index = this.index(key);
        if (index >= 0) {
            Object[] vals = this.values;
            if (this.nullableValueEquals(vals[index], oldValue)) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void replaceAll(BiFunction<? super Byte, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ByteObjFunction<? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.values[index] = null;
        this.postRemoveHook();
    }

    @Override
    public V remove(Object key) {
        byte removed;
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return (V)val;
        }
        return null;
    }

    @Override
    public boolean justRemove(byte key) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.values[index] = null;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public V remove(byte key) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            Object[] vals = this.values;
            Object val = vals[index];
            this.incrementModCount();
            keys[index] = removed;
            vals[index] = null;
            this.postRemoveHook();
            return (V)val;
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, value);
    }

    public boolean remove(byte key, Object value) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            Object[] vals;
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix(key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.nullableValueEquals((vals = this.values)[index], value)) {
                this.incrementModCount();
                keys[index] = removed;
                vals[index] = null;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(ByteObjPredicate<? super V> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(Predicate<? super Byte> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || !filter.test((Byte)key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || !filter.test((Byte)key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeIf(BytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.retainAll(thisC, (ByteCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        Object[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                vals[i] = null;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    @Override
    public ByteIterator iterator() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedKeyIterator(mc);
        }
        return new NoRemovedKeyIterator(mc);
    }

    @Override
    public ByteCursor setCursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedKeyCursor(mc);
        }
        return new NoRemovedKeyCursor(mc);
    }

    class SomeRemovedMapCursor
    implements ByteObjCursor<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        V curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ByteObjCursor<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        V curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteObjConsumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public V value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(V value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ObjCursor<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        V curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ObjIterator<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    byte removed = this.removed;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ObjCursor<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        V curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public V elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ObjIterator<V> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        V next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(Consumer<? super V> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public V next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                if (this.expectedModCount == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    Object prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, V>> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        V curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, V> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, V>> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, V> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    byte removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, V>> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        V curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, V> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, V>> {
        final byte[] keys;
        final V[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, V>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            V[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(new MutableEntry(mc, i, key, vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, V> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                int mc = this.expectedModCount;
                if (mc == MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new ConcurrentModificationException();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractObjValueView<V> {
        ValueView() {
        }

        public Equivalence<V> equivalence() {
            return MutableQHashSeparateKVByteObjMapGO.this.valueEquivalence();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVByteObjMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVByteObjMapGO.this.shrink();
        }

        @Override
        public boolean contains(Object o) {
            return MutableQHashSeparateKVByteObjMapGO.this.containsValue(o);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(Predicate<? super V> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        public boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseAddAllTo(ObjCollection<? super V> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.remove(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        @Nonnull
        public ObjIterator<V> iterator() {
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ObjCursor<V> cursor() {
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object val;
                    if (keys[i] == free) continue;
                    sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    Object val;
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append((val = vals[i]) != this ? val : "(this Collection)").append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        @Override
        public boolean remove(Object o) {
            return MutableQHashSeparateKVByteObjMapGO.this.removeValue(o);
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVByteObjMapGO.this.clear();
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ByteObjEntry {
        private byte key;
        private V value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, V value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ByteObjEntry {
        final int modCount;
        private final int index;
        final byte key;
        private V value;

        MutableEntry(int modCount, int index, byte key, V value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            if (this.modCount != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            Object oldValue = this.value;
            Object unwrappedNewValue = newValue;
            this.value = unwrappedNewValue;
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(V newValue) {
            MutableQHashSeparateKVByteObjMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ByteObjEntry
    extends AbstractEntry<Byte, V> {
        ByteObjEntry() {
        }

        abstract byte key();

        @Override
        public final Byte getKey() {
            return this.key();
        }

        abstract V value();

        @Override
        public final V getValue() {
            return this.value();
        }

        @Override
        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                Object v2 = e2.getValue();
                return this.key() == k2 && MutableQHashSeparateKVByteObjMapGO.this.nullableValueEquals(this.value(), v2);
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Primitives.hashCode(this.key()) ^ MutableQHashSeparateKVByteObjMapGO.this.nullableValueHashCode(this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, V>>
    implements HashObjSet<Map.Entry<Byte, V>>,
    InternalObjCollectionOps<Map.Entry<Byte, V>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, V>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), MutableQHashSeparateKVByteObjMapGO.this.valueEquivalence());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVByteObjMapGO.this.hashConfig();
        }

        @Override
        public int size() {
            return MutableQHashSeparateKVByteObjMapGO.this.size();
        }

        public double currentLoad() {
            return MutableQHashSeparateKVByteObjMapGO.this.currentLoad();
        }

        @Override
        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVByteObjMapGO.this.containsEntry((Byte)e.getKey(), e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Override
        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        @Override
        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    action.accept(new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, V>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || predicate.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Override
        @Nonnull
        public ObjIterator<Map.Entry<Byte, V>> iterator() {
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, V>> cursor() {
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        @Override
        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll(this, c);
        }

        @Override
        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        @Override
        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, V>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public int hashCode() {
            return MutableQHashSeparateKVByteObjMapGO.this.hashCode();
        }

        @Override
        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    Object val = vals[i];
                    sb.append(val != this ? val : "(this Collection)");
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    Object val = vals[i];
                    sb.append(val != this ? val : "(this Collection)");
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVByteObjMapGO.this.shrink();
        }

        @Override
        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                Object value = e.getValue();
                return MutableQHashSeparateKVByteObjMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, V>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !filter.test(new MutableEntry(mc, i, key, vals[i]))) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)((Object)c);
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet<?>)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteObjMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteObjMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteObjMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteObjMapGO.this.set;
            Object[] vals = MutableQHashSeparateKVByteObjMapGO.this.values;
            if (MutableQHashSeparateKVByteObjMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    vals[i] = null;
                    MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Override
        public void clear() {
            MutableQHashSeparateKVByteObjMapGO.this.clear();
        }
    }

    class SomeRemovedKeyCursor
    extends MutableSeparateKVByteQHashGO.SomeRemovedCursor {
        final V[] vals;

        private SomeRemovedKeyCursor(int mc) {
            super(MutableQHashSeparateKVByteObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
        }

        @Override
        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedKeyIterator
    extends MutableSeparateKVByteQHashGO.SomeRemovedIterator {
        final V[] vals;

        private SomeRemovedKeyIterator(int mc) {
            super(MutableQHashSeparateKVByteObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
        }

        @Override
        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedKeyCursor
    extends MutableSeparateKVByteQHashGO.NoRemovedCursor {
        final V[] vals;

        private NoRemovedKeyCursor(int mc) {
            super(MutableQHashSeparateKVByteObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
        }

        @Override
        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            int index = this.index;
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedKeyIterator
    extends MutableSeparateKVByteQHashGO.NoRemovedIterator {
        final V[] vals;

        private NoRemovedKeyIterator(int mc) {
            super(MutableQHashSeparateKVByteObjMapGO.this, mc);
            this.vals = MutableQHashSeparateKVByteObjMapGO.this.values;
        }

        @Override
        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteObjMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteObjMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            this.vals[index] = null;
            MutableQHashSeparateKVByteObjMapGO.this.postRemoveHook();
        }
    }
}

