/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.impl.InternalDoubleFloatMapOps;
import net.openhft.koloboke.collect.impl.hash.MutableQHashSeparateKVDoubleKeyMap;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVDoubleFloatQHash;
import net.openhft.koloboke.collect.map.hash.HashDoubleFloatMap;

public abstract class MutableQHashSeparateKVDoubleFloatMapSO
extends MutableQHashSeparateKVDoubleKeyMap
implements HashDoubleFloatMap,
InternalDoubleFloatMapOps,
SeparateKVDoubleFloatQHash {
    int[] values;

    void copy(SeparateKVDoubleFloatQHash hash) {
        super.copy(hash);
        this.values = (int[])hash.valueArray().clone();
    }

    void move(SeparateKVDoubleFloatQHash hash) {
        super.move(hash);
        this.values = hash.valueArray();
    }

    @Override
    @Nonnull
    public int[] valueArray() {
        return this.values;
    }

    int valueIndex(int value) {
        if (this.isEmpty()) {
            return -1;
        }
        int index = -1;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || value != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    boolean containsValue(int value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(int value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    int valueIndex(float value) {
        if (this.isEmpty()) {
            return -1;
        }
        int val = Float.floatToIntBits(value);
        int index = -1;
        int mc = this.modCount();
        long[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            if (keys[i] >= 0x7FFFFFFFFFFFFFFEL || val != vals[i]) continue;
            index = i;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return index;
    }

    public boolean containsValue(float value) {
        return this.valueIndex(value) >= 0;
    }

    boolean removeValue(float value) {
        int index = this.valueIndex(value);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(((Float)value).floatValue());
    }

    int insert(long key, int value) {
        block21: {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVDoubleKeyMixing.mix(key) % capacity;
            long cur = keys[index];
            if (cur != 0x7FFFFFFFFFFFFFFEL) {
                int firstRemoved;
                if (cur == key) {
                    return index;
                }
                if (cur <= 0x7FFFFFFFFFFFFFFEL) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                                index = bIndex;
                                break block21;
                            }
                            if (cur == key) {
                                return bIndex;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                                index = fIndex;
                                break block21;
                            }
                            if (cur == key) {
                                return fIndex;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block21;
                    }
                    if (cur == key) {
                        return bIndex;
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == 0x7FFFFFFFFFFFFFFEL) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block21;
                    }
                    if (cur == key) {
                        return fIndex;
                    }
                    if (cur > 0x7FFFFFFFFFFFFFFEL && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.values[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return -1;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.values[index] = value;
        this.postFreeSlotInsertHook();
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        super.allocateArrays(capacity);
        this.values = new int[capacity];
    }
}

