/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.koloboke.collect.hash.HashConfig;
import net.openhft.koloboke.collect.hash.ShortHashFactory;
import net.openhft.koloboke.collect.impl.Primitives;
import net.openhft.koloboke.collect.impl.hash.AbstractHashFactory;

abstract class ShortHashFactorySO
extends AbstractHashFactory {
    final short lower;
    final short upper;
    final boolean randomFree;
    final boolean randomRemoved;
    final short freeValue;
    final short removedValue;

    ShortHashFactorySO(HashConfig hashConf, int defaultExpectedSize, short lower, short upper) {
        super(hashConf, defaultExpectedSize);
        this.lower = lower;
        this.upper = upper;
        if ((short)(lower - 1) == upper) {
            this.randomFree = false;
            this.randomRemoved = true;
            this.removedValue = 0;
            this.freeValue = 0;
        } else {
            this.randomFree = false;
            this.freeValue = lower < upper && (lower > 0 || upper < 0) || upper < lower && lower > 0 && upper < 0 ? (short)0 : (short)(lower - 1);
            if ((short)(lower - 2) == upper) {
                this.randomRemoved = true;
                this.removedValue = 0;
            } else {
                this.randomRemoved = false;
                this.removedValue = upper + 1 != 0 ? (short)(upper + 1) : (short)(upper + 2);
            }
        }
    }

    public final short getLowerKeyDomainBound() {
        return this.lower;
    }

    public final short getUpperKeyDomainBound() {
        return this.upper;
    }

    short getFree() {
        if (this.randomFree) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            return (short)((Random)random).nextInt();
        }
        return this.freeValue;
    }

    String keySpecialString() {
        return ",lowerKeyDomainBound=" + ShortHashFactorySO.boundAsString(this.getLowerKeyDomainBound()) + ",upperKeyDomainBound=" + ShortHashFactorySO.boundAsString(this.getUpperKeyDomainBound());
    }

    private static String boundAsString(short bound) {
        return "" + bound;
    }

    int keySpecialHashCode(int hashCode) {
        hashCode = hashCode * 31 + Primitives.hashCode(this.getLowerKeyDomainBound());
        return hashCode * 31 + Primitives.hashCode(this.getUpperKeyDomainBound());
    }

    boolean keySpecialEquals(ShortHashFactory other) {
        return this.getLowerKeyDomainBound() == other.getLowerKeyDomainBound() && this.getUpperKeyDomainBound() == other.getUpperKeyDomainBound();
    }
}

