/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.ConcurrentModificationException;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableSeparateKVFloatQHashGO;

public abstract class UpdatableFloatQHashSetSO
extends UpdatableSeparateKVFloatQHashGO {
    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        int[] keys = this.set;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newKeys = this.set;
        int capacity = newKeys.length;
        for (int i = keys.length - 1; i >= 0; --i) {
            int key = keys[i];
            if (key >= 0x7FFFFFFE) continue;
            int index = QHash.SeparateKVFloatKeyMixing.mix(key) % capacity;
            if (newKeys[index] != 0x7FFFFFFE) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if (newKeys[bIndex] == 0x7FFFFFFE) {
                        index = bIndex;
                        break;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if (newKeys[fIndex] == 0x7FFFFFFE) {
                        index = fIndex;
                        break;
                    }
                    step += 2;
                }
            }
            newKeys[index] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }
}

