/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.koloboke.collect.impl.hash;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import javax.annotation.Nonnull;
import net.openhft.koloboke.collect.CharCursor;
import net.openhft.koloboke.collect.impl.CommonCharCollectionOps;
import net.openhft.koloboke.collect.impl.CommonSetOps;
import net.openhft.koloboke.collect.impl.InternalCharCollectionOps;
import net.openhft.koloboke.collect.impl.hash.QHash;
import net.openhft.koloboke.collect.impl.hash.SeparateKVCharQHash;
import net.openhft.koloboke.collect.impl.hash.UpdatableCharQHashSetSO;
import net.openhft.koloboke.collect.set.hash.HashCharSet;

public class UpdatableQHashCharSetGO
extends UpdatableCharQHashSetSO
implements HashCharSet,
InternalCharCollectionOps {
    @Override
    final void copy(SeparateKVCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals(this, obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonCharCollectionOps.containsAll(this, c);
    }

    @Nonnull
    public CharCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Character e) {
        return this.add(e.charValue());
    }

    public boolean add(char key) {
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        char[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVCharKeyMixing.mix(key) % capacity;
        char cur = keys[index];
        if (cur != free) {
            if (cur == key) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == free) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == free) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Character> c) {
        return CommonCharCollectionOps.addAll(this, c);
    }

    public boolean remove(Object key) {
        return this.removeChar(((Character)key).charValue());
    }

    @Override
    boolean justRemove(char key) {
        return this.removeChar(key);
    }

    public boolean removeChar(char key) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

