/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.fmod.FMOD_FILE_ASYNCDONE_FUNC;
import org.lwjgl.fmod.FMOD_FILE_ASYNCDONE_FUNCI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct FMOD_ASYNCREADINFO")
public class FMOD_ASYNCREADINFO
extends Struct<FMOD_ASYNCREADINFO>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int OFFSET;
    public static final int SIZEBYTES;
    public static final int PRIORITY;
    public static final int USERDATA;
    public static final int BUFFER;
    public static final int BYTESREAD;
    public static final int DONE;

    protected FMOD_ASYNCREADINFO(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_ASYNCREADINFO create(long address, @Nullable ByteBuffer container) {
        return new FMOD_ASYNCREADINFO(address, container);
    }

    public FMOD_ASYNCREADINFO(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_ASYNCREADINFO.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return FMOD_ASYNCREADINFO.nhandle(this.address());
    }

    @NativeType(value="unsigned int")
    public int offset() {
        return FMOD_ASYNCREADINFO.noffset(this.address());
    }

    @NativeType(value="unsigned int")
    public int sizebytes() {
        return FMOD_ASYNCREADINFO.nsizebytes(this.address());
    }

    public int priority() {
        return FMOD_ASYNCREADINFO.npriority(this.address());
    }

    @NativeType(value="void *")
    public long userdata() {
        return FMOD_ASYNCREADINFO.nuserdata(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer buffer() {
        return FMOD_ASYNCREADINFO.nbuffer(this.address());
    }

    @NativeType(value="unsigned int")
    public int bytesread() {
        return FMOD_ASYNCREADINFO.nbytesread(this.address());
    }

    public FMOD_FILE_ASYNCDONE_FUNC done() {
        return FMOD_ASYNCREADINFO.ndone(this.address());
    }

    public FMOD_ASYNCREADINFO handle(@NativeType(value="void *") long value) {
        FMOD_ASYNCREADINFO.nhandle(this.address(), value);
        return this;
    }

    public FMOD_ASYNCREADINFO offset(@NativeType(value="unsigned int") int value) {
        FMOD_ASYNCREADINFO.noffset(this.address(), value);
        return this;
    }

    public FMOD_ASYNCREADINFO sizebytes(@NativeType(value="unsigned int") int value) {
        FMOD_ASYNCREADINFO.nsizebytes(this.address(), value);
        return this;
    }

    public FMOD_ASYNCREADINFO priority(int value) {
        FMOD_ASYNCREADINFO.npriority(this.address(), value);
        return this;
    }

    public FMOD_ASYNCREADINFO userdata(@NativeType(value="void *") long value) {
        FMOD_ASYNCREADINFO.nuserdata(this.address(), value);
        return this;
    }

    public FMOD_ASYNCREADINFO buffer(@NativeType(value="void *") ByteBuffer value) {
        FMOD_ASYNCREADINFO.nbuffer(this.address(), value);
        return this;
    }

    public FMOD_ASYNCREADINFO done(@NativeType(value="FMOD_FILE_ASYNCDONE_FUNC") FMOD_FILE_ASYNCDONE_FUNCI value) {
        FMOD_ASYNCREADINFO.ndone(this.address(), value);
        return this;
    }

    public FMOD_ASYNCREADINFO set(long handle, int offset, int sizebytes, int priority, long userdata, ByteBuffer buffer, FMOD_FILE_ASYNCDONE_FUNCI done) {
        this.handle(handle);
        this.offset(offset);
        this.sizebytes(sizebytes);
        this.priority(priority);
        this.userdata(userdata);
        this.buffer(buffer);
        this.done(done);
        return this;
    }

    public FMOD_ASYNCREADINFO set(FMOD_ASYNCREADINFO src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_ASYNCREADINFO malloc() {
        return new FMOD_ASYNCREADINFO(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_ASYNCREADINFO calloc() {
        return new FMOD_ASYNCREADINFO(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_ASYNCREADINFO create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_ASYNCREADINFO(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_ASYNCREADINFO create(long address) {
        return new FMOD_ASYNCREADINFO(address, null);
    }

    public static @Nullable FMOD_ASYNCREADINFO createSafe(long address) {
        return address == 0L ? null : new FMOD_ASYNCREADINFO(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_ASYNCREADINFO.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_ASYNCREADINFO.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_ASYNCREADINFO malloc(MemoryStack stack) {
        return new FMOD_ASYNCREADINFO(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_ASYNCREADINFO calloc(MemoryStack stack) {
        return new FMOD_ASYNCREADINFO(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OFFSET));
    }

    public static int nsizebytes(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZEBYTES));
    }

    public static int npriority(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRIORITY));
    }

    public static long nuserdata(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USERDATA));
    }

    public static ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)), (int)FMOD_ASYNCREADINFO.nbytesread(struct));
    }

    public static int nbytesread(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BYTESREAD));
    }

    public static FMOD_FILE_ASYNCDONE_FUNC ndone(long struct) {
        return FMOD_FILE_ASYNCDONE_FUNC.create(MemoryUtil.memGetAddress((long)(struct + (long)DONE)));
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)Checks.check((long)value));
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)OFFSET), (int)value);
    }

    public static void nsizebytes(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZEBYTES), (int)value);
    }

    public static void npriority(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PRIORITY), (int)value);
    }

    public static void nuserdata(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERDATA), (long)value);
    }

    public static void nbuffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFER), (long)MemoryUtil.memAddress((ByteBuffer)value));
        FMOD_ASYNCREADINFO.nbytesread(struct, value.remaining());
    }

    public static void nbytesread(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BYTESREAD), (int)value);
    }

    public static void ndone(long struct, FMOD_FILE_ASYNCDONE_FUNCI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DONE), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)HANDLE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DONE)));
    }

    static {
        Struct.Layout layout = FMOD_ASYNCREADINFO.__struct((Struct.Member[])new Struct.Member[]{FMOD_ASYNCREADINFO.__member((int)POINTER_SIZE), FMOD_ASYNCREADINFO.__member((int)4), FMOD_ASYNCREADINFO.__member((int)4), FMOD_ASYNCREADINFO.__member((int)4), FMOD_ASYNCREADINFO.__member((int)POINTER_SIZE), FMOD_ASYNCREADINFO.__member((int)POINTER_SIZE), FMOD_ASYNCREADINFO.__member((int)4), FMOD_ASYNCREADINFO.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZEBYTES = layout.offsetof(2);
        PRIORITY = layout.offsetof(3);
        USERDATA = layout.offsetof(4);
        BUFFER = layout.offsetof(5);
        BYTESREAD = layout.offsetof(6);
        DONE = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<FMOD_ASYNCREADINFO, Buffer>
    implements NativeResource {
        private static final FMOD_ASYNCREADINFO ELEMENT_FACTORY = FMOD_ASYNCREADINFO.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FMOD_ASYNCREADINFO getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return FMOD_ASYNCREADINFO.nhandle(this.address());
        }

        @NativeType(value="unsigned int")
        public int offset() {
            return FMOD_ASYNCREADINFO.noffset(this.address());
        }

        @NativeType(value="unsigned int")
        public int sizebytes() {
            return FMOD_ASYNCREADINFO.nsizebytes(this.address());
        }

        public int priority() {
            return FMOD_ASYNCREADINFO.npriority(this.address());
        }

        @NativeType(value="void *")
        public long userdata() {
            return FMOD_ASYNCREADINFO.nuserdata(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer buffer() {
            return FMOD_ASYNCREADINFO.nbuffer(this.address());
        }

        @NativeType(value="unsigned int")
        public int bytesread() {
            return FMOD_ASYNCREADINFO.nbytesread(this.address());
        }

        public FMOD_FILE_ASYNCDONE_FUNC done() {
            return FMOD_ASYNCREADINFO.ndone(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            FMOD_ASYNCREADINFO.nhandle(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="unsigned int") int value) {
            FMOD_ASYNCREADINFO.noffset(this.address(), value);
            return this;
        }

        public Buffer sizebytes(@NativeType(value="unsigned int") int value) {
            FMOD_ASYNCREADINFO.nsizebytes(this.address(), value);
            return this;
        }

        public Buffer priority(int value) {
            FMOD_ASYNCREADINFO.npriority(this.address(), value);
            return this;
        }

        public Buffer userdata(@NativeType(value="void *") long value) {
            FMOD_ASYNCREADINFO.nuserdata(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="void *") ByteBuffer value) {
            FMOD_ASYNCREADINFO.nbuffer(this.address(), value);
            return this;
        }

        public Buffer done(@NativeType(value="FMOD_FILE_ASYNCDONE_FUNC") FMOD_FILE_ASYNCDONE_FUNCI value) {
            FMOD_ASYNCREADINFO.ndone(this.address(), value);
            return this;
        }
    }
}

