/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.freetype.FT_Bitmap;
import org.lwjgl.util.freetype.FT_Face;
import org.lwjgl.util.freetype.FT_Generic;
import org.lwjgl.util.freetype.FT_Glyph_Metrics;
import org.lwjgl.util.freetype.FT_Outline;
import org.lwjgl.util.freetype.FT_Vector;

@NativeType(value="struct FT_GlyphSlotRec")
public class FT_GlyphSlot
extends Struct<FT_GlyphSlot> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LIBRARY;
    public static final int FACE;
    public static final int NEXT;
    public static final int GLYPH_INDEX;
    public static final int GENERIC;
    public static final int METRICS;
    public static final int LINEARHORIADVANCE;
    public static final int LINEARVERTADVANCE;
    public static final int ADVANCE;
    public static final int FORMAT;
    public static final int BITMAP;
    public static final int BITMAP_LEFT;
    public static final int BITMAP_TOP;
    public static final int OUTLINE;
    public static final int NUM_SUBGLYPHS;
    public static final int SUBGLYPHS;
    public static final int CONTROL_DATA;
    public static final int CONTROL_LEN;
    public static final int LSB_DELTA;
    public static final int RSB_DELTA;
    public static final int OTHER;
    public static final int INTERNAL;

    protected FT_GlyphSlot(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FT_GlyphSlot create(long address, @Nullable ByteBuffer container) {
        return new FT_GlyphSlot(address, container);
    }

    public FT_GlyphSlot(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FT_GlyphSlot.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FT_Library")
    public long library() {
        return FT_GlyphSlot.nlibrary(this.address());
    }

    public FT_Face face() {
        return FT_GlyphSlot.nface(this.address());
    }

    public @Nullable FT_GlyphSlot next() {
        return FT_GlyphSlot.nnext(this.address());
    }

    @NativeType(value="FT_UInt")
    public int glyph_index() {
        return FT_GlyphSlot.nglyph_index(this.address());
    }

    public FT_Generic generic() {
        return FT_GlyphSlot.ngeneric(this.address());
    }

    public FT_Glyph_Metrics metrics() {
        return FT_GlyphSlot.nmetrics(this.address());
    }

    @NativeType(value="FT_Fixed")
    public long linearHoriAdvance() {
        return FT_GlyphSlot.nlinearHoriAdvance(this.address());
    }

    @NativeType(value="FT_Fixed")
    public long linearVertAdvance() {
        return FT_GlyphSlot.nlinearVertAdvance(this.address());
    }

    public FT_Vector advance() {
        return FT_GlyphSlot.nadvance(this.address());
    }

    @NativeType(value="FT_Glyph_Format")
    public int format() {
        return FT_GlyphSlot.nformat(this.address());
    }

    public FT_Bitmap bitmap() {
        return FT_GlyphSlot.nbitmap(this.address());
    }

    @NativeType(value="FT_Int")
    public int bitmap_left() {
        return FT_GlyphSlot.nbitmap_left(this.address());
    }

    @NativeType(value="FT_Int")
    public int bitmap_top() {
        return FT_GlyphSlot.nbitmap_top(this.address());
    }

    public FT_Outline outline() {
        return FT_GlyphSlot.noutline(this.address());
    }

    @NativeType(value="FT_Pos")
    public long lsb_delta() {
        return FT_GlyphSlot.nlsb_delta(this.address());
    }

    @NativeType(value="FT_Pos")
    public long rsb_delta() {
        return FT_GlyphSlot.nrsb_delta(this.address());
    }

    public static FT_GlyphSlot create(long address) {
        return new FT_GlyphSlot(address, null);
    }

    public static @Nullable FT_GlyphSlot createSafe(long address) {
        return address == 0L ? null : new FT_GlyphSlot(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long nlibrary(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LIBRARY));
    }

    public static FT_Face nface(long struct) {
        return FT_Face.create(MemoryUtil.memGetAddress((long)(struct + (long)FACE)));
    }

    public static @Nullable FT_GlyphSlot nnext(long struct) {
        return FT_GlyphSlot.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static int nglyph_index(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)GLYPH_INDEX));
    }

    public static FT_Generic ngeneric(long struct) {
        return FT_Generic.create(struct + (long)GENERIC);
    }

    public static FT_Glyph_Metrics nmetrics(long struct) {
        return FT_Glyph_Metrics.create(struct + (long)METRICS);
    }

    public static long nlinearHoriAdvance(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)LINEARHORIADVANCE));
    }

    public static long nlinearVertAdvance(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)LINEARVERTADVANCE));
    }

    public static FT_Vector nadvance(long struct) {
        return FT_Vector.create(struct + (long)ADVANCE);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    public static FT_Bitmap nbitmap(long struct) {
        return FT_Bitmap.create(struct + (long)BITMAP);
    }

    public static int nbitmap_left(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BITMAP_LEFT));
    }

    public static int nbitmap_top(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BITMAP_TOP));
    }

    public static FT_Outline noutline(long struct) {
        return FT_Outline.create(struct + (long)OUTLINE);
    }

    public static int nnum_subglyphs(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUM_SUBGLYPHS));
    }

    public static long nsubglyphs(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SUBGLYPHS));
    }

    public static @Nullable ByteBuffer ncontrol_data(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTROL_DATA)), (int)((int)FT_GlyphSlot.ncontrol_len(struct)));
    }

    public static long ncontrol_len(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)CONTROL_LEN));
    }

    public static long nlsb_delta(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)LSB_DELTA));
    }

    public static long nrsb_delta(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)RSB_DELTA));
    }

    public static long nother(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OTHER));
    }

    public static long ninternal(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INTERNAL));
    }

    static {
        Struct.Layout layout = FT_GlyphSlot.__struct((Struct.Member[])new Struct.Member[]{FT_GlyphSlot.__member((int)POINTER_SIZE), FT_GlyphSlot.__member((int)POINTER_SIZE), FT_GlyphSlot.__member((int)POINTER_SIZE), FT_GlyphSlot.__member((int)4), FT_GlyphSlot.__member((int)FT_Generic.SIZEOF, (int)FT_Generic.ALIGNOF), FT_GlyphSlot.__member((int)FT_Glyph_Metrics.SIZEOF, (int)FT_Glyph_Metrics.ALIGNOF), FT_GlyphSlot.__member((int)CLONG_SIZE), FT_GlyphSlot.__member((int)CLONG_SIZE), FT_GlyphSlot.__member((int)FT_Vector.SIZEOF, (int)FT_Vector.ALIGNOF), FT_GlyphSlot.__member((int)4), FT_GlyphSlot.__member((int)FT_Bitmap.SIZEOF, (int)FT_Bitmap.ALIGNOF), FT_GlyphSlot.__member((int)4), FT_GlyphSlot.__member((int)4), FT_GlyphSlot.__member((int)FT_Outline.SIZEOF, (int)FT_Outline.ALIGNOF), FT_GlyphSlot.__member((int)4), FT_GlyphSlot.__member((int)POINTER_SIZE), FT_GlyphSlot.__member((int)POINTER_SIZE), FT_GlyphSlot.__member((int)CLONG_SIZE), FT_GlyphSlot.__member((int)CLONG_SIZE), FT_GlyphSlot.__member((int)CLONG_SIZE), FT_GlyphSlot.__member((int)POINTER_SIZE), FT_GlyphSlot.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LIBRARY = layout.offsetof(0);
        FACE = layout.offsetof(1);
        NEXT = layout.offsetof(2);
        GLYPH_INDEX = layout.offsetof(3);
        GENERIC = layout.offsetof(4);
        METRICS = layout.offsetof(5);
        LINEARHORIADVANCE = layout.offsetof(6);
        LINEARVERTADVANCE = layout.offsetof(7);
        ADVANCE = layout.offsetof(8);
        FORMAT = layout.offsetof(9);
        BITMAP = layout.offsetof(10);
        BITMAP_LEFT = layout.offsetof(11);
        BITMAP_TOP = layout.offsetof(12);
        OUTLINE = layout.offsetof(13);
        NUM_SUBGLYPHS = layout.offsetof(14);
        SUBGLYPHS = layout.offsetof(15);
        CONTROL_DATA = layout.offsetof(16);
        CONTROL_LEN = layout.offsetof(17);
        LSB_DELTA = layout.offsetof(18);
        RSB_DELTA = layout.offsetof(19);
        OTHER = layout.offsetof(20);
        INTERNAL = layout.offsetof(21);
    }

    public static class Buffer
    extends StructBuffer<FT_GlyphSlot, Buffer> {
        private static final FT_GlyphSlot ELEMENT_FACTORY = FT_GlyphSlot.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FT_GlyphSlot getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FT_Library")
        public long library() {
            return FT_GlyphSlot.nlibrary(this.address());
        }

        public FT_Face face() {
            return FT_GlyphSlot.nface(this.address());
        }

        public @Nullable FT_GlyphSlot next() {
            return FT_GlyphSlot.nnext(this.address());
        }

        @NativeType(value="FT_UInt")
        public int glyph_index() {
            return FT_GlyphSlot.nglyph_index(this.address());
        }

        public FT_Generic generic() {
            return FT_GlyphSlot.ngeneric(this.address());
        }

        public FT_Glyph_Metrics metrics() {
            return FT_GlyphSlot.nmetrics(this.address());
        }

        @NativeType(value="FT_Fixed")
        public long linearHoriAdvance() {
            return FT_GlyphSlot.nlinearHoriAdvance(this.address());
        }

        @NativeType(value="FT_Fixed")
        public long linearVertAdvance() {
            return FT_GlyphSlot.nlinearVertAdvance(this.address());
        }

        public FT_Vector advance() {
            return FT_GlyphSlot.nadvance(this.address());
        }

        @NativeType(value="FT_Glyph_Format")
        public int format() {
            return FT_GlyphSlot.nformat(this.address());
        }

        public FT_Bitmap bitmap() {
            return FT_GlyphSlot.nbitmap(this.address());
        }

        @NativeType(value="FT_Int")
        public int bitmap_left() {
            return FT_GlyphSlot.nbitmap_left(this.address());
        }

        @NativeType(value="FT_Int")
        public int bitmap_top() {
            return FT_GlyphSlot.nbitmap_top(this.address());
        }

        public FT_Outline outline() {
            return FT_GlyphSlot.noutline(this.address());
        }

        @NativeType(value="FT_Pos")
        public long lsb_delta() {
            return FT_GlyphSlot.nlsb_delta(this.address());
        }

        @NativeType(value="FT_Pos")
        public long rsb_delta() {
            return FT_GlyphSlot.nrsb_delta(this.address());
        }
    }
}

