/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.dto.Backup;
import com.mojang.realmsclient.gui.MovableScrolledSelectionList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.Tezzelator;
import org.lwjgl.input.Keyboard;

public class BackupInfoScreen
extends RealmsScreen {
    private final RealmsScreen lastScreen;
    private final int BUTTON_BACK_ID = 0;
    private final Backup backup;
    private List<String> keys = new ArrayList<String>();
    private BackupInfoList backupInfoList;
    String[] difficulties = new String[]{BackupInfoScreen.getLocalizedString((String)"options.difficulty.peaceful"), BackupInfoScreen.getLocalizedString((String)"options.difficulty.easy"), BackupInfoScreen.getLocalizedString((String)"options.difficulty.normal"), BackupInfoScreen.getLocalizedString((String)"options.difficulty.hard")};
    String[] gameModes = new String[]{BackupInfoScreen.getLocalizedString((String)"selectWorld.gameMode.survival"), BackupInfoScreen.getLocalizedString((String)"selectWorld.gameMode.creative"), BackupInfoScreen.getLocalizedString((String)"selectWorld.gameMode.adventure")};

    public BackupInfoScreen(RealmsScreen lastScreen, Backup backup) {
        this.lastScreen = lastScreen;
        this.backup = backup;
        if (backup.changeList != null) {
            for (Map.Entry<String, String> entry : backup.changeList.entrySet()) {
                this.keys.add(entry.getKey());
            }
        }
    }

    public void tick() {
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsAdd(BackupInfoScreen.newButton((int)0, (int)(this.width() / 2 - 100), (int)(this.height() / 4 + 120 + 24), (String)BackupInfoScreen.getLocalizedString((String)"gui.back")));
        this.backupInfoList = new BackupInfoList();
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 0) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString("Changes from last backup", this.width() / 2, 10, 0xFFFFFF);
        this.backupInfoList.render(xm, ym, a);
        super.render(xm, ym, a);
    }

    private String checkForSpecificMetadata(String key, String value) {
        String k = key.toLowerCase();
        if (k.contains("game") && k.contains("mode")) {
            return this.gameModeMetadata(value);
        }
        if (k.contains("game") && k.contains("difficulty")) {
            return this.gameDifficultyMetadata(value);
        }
        return value;
    }

    private String gameDifficultyMetadata(String value) {
        try {
            return this.difficulties[Integer.parseInt(value)];
        }
        catch (Exception e) {
            return "UNKNOWN";
        }
    }

    private String gameModeMetadata(String value) {
        try {
            return this.gameModes[Integer.parseInt(value)];
        }
        catch (Exception e) {
            return "UNKNOWN";
        }
    }

    private class BackupInfoList
    extends MovableScrolledSelectionList {
        public BackupInfoList() {
            super(0, 30, BackupInfoScreen.this.width(), BackupInfoScreen.this.height() - 84, 30);
        }

        @Override
        protected int getNumberOfItems() {
            return ((BackupInfoScreen)BackupInfoScreen.this).backup.changeList.size();
        }

        @Override
        protected void selectItem(int item, boolean doubleClick) {
        }

        @Override
        protected boolean isSelectedItem(int item) {
            return false;
        }

        @Override
        protected int getMaxPosition() {
            return this.getNumberOfItems() * 30;
        }

        @Override
        protected void renderBackground() {
        }

        @Override
        protected void renderItem(int i, int x, int y, int h, Tezzelator t) {
            String key = (String)BackupInfoScreen.this.keys.get(i);
            BackupInfoScreen.this.drawString(key, BackupInfoScreen.this.width() / 2 - 40, y, 0xFFFFFF);
            String metadataValue = ((BackupInfoScreen)BackupInfoScreen.this).backup.changeList.get(key);
            BackupInfoScreen.this.drawString(BackupInfoScreen.this.checkForSpecificMetadata(key, metadataValue), BackupInfoScreen.this.width() / 2 - 40, y + 12, 0xA0A0A0);
        }
    }
}

