/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.asm.FMLSanityChecker;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameData$GameDataSnapshot;
import cpw.mods.fml.relauncher.Side;
import fgm.IIiiiIIiiiiiiIiIiIiiiiIIIIIIiIiIiiiIiiIiiIiiIIIIIiIIIiiIIiiiIiII;
import fgm.IiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI;
import fgm.IiIiiiIIiIIiiiiIiiIiIiiIiiiiiIiIiiiiIiiIiiIIIIiiIiIIIIIiIIIIIIIi;
import fgm.iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi;
import fgm.iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata modMetadata = this.getMetadata();
        modMetadata.modId = "FML";
        modMetadata.name = "Forge Mod Loader";
        modMetadata.version = Loader.instance().getFMLVersionString();
        modMetadata.credits = "Made possible with help from many people";
        modMetadata.authorList = Arrays.asList("cpw", "LexManos", "Player");
        modMetadata.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        modMetadata.url = "https://github.com/MinecraftForge/FML/wiki";
        modMetadata.updateUrl = "https://github.com/MinecraftForge/FML/wiki";
        modMetadata.screenshots = new String[0];
        modMetadata.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii getDataForWriting(IIiiiIIiiiiiiIiIiIiiiiIIIIIIiIiIiiiIiiIiiIiiIIIIIiIIIiiIIiiiIiII handler, IiIiiiIIiIIiiiiIiiIiIiiIiiiiiIiIiiiiIiiIiiIIIIiiIiIIIIIiIIIIIIIi info) {
        Object object;
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2 = new iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii();
        iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi2 = new iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi();
        for (ModContainer object52 : Loader.instance().getActiveModList()) {
            object = new iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii();
            ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object).IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ModId", object52.getModId());
            ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object).IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ModVersion", object52.getVersion());
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii((IiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI)object);
        }
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ModList", iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi2);
        iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3 = new iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi();
        FMLLog.fine("Gathering id map for writing to world save %s", info.IIIIIiiiIiIiiiiIIIiiiiIiiiIiiIIiiiiIIIiIIIIiIiiiiiiiIIIiIiiiiiII());
        GameData$GameDataSnapshot gameData$GameDataSnapshot = GameData.buildItemDataList();
        for (Map.Entry entry : gameData$GameDataSnapshot.idMap.entrySet()) {
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii3 = new iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii();
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii3.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", (String)entry.getKey());
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii3.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("V", (Integer)entry.getValue());
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii3);
        }
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ItemData", iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3);
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("BlockedItemIds", GameData.getBlockedIds());
        object = new iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi();
        for (Map.Entry<String, String> entry : GameData.getBlockRegistry().getAliases().entrySet()) {
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii4 = new iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii();
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii4.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", entry.getKey());
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii4.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("V", entry.getValue());
            ((iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi)object).IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii4);
        }
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("BlockAliases", (IiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI)object);
        iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi4 = new iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi();
        for (String string : gameData$GameDataSnapshot.blockSubstitutions) {
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii5 = new iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii();
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii5.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", string);
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi4.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii5);
        }
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("BlockSubstitutions", iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi4);
        iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi5 = new iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi();
        for (Map.Entry<String, String> entry : GameData.getItemRegistry().getAliases().entrySet()) {
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii6 = new iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii();
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii6.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", entry.getKey());
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii6.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("V", entry.getValue());
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi5.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii6);
        }
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ItemAliases", iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi5);
        iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi6 = new iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi();
        for (String string : gameData$GameDataSnapshot.itemSubstitutions) {
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii7 = new iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii();
            iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii7.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("K", string);
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi6.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii7);
        }
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii("ItemSubstitutions", iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi6);
        return iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2;
    }

    @Override
    public void readData(IIiiiIIiiiiiiIiIiIiiiiIIIIIIiIiIiiiIiiIiiIiiIIIIIiIIIiiIIiiiIiII handler, IiIiiiIIiIIiiiiIiiIiIiiIiiiiiIiIiiiiIiiIiiIIIIiiIiIIIIIiIIIIIIIi info, Map<String, IiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI> propertyMap, iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii tag) {
        Object object;
        Object object2;
        Iterator iterator;
        List<String> list;
        if (tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ModList")) {
            list = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ModList", 10);
            for (int i = 0; i < ((iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi)((Object)list)).IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                iterator = ((iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi)((Object)list)).iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                String string = ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)((Object)iterator)).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ModId");
                object2 = ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)((Object)iterator)).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ModVersion");
                object = Loader.instance().getIndexedModList().get(string);
                if (object == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", string);
                    continue;
                }
                if (((String)object2).equals(object.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", string, object2, object.getVersion());
            }
        }
        list = null;
        if (tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ModItemData")) {
            FMLLog.info("Attempting to convert old world data to new system. This may be trouble!", new Object[0]);
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi2 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ModItemData", 10);
            iterator = Maps.newLinkedHashMap();
            for (int i = 0; i < iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi2.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                String string;
                object2 = iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi2.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                object = ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ModId");
                var11_19 = ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ItemType");
                int n = ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII("ItemId");
                int n2 = ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII("ordinal");
                var14_32 = ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ForcedModId") ? ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ForcedModId") : null;
                String string2 = string = ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ForcedName") ? ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("ForcedName") : null;
                if (string == null) {
                    FMLLog.warning("Found unlabelled item in world save, this may cause problems. The item type %s:%d will not be present", var11_19, n2);
                    continue;
                }
                String string3 = String.format("%c%s:%s", Character.valueOf('\u0002'), var14_32 != null ? var14_32 : object, string);
                iterator.put(string3, n);
            }
            list = GameData.injectWorldIDMap(iterator, (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), true, true);
        } else if (tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ItemData")) {
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ItemData", 10);
            iterator = Maps.newLinkedHashMap();
            for (int i = 0; i < iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                object2 = iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                if (((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K").contains("FGM:")) continue;
                iterator.put(((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"), ((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)object2).iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII("V"));
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (!tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("BlockedItemIds")) {
                GameData.fixBrokenIds(iterator, hashSet);
            }
            for (Object object3 : (Object)tag.iIIIiIiIiiIiIiIIiIIIIIiiIIiIiiIiiiiiiIIiiIiiIiiIIiiIIIiiIIiIIIII("BlockedItemIds")) {
                hashSet.add((int)object3);
            }
            object2 = new HashMap<String, String>();
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("BlockAliases", 10);
            for (int i = 0; i < iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2 = iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                object2.put(iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"), iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("V"));
            }
            object = Sets.newHashSet();
            if (tag.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI("BlockSubstitutions", 9)) {
                iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("BlockSubstitutions", 10);
                for (int i = 0; i < iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                    iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii3 = iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                    object.add(iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii3.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"));
                }
            }
            var11_19 = new HashMap();
            iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ItemAliases", 10);
            for (int i = 0; i < iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii4 = iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                var11_19.put(iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii4.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"), iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii4.iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("V"));
            }
            HashSet hashSet2 = Sets.newHashSet();
            if (tag.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI("ItemSubstitutions", 9)) {
                iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3 = tag.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI("ItemSubstitutions", 10);
                for (int i = 0; i < iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII(); ++i) {
                    var14_32 = iIIIiiiiIIiiIIIiIiIiiIIIIiiiIIIIiiIIiIIIIIiIiIIIiIIiIiiiIiiiiIIi3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(i);
                    hashSet2.add(((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)var14_32).iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii("K"));
                }
            }
            try {
                list = GameData.injectWorldIDMap(iterator, hashSet, object2, (Map<String, String>)var11_19, (Set<String>)object, hashSet2, true, true);
            }
            catch (IllegalStateException illegalStateException) {
                var14_32 = "The world state is utterly corrupted and this save is NOT loadable\n\nThere is a high probability that a mod has broken the\nID map and there is\nNOTHING FML or Forge can do to recover this save.\n\nIf you changed your mods, try reverting the change";
                FMLLog.log(Level.FATAL, illegalStateException, (String)var14_32, new Object[0]);
                StartupQuery.notify((String)var14_32);
                StartupQuery.abort();
            }
        }
        if (list != null && !list.isEmpty()) {
            String string = "Forge Mod Loader could not load this save.\n\nThere are " + list.size() + " unassigned blocks and items in this save.\nYou will not be able to load until they are present again.\n\nMissing Blocks/Items:\n";
            for (String string4 : list) {
                string = string + string4 + "\n";
            }
            StartupQuery.notify(string);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificateArray = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificateArray != null ? certificateArray[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "cpw.mods.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

