/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.FMLModContainer$1;
import cpw.mods.fml.common.FMLModContainer$2;
import cpw.mods.fml.common.ILanguageAdapter;
import cpw.mods.fml.common.ILanguageAdapter$JavaAdapter;
import cpw.mods.fml.common.ILanguageAdapter$ScalaAdapter;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainer$Disableable;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.io.FileInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class FMLModContainer
implements ModContainer {
    private Object modInstance;
    private File source;
    private ModMetadata modMetadata;
    private String className;
    private Map<String, Object> descriptor;
    private boolean enabled = true;
    private String internalVersion;
    private boolean overridesMetadata;
    private EventBus eventBus;
    private LoadController controller;
    private DefaultArtifactVersion processedVersion;
    private String annotationDependencies;
    private VersionRange minecraftAccepted;
    private boolean fingerprintNotPresent;
    private Set<String> sourceFingerprints;
    private Certificate certificate;
    private String modLanguage;
    private ILanguageAdapter languageAdapter;
    private ModContainer$Disableable disableability;
    private ListMultimap<Class<? extends FMLEvent>, Method> eventMethods;
    private Map<String, String> customModProperties;
    private ModCandidate candidate;

    public FMLModContainer(String className, ModCandidate container, Map<String, Object> modDescriptor) {
        this.className = className;
        this.source = container.getModContainer();
        this.candidate = container;
        this.descriptor = modDescriptor;
        this.eventMethods = ArrayListMultimap.create();
        this.modLanguage = (String)modDescriptor.get("modLanguage");
        String string = (String)modDescriptor.get("modLanguageAdapter");
        if (Strings.isNullOrEmpty((String)string)) {
            this.languageAdapter = "scala".equals(this.modLanguage) ? new ILanguageAdapter$ScalaAdapter() : new ILanguageAdapter$JavaAdapter();
        } else {
            try {
                this.languageAdapter = (ILanguageAdapter)Class.forName(string, true, Loader.instance().getModClassLoader()).newInstance();
                FMLLog.finer("Using custom language adapter %s (type %s) for %s (modid %s)", this.languageAdapter, string, this.className, this.getModId());
            }
            catch (Exception exception) {
                FMLLog.log(Level.ERROR, exception, "Error constructing custom mod language adapter %s (referenced by %s) (modid: %s)", string, this.className, this.getModId());
                throw new LoaderException(exception);
            }
        }
    }

    private ILanguageAdapter getLanguageAdapter() {
        return this.languageAdapter;
    }

    @Override
    public String getModId() {
        return (String)this.descriptor.get("modid");
    }

    @Override
    public String getName() {
        return this.modMetadata.name;
    }

    @Override
    public String getVersion() {
        return this.internalVersion;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.modMetadata;
    }

    @Override
    public void bindMetadata(MetadataCollection mc) {
        Object object;
        this.modMetadata = mc.getMetadataForId(this.getModId(), this.descriptor);
        if (this.descriptor.containsKey("useMetadata")) {
            boolean bl = this.overridesMetadata = (Boolean)this.descriptor.get("useMetadata") == false;
        }
        if (this.overridesMetadata || !this.modMetadata.useDependencyInformation) {
            object = Sets.newHashSet();
            ArrayList arrayList = Lists.newArrayList();
            ArrayList arrayList2 = Lists.newArrayList();
            this.annotationDependencies = (String)this.descriptor.get("dependencies");
            Loader.instance().computeDependencies(this.annotationDependencies, (Set<ArtifactVersion>)object, arrayList, arrayList2);
            arrayList2.addAll(Loader.instance().getInjectedBefore(this.getModId()));
            arrayList.addAll(Loader.instance().getInjectedAfter(this.getModId()));
            this.modMetadata.requiredMods = object;
            this.modMetadata.dependencies = arrayList;
            this.modMetadata.dependants = arrayList2;
            FMLLog.log(this.getModId(), Level.TRACE, "Parsed dependency info : %s %s %s", object, arrayList, arrayList2);
        } else {
            FMLLog.log(this.getModId(), Level.TRACE, "Using mcmod dependency info : %s %s %s", this.modMetadata.requiredMods, this.modMetadata.dependencies, this.modMetadata.dependants);
        }
        if (Strings.isNullOrEmpty((String)this.modMetadata.name)) {
            FMLLog.log(this.getModId(), Level.INFO, "Mod %s is missing the required element 'name'. Substituting %s", this.getModId(), this.getModId());
            this.modMetadata.name = this.getModId();
        }
        this.internalVersion = (String)this.descriptor.get("version");
        if (Strings.isNullOrEmpty((String)this.internalVersion) && (object = this.searchForVersionProperties()) != null) {
            this.internalVersion = ((Properties)object).getProperty(this.getModId() + ".version");
            FMLLog.log(this.getModId(), Level.DEBUG, "Found version %s for mod %s in version.properties, using", this.internalVersion, this.getModId());
        }
        if (Strings.isNullOrEmpty((String)this.internalVersion) && !Strings.isNullOrEmpty((String)this.modMetadata.version)) {
            FMLLog.log(this.getModId(), Level.WARN, "Mod %s is missing the required element 'version' and a version.properties file could not be found. Falling back to metadata version %s", this.getModId(), this.modMetadata.version);
            this.internalVersion = this.modMetadata.version;
        }
        if (Strings.isNullOrEmpty((String)this.internalVersion)) {
            FMLLog.log(this.getModId(), Level.WARN, "Mod %s is missing the required element 'version' and no fallback can be found. Substituting '1.0'.", this.getModId());
            this.internalVersion = "1.0";
            this.modMetadata.version = "1.0";
        }
        this.minecraftAccepted = !Strings.isNullOrEmpty((String)(object = (String)this.descriptor.get("acceptedMinecraftVersions"))) ? VersionParser.parseRange((String)object) : Loader.instance().getMinecraftModContainer().getStaticVersionRange();
    }

    public Properties searchForVersionProperties() {
        try {
            File file;
            FMLLog.log(this.getModId(), Level.DEBUG, "Attempting to load the file version.properties from %s to locate a version number for %s", this.getSource().getName(), this.getModId());
            Properties properties = null;
            if (this.getSource().isFile()) {
                ZipFile zipFile = new ZipFile(this.getSource());
                ZipEntry zipEntry = zipFile.getEntry("version.properties");
                if (zipEntry != null) {
                    properties = new Properties();
                    properties.load(zipFile.getInputStream(zipEntry));
                }
                zipFile.close();
            } else if (this.getSource().isDirectory() && (file = new File(this.getSource(), "version.properties")).exists() && file.isFile()) {
                properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            return properties;
        }
        catch (Exception exception) {
            Throwables.propagateIfPossible((Throwable)exception);
            FMLLog.log(this.getModId(), Level.TRACE, "Failed to find a usable version.properties file", new Object[0]);
            return null;
        }
    }

    @Override
    public void setEnabledState(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Set<ArtifactVersion> getRequirements() {
        return this.modMetadata.requiredMods;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.modMetadata.dependencies;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.modMetadata.dependants;
    }

    @Override
    public String getSortingRules() {
        return this.overridesMetadata || !this.modMetadata.useDependencyInformation ? Strings.nullToEmpty((String)this.annotationDependencies) : this.modMetadata.printableSortingRules();
    }

    @Override
    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    @Override
    public Object getMod() {
        return this.modInstance;
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        if (this.enabled) {
            FMLLog.log(this.getModId(), Level.DEBUG, "Enabling mod %s", this.getModId());
            this.eventBus = bus;
            this.controller = controller;
            this.eventBus.register((Object)this);
            return true;
        }
        return false;
    }

    private Method gatherAnnotations(Class<?> clazz) {
        Method method = null;
        for (Method method2 : clazz.getDeclaredMethods()) {
            for (Annotation annotation : method2.getAnnotations()) {
                if ("cpw.mods.fml.common.Mod$EventHandler".equals(annotation.annotationType().getName())) {
                    Class<?>[] classArray = method2.getParameterTypes();
                    if (classArray.length == 1 && this.isFMLEventType(classArray[0])) {
                        method2.setAccessible(true);
                        this.eventMethods.put(method2.getParameterTypes()[0], (Object)method2);
                        continue;
                    }
                    FMLLog.log(this.getModId(), Level.ERROR, "The mod %s appears to have an invalid event annotation %s. This annotation can only apply to methods with recognized event arguments - it will not be called", this.getModId(), annotation.annotationType().getSimpleName());
                    continue;
                }
                if (!"cpw.mods.fml.common.Mod$InstanceFactory".equals(annotation.annotationType().getName())) continue;
                if (Modifier.isStatic(method2.getModifiers()) && method2.getParameterTypes().length == 0 && method == null) {
                    method2.setAccessible(true);
                    method = method2;
                    continue;
                }
                if (!Modifier.isStatic(method2.getModifiers()) || method2.getParameterTypes().length != 0) {
                    FMLLog.log(this.getModId(), Level.ERROR, "The InstanceFactory annotation can only apply to a static method, taking zero arguments - it will be ignored on %s(%s)", method2.getName(), Arrays.asList(method2.getParameterTypes()));
                    continue;
                }
                if (method == null) continue;
                FMLLog.log(this.getModId(), Level.ERROR, "The InstanceFactory annotation can only be used once, the application to %s(%s) will be ignored", method2.getName(), Arrays.asList(method2.getParameterTypes()));
            }
        }
        FMLLog.log(this.getModId(), Level.DEBUG, "[EventHandler] Total registered handlers: %d", this.eventMethods.size());
        return method;
    }

    private boolean isFMLEventType(Class<?> cls) {
        while (cls != null) {
            if ("cpw.mods.fml.common.event.FMLEvent".equals(cls.getName())) {
                return true;
            }
            cls = cls.getSuperclass();
        }
        return false;
    }

    private boolean isAssignableByName(String declaredTypeName, Class<?> runtimeClass) {
        for (Class<?> clazz = runtimeClass; clazz != null; clazz = clazz.getSuperclass()) {
            if (!declaredTypeName.equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private void processFieldAnnotations(ASMDataTable asmDataTable) {
        SetMultimap<String, ASMDataTable$ASMData> setMultimap = asmDataTable.getAnnotationsFor(this);
        this.parseSimpleFieldAnnotation(setMultimap, Mod.Instance.class.getName(), new FMLModContainer$1(this));
        this.parseSimpleFieldAnnotation(setMultimap, Mod.Metadata.class.getName(), new FMLModContainer$2(this));
    }

    private void parseSimpleFieldAnnotation(SetMultimap<String, ASMDataTable$ASMData> annotations, String annotationClassName, Function<ModContainer, Object> retreiver) {
        String[] stringArray = annotationClassName.split("\\.");
        String string = stringArray[stringArray.length - 1];
        for (ASMDataTable$ASMData aSMDataTable$ASMData : annotations.get((Object)annotationClassName)) {
            String string2 = (String)aSMDataTable$ASMData.getAnnotationInfo().get("value");
            Field field = null;
            Object object = null;
            ModContainer modContainer = this;
            boolean bl = false;
            Class<?> clazz = this.modInstance.getClass();
            if (!Strings.isNullOrEmpty((String)string2)) {
                modContainer = Loader.isModLoaded(string2) ? Loader.instance().getIndexedModList().get(string2) : null;
            }
            if (modContainer != null) {
                try {
                    clazz = Class.forName(aSMDataTable$ASMData.getClassName(), true, Loader.instance().getModClassLoader());
                    field = clazz.getDeclaredField(aSMDataTable$ASMData.getObjectName());
                    field.setAccessible(true);
                    bl = Modifier.isStatic(field.getModifiers());
                    object = retreiver.apply((Object)modContainer);
                }
                catch (Exception exception) {
                    Throwables.propagateIfPossible((Throwable)exception);
                    FMLLog.log(this.getModId(), Level.WARN, exception, "Attempting to load @%s in class %s for %s and failing", string, aSMDataTable$ASMData.getClassName(), modContainer.getModId());
                }
            }
            if (field == null) continue;
            Object object2 = null;
            if (!bl) {
                object2 = this.modInstance;
                if (!this.modInstance.getClass().equals(clazz)) {
                    FMLLog.log(this.getModId(), Level.WARN, "Unable to inject @%s in non-static field %s.%s for %s as it is NOT the primary mod instance", string, aSMDataTable$ASMData.getClassName(), aSMDataTable$ASMData.getObjectName(), modContainer.getModId());
                    continue;
                }
            }
            field.set(object2, object);
        }
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        try {
            boolean bl;
            Object object3;
            Object object2;
            List list;
            ModClassLoader modClassLoader = event.getModClassLoader();
            modClassLoader.addFile(this.source);
            modClassLoader.clearNegativeCacheFor(this.candidate.getClassList());
            Class<?> clazz = Class.forName(this.className, true, modClassLoader);
            Certificate[] certificateArray = clazz.getProtectionDomain().getCodeSource().getCertificates();
            int n = 0;
            if (certificateArray != null) {
                n = certificateArray.length;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < n; ++i) {
                builder.add((Object)CertificateHelper.getFingerprint(certificateArray[i]));
            }
            ImmutableList immutableList = builder.build();
            this.sourceFingerprints = ImmutableSet.copyOf((Collection)immutableList);
            String string = (String)this.descriptor.get("certificateFingerprint");
            this.fingerprintNotPresent = true;
            if (string != null && !string.isEmpty()) {
                if (!this.sourceFingerprints.contains(string)) {
                    list = Level.ERROR;
                    if (this.source.isDirectory()) {
                        list = Level.TRACE;
                    }
                    FMLLog.log(this.getModId(), (Level)list, "The mod %s is expecting signature %s for source %s, however there is no signature matching that description", this.getModId(), string, this.source.getName());
                } else {
                    this.certificate = certificateArray[immutableList.indexOf((Object)string)];
                    this.fingerprintNotPresent = false;
                }
            }
            if ((list = (List)this.descriptor.get("customProperties")) != null) {
                object2 = ImmutableMap.builder();
                for (Object object3 : list) {
                    object2.put((Object)((String)object3.get("k")), (Object)((String)object3.get("v")));
                }
                this.customModProperties = object2.build();
            } else {
                this.customModProperties = EMPTY_PROPERTIES;
            }
            object2 = (Boolean)this.descriptor.get("canBeDeactivated");
            boolean bl2 = bl = !event.getReverseDependencies().get((Object)this.getModId()).isEmpty();
            this.disableability = object2 != null && ((Boolean)object2).booleanValue() ? (bl ? ModContainer$Disableable.DEPENDENCIES : ModContainer$Disableable.YES) : (bl ? ModContainer$Disableable.DEPENDENCIES : ModContainer$Disableable.RESTART);
            try {
                object3 = Class.forName("cpw.mods.fml.common.event.FMLEvent", false, modClassLoader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object3 = this.gatherAnnotations(clazz);
            this.modInstance = this.getLanguageAdapter().getNewInstance(this, clazz, modClassLoader, (Method)object3);
            NetworkRegistry.INSTANCE.register(this, clazz, (String)(this.descriptor.containsKey("acceptableRemoteVersions") ? this.descriptor.get("acceptableRemoteVersions") : null), event.getASMHarvestedData());
            if (this.fingerprintNotPresent) {
                this.eventBus.post((Object)new FMLFingerprintViolationEvent(this.source.isDirectory(), this.source, (ImmutableSet<String>)ImmutableSet.copyOf(this.sourceFingerprints), string));
            }
            ProxyInjector.inject(this, event.getASMHarvestedData(), FMLCommonHandler.instance().getSide(), this.getLanguageAdapter());
            this.processFieldAnnotations(event.getASMHarvestedData());
        }
        catch (Throwable throwable) {
            this.controller.errorOccurred(this, throwable);
        }
    }

    @Subscribe
    public void handleModStateEvent(FMLEvent event) {
        try {
            ClassLoader classLoader = event.getClass().getClassLoader();
            int n = 0;
            for (Method method : this.eventMethods.values()) {
                Class<?> clazz = method.getParameterTypes()[0];
                if (!this.isAssignableByName(clazz.getName(), event.getClass())) continue;
                if (clazz.isInstance(event)) {
                    method.invoke(this.modInstance, event);
                    ++n;
                    continue;
                }
                ClassLoader classLoader2 = clazz.getClassLoader();
                ClassLoader classLoader3 = event.getClass().getClassLoader();
            }
        }
        catch (Throwable throwable) {
            this.controller.errorOccurred(this, throwable);
        }
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            this.processedVersion = new DefaultArtifactVersion(this.getModId(), this.getVersion());
        }
        return this.processedVersion;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public String getDisplayVersion() {
        return this.modMetadata.version;
    }

    @Override
    public VersionRange acceptableMinecraftVersionRange() {
        return this.minecraftAccepted;
    }

    @Override
    public Certificate getSigningCertificate() {
        return this.certificate;
    }

    public String toString() {
        return "FMLMod:" + this.getModId() + "{" + this.getVersion() + "}";
    }

    @Override
    public Map<String, String> getCustomModProperties() {
        return this.customModProperties;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        try {
            return this.getSource().isDirectory() ? Class.forName("cpw.mods.fml.client.FMLFolderResourcePack", true, this.getClass().getClassLoader()) : Class.forName("cpw.mods.fml.client.FMLFileResourcePack", true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public Map<String, String> getSharedModDescriptor() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("modsystem", "FML");
        hashMap.put("id", this.getModId());
        hashMap.put("version", this.getDisplayVersion());
        hashMap.put("name", this.getName());
        hashMap.put("url", this.modMetadata.url);
        hashMap.put("authors", this.modMetadata.getAuthorList());
        hashMap.put("description", this.modMetadata.description);
        return hashMap;
    }

    @Override
    public ModContainer$Disableable canBeDisabled() {
        return this.disableability;
    }

    @Override
    public String getGuiClassName() {
        return (String)this.descriptor.get("guiFactory");
    }

    @Override
    public List<String> getOwnedPackages() {
        return this.candidate.getContainedPackages();
    }
}

