/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.DuplicateModsFoundException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader$1;
import cpw.mods.fml.common.Loader$2;
import cpw.mods.fml.common.Loader$3;
import cpw.mods.fml.common.Loader$ModIdComparator;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.LoaderState$ModState;
import cpw.mods.fml.common.MCPDummyContainer;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.MinecraftDummyContainer;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainer$Disableable;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.ProgressManager$ProgressBar;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.common.event.FMLInterModComms$IMCEvent;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent$Action;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent$MissingMapping;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.functions.ArtifactVersionNameFunction;
import cpw.mods.fml.common.functions.ModIdFunction;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry$Type;
import cpw.mods.fml.common.registry.ItemStackHolderInjector;
import cpw.mods.fml.common.registry.ObjectHolderRegistry;
import cpw.mods.fml.common.toposort.ModSorter;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.common.toposort.ModSortingException$SortingExceptionData;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.ModListHelper;
import cpw.mods.fml.relauncher.Side;
import fgm.IIIiiIiiiIiiiIIiiIiiiIiiIiIiIiiIiiIiIIiIIiiiiiiIiiIIIiIiIIiIIIII;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class Loader {
    @ObfuscationIgnore
    public static final String MC_VERSION = "1.7.10";
    @ObfuscationIgnore
    private static final Splitter DEPENDENCYPARTSPLITTER = Splitter.on((String)":").omitEmptyStrings().trimResults();
    @ObfuscationIgnore
    private static final Splitter DEPENDENCYSPLITTER = Splitter.on((String)";").omitEmptyStrings().trimResults();
    @ObfuscationIgnore
    private static Loader instance;
    @ObfuscationIgnore
    private static String major;
    @ObfuscationIgnore
    private static String minor;
    @ObfuscationIgnore
    private static String rev;
    @ObfuscationIgnore
    private static String build;
    @ObfuscationIgnore
    private static String mccversion;
    @ObfuscationIgnore
    private static String mcpversion;
    @ObfuscationIgnore
    private ModClassLoader modClassLoader;
    @ObfuscationIgnore
    private List<ModContainer> mods;
    @ObfuscationIgnore
    private Map<String, ModContainer> namedMods;
    @ObfuscationIgnore
    private ListMultimap<String, String> reverseDependencies;
    @ObfuscationIgnore
    private File canonicalConfigDir;
    @ObfuscationIgnore
    private File canonicalModsDir;
    @ObfuscationIgnore
    private LoadController modController;
    @ObfuscationIgnore
    private MinecraftDummyContainer minecraft;
    @ObfuscationIgnore
    private MCPDummyContainer mcp;
    @ObfuscationIgnore
    private static File minecraftDir;
    @ObfuscationIgnore
    private static List<String> injectedContainers;
    @ObfuscationIgnore
    private ImmutableMap<String, String> fmlBrandingProperties;
    @ObfuscationIgnore
    private File forcedModFile;
    @ObfuscationIgnore
    private ModDiscoverer discoverer;
    @ObfuscationIgnore
    private ProgressManager$ProgressBar progressBar;
    public static Gson gson;
    private ListMultimap<String, ArtifactVersion> injectedBefore = ArrayListMultimap.create();
    private ListMultimap<String, ArtifactVersion> injectedAfter = ArrayListMultimap.create();

    @ObfuscationIgnore
    public static Loader instance() {
        if (instance == null) {
            instance = new Loader();
        }
        return instance;
    }

    @ObfuscationIgnore
    public static void injectData(Object ... data) {
        major = (String)data[0];
        minor = (String)data[1];
        rev = (String)data[2];
        build = (String)data[3];
        mccversion = (String)data[4];
        mcpversion = (String)data[5];
        minecraftDir = (File)data[6];
        injectedContainers = (List)data[7];
    }

    @ObfuscationIgnore
    private Loader() {
        this.modClassLoader = new ModClassLoader(this.getClass().getClassLoader());
        if (mccversion == null) {
            mccversion = MC_VERSION;
        } else if (!mccversion.equals(MC_VERSION)) {
            FMLLog.severe("This version of FML is built for Minecraft %s, we have detected Minecraft %s in your minecraft jar file", mccversion, MC_VERSION);
            throw new LoaderException(String.format("This version of FML is built for Minecraft %s, we have detected Minecraft %s in your minecraft jar file", mccversion, MC_VERSION));
        }
        if (injectedContainers == null) {
            injectedContainers = Collections.emptyList();
        }
        this.minecraft = new MinecraftDummyContainer(MC_VERSION);
        this.mcp = new MCPDummyContainer(MetadataCollection.from(this.getClass().getResourceAsStream("/mcpmod.info"), "MCP").getMetadataForId("mcp", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ObfuscationIgnore
    private void sortModList() {
        FMLLog.finer("Verifying mod requirements are satisfied", new Object[0]);
        try {
            Object object;
            HashBiMap hashBiMap = HashBiMap.create();
            for (ModContainer object22 : Iterables.concat(this.getActiveModList(), ModAPIManager.INSTANCE.getAPIList())) {
                hashBiMap.put((Object)object22.getModId(), (Object)object22.getProcessedVersion());
            }
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
            for (ModContainer modContainer : this.getActiveModList()) {
                Object object2;
                Object object3;
                if (!modContainer.acceptableMinecraftVersionRange().containsVersion(this.minecraft.getProcessedVersion())) {
                    FMLLog.severe("The mod %s does not wish to run in Minecraft version %s. You will have to remove it to play.", modContainer.getModId(), this.getMCVersionString());
                    throw new WrongMinecraftVersionException(modContainer);
                }
                object = Maps.uniqueIndex(modContainer.getRequirements(), (Function)new ArtifactVersionNameFunction());
                HashSet hashSet = Sets.newHashSet();
                Object object4 = Sets.difference(object.keySet(), (Set)hashBiMap.keySet());
                if (!object4.isEmpty()) {
                    FMLLog.severe("The mod %s (%s) requires mods %s to be available", modContainer.getModId(), modContainer.getName(), object4);
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        hashSet.add((ArtifactVersion)object.get(object2));
                    }
                    throw new MissingModsException(hashSet);
                }
                arrayListMultimap.putAll((Object)modContainer.getModId(), object.keySet());
                object3 = ImmutableList.builder().addAll(modContainer.getDependants()).addAll(modContainer.getDependencies()).build();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    ArtifactVersion artifactVersion = (ArtifactVersion)object2.next();
                    if (!hashBiMap.containsKey((Object)artifactVersion.getLabel()) || artifactVersion.containsVersion((ArtifactVersion)hashBiMap.get((Object)artifactVersion.getLabel()))) continue;
                    hashSet.add(artifactVersion);
                }
                if (hashSet.isEmpty()) continue;
                FMLLog.severe("The mod %s (%s) requires mod versions %s to be available", modContainer.getModId(), modContainer.getName(), hashSet);
                throw new MissingModsException(hashSet);
            }
            FMLLog.finer("All mod requirements are satisfied", new Object[0]);
            this.reverseDependencies = (ListMultimap)Multimaps.invertFrom((Multimap)arrayListMultimap, (Multimap)ArrayListMultimap.create());
            ModSorter modSorter = new ModSorter(this.getActiveModList(), this.namedMods);
            try {
                FMLLog.finer("Sorting mods into an ordered list", new Object[0]);
                List<ModContainer> list = modSorter.sort();
                this.modController.getActiveModList().clear();
                this.modController.getActiveModList().addAll(list);
                this.mods.removeAll(list);
                list.addAll(this.mods);
                this.mods = list;
                FMLLog.finer("Mod sorting completed successfully", new Object[0]);
            }
            catch (ModSortingException modSortingException) {
                FMLLog.severe("A dependency cycle was detected in the input mod set so an ordering cannot be determined", new Object[0]);
                object = modSortingException.getExceptionData();
                FMLLog.severe("The first mod in the cycle is %s", ((ModSortingException$SortingExceptionData)object).getFirstBadNode());
                FMLLog.severe("The mod cycle involves", new Object[0]);
                for (Object object4 : ((ModSortingException$SortingExceptionData)object).getVisitedNodes()) {
                    FMLLog.severe("%s : before: %s, after: %s", object4.toString(), object4.getDependants(), object4.getDependencies());
                }
                FMLLog.log(Level.ERROR, modSortingException, "The full error", new Object[0]);
                throw modSortingException;
            }
        }
        catch (Throwable throwable) {
            FMLLog.fine("Mod sorting data", new Object[0]);
            int n = this.mods.size();
            for (ModContainer modContainer : this.getActiveModList()) {
                if (modContainer.isImmutable()) continue;
                FMLLog.fine("\t%s(%s:%s): %s (%s)", modContainer.getModId(), modContainer.getName(), modContainer.getVersion(), modContainer.getSource().getName(), modContainer.getSortingRules());
                --n;
            }
            if (n == this.mods.size()) {
                FMLLog.fine("No user mods found to sort", new Object[0]);
            }
            throw throwable;
        }
        FMLLog.fine("Mod sorting data", new Object[0]);
        int n = this.mods.size();
        for (ModContainer modContainer : this.getActiveModList()) {
            if (modContainer.isImmutable()) continue;
            FMLLog.fine("\t%s(%s:%s): %s (%s)", modContainer.getModId(), modContainer.getName(), modContainer.getVersion(), modContainer.getSource().getName(), modContainer.getSortingRules());
            --n;
        }
        if (n == this.mods.size()) {
            FMLLog.fine("No user mods found to sort", new Object[0]);
        }
    }

    @ObfuscationIgnore
    private ModDiscoverer identifyMods() {
        FMLLog.fine("Building injected Mod Containers %s", injectedContainers);
        this.mods.add(new InjectedModContainer(this.mcp, new File("stalzone.jar")));
        for (String object2 : injectedContainers) {
            ModContainer modContainer;
            try {
                modContainer = (ModContainer)Class.forName(object2, true, this.modClassLoader).newInstance();
            }
            catch (Exception exception) {
                FMLLog.log(Level.ERROR, exception, "A problem occured instantiating the injected mod container %s", object2);
                throw new LoaderException(exception);
            }
            this.mods.add(new InjectedModContainer(modContainer, modContainer.getSource()));
        }
        ModDiscoverer modDiscoverer = new ModDiscoverer();
        FMLLog.fine("Attempting to load mods contained in the minecraft jar file and associated classes", new Object[0]);
        modDiscoverer.findClasspathMods(this.modClassLoader);
        FMLLog.fine("Minecraft jar mods loaded successfully", new Object[0]);
        FMLLog.getLogger().log(Level.INFO, "Found {} mods from the command line. Injecting into mod discoverer", (Object)ModListHelper.additionalMods.size());
        FMLLog.info("Searching %s for mods", this.canonicalModsDir.getAbsolutePath());
        modDiscoverer.findModDirMods(this.canonicalModsDir, ModListHelper.additionalMods.values().toArray(new File[0]));
        File file = new File(this.canonicalModsDir, mccversion);
        if (file.isDirectory()) {
            FMLLog.info("Also searching %s for mods", file);
            modDiscoverer.findModDirMods(file);
        }
        this.mods.add(new FMLContainer());
        this.mods.add(new IIIiiIiiiIiiiIIiiIiiiIiiIiIiIiiIiiIiIIiIIiiiiiiIiiIIIiIiIIiIIIII());
        this.mods.addAll(modDiscoverer.identifyMods());
        this.identifyDuplicates(this.mods);
        this.namedMods = Maps.uniqueIndex(this.mods, (Function)new ModIdFunction());
        FMLLog.info("Forge Mod Loader has identified %d mod%s to load", this.mods.size(), this.mods.size() != 1 ? "s" : "");
        return modDiscoverer;
    }

    @ObfuscationIgnore
    private void identifyDuplicates(List<ModContainer> mods) {
        ModContainer modContainer2;
        TreeMultimap treeMultimap = TreeMultimap.create((Comparator)new Loader$ModIdComparator(this), (Comparator)Ordering.arbitrary());
        for (ModContainer modContainer2 : mods) {
            if (modContainer2.getSource() == null) continue;
            treeMultimap.put((Object)modContainer2, (Object)modContainer2.getSource());
        }
        ImmutableMultiset immutableMultiset = Multisets.copyHighestCountFirst((Multiset)treeMultimap.keys());
        modContainer2 = LinkedHashMultimap.create();
        for (Multiset.Entry entry : immutableMultiset.entrySet()) {
            if (entry.getCount() <= 1) continue;
            FMLLog.severe("Found a duplicate mod %s at %s", ((ModContainer)entry.getElement()).getModId(), treeMultimap.get((Object)((ModContainer)entry.getElement())));
            modContainer2.putAll((ModContainer)entry.getElement(), treeMultimap.get((Object)((ModContainer)entry.getElement())));
        }
        if (!modContainer2.isEmpty()) {
            throw new DuplicateModsFoundException((SetMultimap<ModContainer, File>)modContainer2);
        }
    }

    @ObfuscationIgnore
    private void initializeLoader() {
        String string;
        String string2;
        File file = new File(minecraftDir, "mods");
        File file2 = new File(minecraftDir, "config");
        try {
            string2 = file.getCanonicalPath();
            string = file2.getCanonicalPath();
            this.canonicalConfigDir = file2.getCanonicalFile();
            this.canonicalModsDir = file.getCanonicalFile();
            try {
                FMLLog.info("[Loader] minecraftDir=%s", minecraftDir != null ? minecraftDir.getAbsolutePath() : "<null>");
                FMLLog.info("[Loader] modsDir=%s", string2);
                FMLLog.info("[Loader] configDir=%s", string);
            }
            catch (Throwable throwable) {}
        }
        catch (IOException iOException) {
            FMLLog.log(Level.ERROR, iOException, "Failed to resolve loader directories: mods : %s ; config %s", this.canonicalModsDir.getAbsolutePath(), file2.getAbsolutePath());
            throw new LoaderException(iOException);
        }
        if (!this.canonicalModsDir.exists()) {
            FMLLog.info("No mod directory found, creating one: %s", string2);
            boolean bl = this.canonicalModsDir.mkdir();
            if (!bl) {
                FMLLog.severe("Unable to create the mod directory %s", string2);
                throw new LoaderException(String.format("Unable to create the mod directory %s", string2));
            }
            FMLLog.info("Mod directory created successfully", new Object[0]);
        }
        if (!this.canonicalConfigDir.exists()) {
            FMLLog.fine("No config directory found, creating one: %s", string);
            boolean bl = this.canonicalConfigDir.mkdir();
            if (!bl) {
                FMLLog.severe("Unable to create the config directory %s", string);
                throw new LoaderException();
            }
            FMLLog.info("Config directory created successfully", new Object[0]);
        }
        if (!this.canonicalModsDir.isDirectory()) {
            FMLLog.severe("Attempting to load mods from %s, which is not a directory", string2);
            throw new LoaderException();
        }
        if (!file2.isDirectory()) {
            FMLLog.severe("Attempting to load configuration from %s, which is not a directory", string);
            throw new LoaderException();
        }
        this.readInjectedDependencies();
    }

    @ObfuscationIgnore
    public List<ModContainer> getModList() {
        return Loader.instance().mods != null ? ImmutableList.copyOf(Loader.instance().mods) : ImmutableList.of();
    }

    @ObfuscationIgnore
    public void loadMods() {
        this.progressBar = ProgressManager.push("Loading", 7);
        this.progressBar.step("Constructing Mods");
        this.initializeLoader();
        this.mods = Lists.newArrayList();
        this.namedMods = Maps.newHashMap();
        this.modController = new LoadController(this);
        this.modController.transition(LoaderState.LOADING, false);
        this.discoverer = this.identifyMods();
        ModAPIManager.INSTANCE.manageAPI(this.modClassLoader, this.discoverer);
        this.disableRequestedMods();
        this.modController.distributeStateMessage(FMLLoadEvent.class);
        this.sortModList();
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.modController.getActiveModList());
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.mods);
        this.mods = ImmutableList.copyOf(this.mods);
        for (File object : this.discoverer.getNonModLibs()) {
            if (!object.isFile()) continue;
            try {
                this.modClassLoader.addFile(object);
            }
            catch (MalformedURLException malformedURLException) {
                FMLLog.log(Level.ERROR, malformedURLException, "Encountered a weird problem with non-mod file injection : %s", object.getName());
            }
        }
        this.modController.transition(LoaderState.CONSTRUCTING, false);
        this.modController.distributeStateMessage(LoaderState.CONSTRUCTING, this.modClassLoader, this.discoverer.getASMTable(), this.reverseDependencies);
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(this.getActiveModList());
        Collections.sort(arrayList, new Loader$1(this));
        FMLLog.fine("Mod signature data", new Object[0]);
        FMLLog.fine(" \tValid Signatures:", new Object[0]);
        for (ModContainer modContainer : this.getActiveModList()) {
            if (modContainer.getSigningCertificate() == null) continue;
            FMLLog.fine("\t\t(%s) %s\t(%s\t%s)\t%s", CertificateHelper.getFingerprint(modContainer.getSigningCertificate()), modContainer.getModId(), modContainer.getName(), modContainer.getVersion(), modContainer.getSource().getName());
        }
        FMLLog.fine(" \tMissing Signatures:", new Object[0]);
        for (ModContainer modContainer : this.getActiveModList()) {
            if (modContainer.getSigningCertificate() != null) continue;
            FMLLog.fine("\t\t%s\t(%s\t%s)\t%s", modContainer.getModId(), modContainer.getName(), modContainer.getVersion(), modContainer.getSource().getName());
        }
        if (this.getActiveModList().isEmpty()) {
            FMLLog.fine("No user mod signature data found", new Object[0]);
        }
        this.progressBar.step("Initializing mods Phase 1");
        this.modController.transition(LoaderState.PREINITIALIZATION, false);
    }

    @ObfuscationIgnore
    public void preinitializeMods() {
        if (!this.modController.isInState(LoaderState.PREINITIALIZATION)) {
            FMLLog.warning("There were errors previously. Not beginning mod initialization phase", new Object[0]);
            return;
        }
        ObjectHolderRegistry.INSTANCE.findObjectHolders(this.discoverer.getASMTable());
        ItemStackHolderInjector.INSTANCE.findHolders(this.discoverer.getASMTable());
        this.modController.distributeStateMessage(LoaderState.PREINITIALIZATION, this.discoverer.getASMTable(), this.canonicalConfigDir);
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        ItemStackHolderInjector.INSTANCE.inject();
        this.modController.transition(LoaderState.INITIALIZATION, false);
        this.progressBar.step("Initializing Minecraft Engine");
    }

    @ObfuscationIgnore
    private void disableRequestedMods() {
        String string = System.getProperty("fml.modStates", "");
        FMLLog.finer("Received a system property request '%s'", string);
        Map map = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)";:")).omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)string);
        FMLLog.finer("System property request managing the state of %d mods", map.size());
        HashMap hashMap = Maps.newHashMap();
        this.forcedModFile = new File(this.canonicalConfigDir, "fmlModState.properties");
        Properties properties = new Properties();
        if (this.forcedModFile.exists() && this.forcedModFile.isFile()) {
            FMLLog.finer("Found a mod state file %s", this.forcedModFile.getName());
            try {
                properties.load(new FileReader(this.forcedModFile));
                FMLLog.finer("Loaded states for %d mods from file", properties.size());
            }
            catch (Exception exception) {
                FMLLog.log(Level.INFO, exception, "An error occurred reading the fmlModState.properties file", new Object[0]);
            }
        }
        hashMap.putAll(Maps.fromProperties((Properties)properties));
        hashMap.putAll(map);
        FMLLog.fine("After merging, found state information for %d mods", hashMap.size());
        Map map2 = Maps.transformValues((Map)hashMap, (Function)new Loader$2(this));
        for (Map.Entry entry : map2.entrySet()) {
            if (!this.namedMods.containsKey(entry.getKey())) continue;
            FMLLog.info("Setting mod %s to enabled state %b", entry.getKey(), entry.getValue());
            this.namedMods.get(entry.getKey()).setEnabledState((Boolean)entry.getValue());
        }
    }

    @ObfuscationIgnore
    public static boolean isModLoaded(String modname) {
        return Loader.instance().namedMods.containsKey(modname) && Loader.instance().modController.getModState(Loader.instance.namedMods.get(modname)) != LoaderState$ModState.DISABLED;
    }

    @ObfuscationIgnore
    public File getConfigDir() {
        return this.canonicalConfigDir;
    }

    @ObfuscationIgnore
    public String getCrashInformation() {
        if (this.modController == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = FMLCommonHandler.instance().getBrandings(false);
        Joiner.on((char)' ').skipNulls().appendTo(stringBuilder, list);
        if (this.modController != null) {
            this.modController.printModStates(stringBuilder);
        }
        return stringBuilder.toString();
    }

    @ObfuscationIgnore
    public String getFMLVersionString() {
        return "7.10.99.99";
    }

    @ObfuscationIgnore
    public ClassLoader getModClassLoader() {
        return this.modClassLoader;
    }

    @ObfuscationIgnore
    public void computeDependencies(String dependencyString, Set<ArtifactVersion> requirements, List<ArtifactVersion> dependencies, List<ArtifactVersion> dependants) {
        if (dependencyString == null || dependencyString.length() == 0) {
            return;
        }
        boolean bl = false;
        for (String string : DEPENDENCYSPLITTER.split((CharSequence)dependencyString)) {
            ArrayList arrayList = Lists.newArrayList((Iterable)DEPENDENCYPARTSPLITTER.split((CharSequence)string));
            if (arrayList.size() != 2) {
                bl = true;
                continue;
            }
            String string2 = (String)arrayList.get(0);
            String string3 = (String)arrayList.get(1);
            boolean bl2 = string3.startsWith("*");
            if (bl2 && string3.length() > 1) {
                bl = true;
                continue;
            }
            if ("required-before".equals(string2) || "required-after".equals(string2)) {
                if (!bl2) {
                    requirements.add(VersionParser.parseVersionReference(string3));
                } else {
                    bl = true;
                    continue;
                }
            }
            if (bl2 && string3.indexOf(64) > -1) {
                bl = true;
                continue;
            }
            if ("required-before".equals(string2) || "before".equals(string2)) {
                dependants.add(VersionParser.parseVersionReference(string3));
                continue;
            }
            if ("required-after".equals(string2) || "after".equals(string2)) {
                dependencies.add(VersionParser.parseVersionReference(string3));
                continue;
            }
            bl = true;
        }
        if (bl) {
            FMLLog.log(Level.WARN, "Unable to parse dependency string %s", dependencyString);
            throw new LoaderException(String.format("Unable to parse dependency string %s", dependencyString));
        }
    }

    @ObfuscationIgnore
    public Map<String, ModContainer> getIndexedModList() {
        return ImmutableMap.copyOf(this.namedMods);
    }

    @ObfuscationIgnore
    public void initializeMods() {
        this.progressBar.step("Initializing mods Phase 2");
        this.modController.distributeStateMessage(LoaderState.INITIALIZATION, new Object[0]);
        this.progressBar.step("Initializing mods Phase 3");
        this.modController.transition(LoaderState.POSTINITIALIZATION, false);
        this.modController.distributeStateMessage(FMLInterModComms$IMCEvent.class);
        ItemStackHolderInjector.INSTANCE.inject();
        this.modController.distributeStateMessage(LoaderState.POSTINITIALIZATION, new Object[0]);
        this.progressBar.step("Finishing up");
        this.modController.transition(LoaderState.AVAILABLE, false);
        this.modController.distributeStateMessage(LoaderState.AVAILABLE, new Object[0]);
        GameData.freezeData();
        GameData.dumpRegistry(minecraftDir);
        FMLLog.info("Forge Mod Loader has successfully loaded %d mod%s", this.mods.size(), this.mods.size() == 1 ? "" : "s");
        this.progressBar.step("Completing Minecraft initialization");
    }

    @ObfuscationIgnore
    public ICrashCallable getCallableCrashInformation() {
        return new Loader$3(this);
    }

    @ObfuscationIgnore
    public List<ModContainer> getActiveModList() {
        return this.modController != null ? this.modController.getActiveModList() : ImmutableList.of();
    }

    @ObfuscationIgnore
    public LoaderState$ModState getModState(ModContainer selectedMod) {
        return this.modController.getModState(selectedMod);
    }

    @ObfuscationIgnore
    public String getMCVersionString() {
        return "Minecraft " + mccversion;
    }

    @ObfuscationIgnore
    public boolean serverStarting(Object server) {
        try {
            this.modController.distributeStateMessage(LoaderState.SERVER_STARTING, server);
            this.modController.transition(LoaderState.SERVER_STARTING, false);
        }
        catch (Throwable throwable) {
            FMLLog.log(Level.ERROR, throwable, "A fatal exception occurred during the server starting event", new Object[0]);
            return false;
        }
        return true;
    }

    @ObfuscationIgnore
    public void serverStarted() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STARTED, false);
    }

    @ObfuscationIgnore
    public void serverStopping() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPING, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPING, false);
    }

    @ObfuscationIgnore
    public BiMap<ModContainer, Object> getModObjectList() {
        return this.modController.getModObjectList();
    }

    @ObfuscationIgnore
    public BiMap<Object, ModContainer> getReversedModObjectList() {
        return this.getModObjectList().inverse();
    }

    @ObfuscationIgnore
    public ModContainer activeModContainer() {
        return this.modController != null ? this.modController.activeContainer() : null;
    }

    @ObfuscationIgnore
    public boolean isInState(LoaderState state) {
        return this.modController.isInState(state);
    }

    @ObfuscationIgnore
    public MinecraftDummyContainer getMinecraftModContainer() {
        return this.minecraft;
    }

    @ObfuscationIgnore
    public boolean hasReachedState(LoaderState state) {
        return this.modController != null ? this.modController.hasReachedState(state) : false;
    }

    @ObfuscationIgnore
    public String getMCPVersionString() {
        return String.format("MCP v%s", mcpversion);
    }

    @ObfuscationIgnore
    public void serverStopped() {
        GameData.revertToFrozen();
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPED, true);
        this.modController.transition(LoaderState.AVAILABLE, true);
    }

    @ObfuscationIgnore
    public boolean serverAboutToStart(Object server) {
        try {
            this.modController.distributeStateMessage(LoaderState.SERVER_ABOUT_TO_START, server);
            this.modController.transition(LoaderState.SERVER_ABOUT_TO_START, false);
        }
        catch (Throwable throwable) {
            FMLLog.log(Level.ERROR, throwable, "A fatal exception occurred during the server about to start event", new Object[0]);
            return false;
        }
        return true;
    }

    @ObfuscationIgnore
    public Map<String, String> getFMLBrandingProperties() {
        if (this.fmlBrandingProperties == null) {
            Properties properties = new Properties();
            try {
                properties.load(this.getClass().getClassLoader().getResourceAsStream("fmlbranding.properties"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fmlBrandingProperties = Maps.fromProperties((Properties)properties);
        }
        return this.fmlBrandingProperties;
    }

    @ObfuscationIgnore
    public Map<String, String> getCustomModProperties(String modId) {
        return this.getIndexedModList().get(modId).getCustomModProperties();
    }

    @ObfuscationIgnore
    boolean checkRemoteModList(Map<String, String> modList, Side side) {
        Set<String> set = modList.keySet();
        Set<String> set2 = this.namedMods.keySet();
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet((Iterable)Sets.difference(set2, set));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LoaderState$ModState loaderState$ModState = this.modController.getModState(this.namedMods.get(string));
            if (loaderState$ModState != LoaderState$ModState.DISABLED) continue;
            iterator.remove();
        }
        FMLLog.info("Attempting connection with missing mods %s at %s", new Object[]{linkedHashSet, side});
        return true;
    }

    @ObfuscationIgnore
    public List<String> fireMissingMappingEvent(LinkedHashMap<String, Integer> missing, boolean isLocalWorld, GameData gameData, Map<String, Integer[]> remaps) {
        if (missing.isEmpty()) {
            return ImmutableList.of();
        }
        FMLLog.fine("There are %d mappings missing - attempting a mod remap", missing.size());
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (Map.Entry<String, Integer> object : missing.entrySet()) {
            int n = object.getValue();
            FMLMissingMappingsEvent$MissingMapping fMLMissingMappingsEvent$MissingMapping = new FMLMissingMappingsEvent$MissingMapping(object.getKey(), n);
            arrayListMultimap.put((Object)fMLMissingMappingsEvent$MissingMapping.name.substring(0, fMLMissingMappingsEvent$MissingMapping.name.indexOf(58)), (Object)fMLMissingMappingsEvent$MissingMapping);
        }
        FMLMissingMappingsEvent fMLMissingMappingsEvent = new FMLMissingMappingsEvent((ListMultimap<String, FMLMissingMappingsEvent$MissingMapping>)arrayListMultimap);
        this.modController.propogateStateMessage(fMLMissingMappingsEvent);
        if (isLocalWorld) {
            boolean bl = false;
            for (FMLMissingMappingsEvent$MissingMapping fMLMissingMappingsEvent$MissingMapping : arrayListMultimap.values()) {
                boolean bl2;
                if (fMLMissingMappingsEvent$MissingMapping.getAction() != FMLMissingMappingsEvent$Action.DEFAULT) continue;
                if (!bl2) {
                    FMLLog.severe("There are unidentified mappings in this world - we are going to attempt to process anyway", new Object[0]);
                    bl2 = true;
                }
                FMLLog.severe("Unidentified %s: %s, id %d", fMLMissingMappingsEvent$MissingMapping.type == GameRegistry$Type.BLOCK ? "block" : "item", fMLMissingMappingsEvent$MissingMapping.name, fMLMissingMappingsEvent$MissingMapping.id);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (FMLMissingMappingsEvent$MissingMapping fMLMissingMappingsEvent$MissingMapping : arrayListMultimap.values()) {
                if (fMLMissingMappingsEvent$MissingMapping.getAction() != FMLMissingMappingsEvent$Action.DEFAULT) continue;
                arrayList.add(fMLMissingMappingsEvent$MissingMapping.name);
            }
            if (!arrayList.isEmpty()) {
                return ImmutableList.copyOf(arrayList);
            }
        }
        return GameData.processIdRematches(arrayListMultimap.values(), isLocalWorld, gameData, remaps);
    }

    @ObfuscationIgnore
    public void fireRemapEvent(Map<String, Integer[]> remaps) {
        this.modController.propogateStateMessage(new FMLModIdMappingEvent(remaps));
    }

    @ObfuscationIgnore
    public void runtimeDisableMod(String modId) {
        Cloneable cloneable;
        ModContainer modContainer = this.namedMods.get(modId);
        ModContainer$Disableable modContainer$Disableable = modContainer.canBeDisabled();
        if (modContainer$Disableable == ModContainer$Disableable.NEVER) {
            FMLLog.info("Cannot disable mod %s - it is never allowed to be disabled", modId);
            return;
        }
        if (modContainer$Disableable == ModContainer$Disableable.DEPENDENCIES) {
            FMLLog.info("Cannot disable mod %s - there are dependent mods that require its presence", modId);
            return;
        }
        if (modContainer$Disableable == ModContainer$Disableable.YES) {
            FMLLog.info("Runtime disabling mod %s", modId);
            this.modController.disableMod(modContainer);
            cloneable = Lists.newArrayList(this.mods);
            cloneable.remove(modContainer);
            this.mods = ImmutableList.copyOf((Collection)((Object)cloneable));
        }
        try {
            cloneable = new Properties();
            ((Properties)cloneable).load(new FileReader(this.forcedModFile));
            ((Properties)cloneable).put(modId, "false");
            ((Properties)cloneable).store(new FileWriter(this.forcedModFile), null);
        }
        catch (Exception exception) {
            FMLLog.log(Level.INFO, exception, "An error occurred writing the fml mod states file, your disabled change won't persist", new Object[0]);
        }
    }

    @ObfuscationIgnore
    public void loadingComplete() {
        ProgressManager.pop(this.progressBar);
        this.progressBar = null;
    }

    @ObfuscationIgnore
    private void readInjectedDependencies() {
        File file = new File(this.getConfigDir(), "injectedDependencies.json");
        if (!file.exists()) {
            return;
        }
        JsonParser jsonParser = new JsonParser();
        try {
            JsonElement jsonElement = jsonParser.parse((Reader)new FileReader(file));
            for (JsonElement jsonElement2 : jsonElement.getAsJsonArray()) {
                JsonObject jsonObject = jsonElement2.getAsJsonObject();
                String string = jsonObject.get("modId").getAsString();
                JsonArray jsonArray = jsonObject.get("deps").getAsJsonArray();
                for (JsonElement jsonElement3 : jsonArray) {
                    JsonObject jsonObject2 = jsonElement3.getAsJsonObject();
                    String string2 = jsonObject2.get("type").getAsString();
                    if (string2.equals("before")) {
                        this.injectedBefore.put((Object)string, (Object)VersionParser.parseVersionReference(jsonObject2.get("target").getAsString()));
                        continue;
                    }
                    if (string2.equals("after")) {
                        this.injectedAfter.put((Object)string, (Object)VersionParser.parseVersionReference(jsonObject2.get("target").getAsString()));
                        continue;
                    }
                    FMLLog.getLogger().log(Level.ERROR, "Invalid dependency type {}", (Object)string2);
                    throw new RuntimeException("Unable to parse type");
                }
            }
        }
        catch (Exception exception) {
            FMLLog.getLogger().log(Level.ERROR, "Unable to parse {} - skipping", (Object)file);
            FMLLog.getLogger().throwing(Level.ERROR, (Throwable)exception);
            return;
        }
        FMLLog.getLogger().log(Level.DEBUG, "Loaded {} injected dependencies on modIds: {}", (Object)this.injectedBefore.size(), (Object)this.injectedBefore.keySet());
    }

    List<ArtifactVersion> getInjectedBefore(String modId) {
        return this.injectedBefore.get((Object)modId);
    }

    List<ArtifactVersion> getInjectedAfter(String modId) {
        return this.injectedAfter.get((Object)modId);
    }

    @ObfuscationIgnore
    public final LoaderState getLoaderState() {
        return this.modController != null ? this.modController.getState() : LoaderState.NOINIT;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

