/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModAPIManager$APIContainer;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.asm.transformers.ModAPITransformer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.common.functions.ModIdFunction;
import cpw.mods.fml.common.versioning.VersionParser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class ModAPIManager {
    public static final ModAPIManager INSTANCE = new ModAPIManager();
    private ModAPITransformer transformer;
    private ASMDataTable dataTable;
    private Map<String, ModAPIManager$APIContainer> apiContainers;

    @ObfuscationIgnore
    public void registerDataTableAndParseAPI(ASMDataTable dataTable) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.dataTable = dataTable;
        Set<ASMDataTable$ASMData> set = dataTable.getAll("cpw.mods.fml.common.API");
        this.apiContainers = Maps.newHashMap();
        for (ASMDataTable$ASMData object7 : set) {
            object5 = object7.getAnnotationInfo();
            String string = object7.getClassName().substring(0, object7.getClassName().indexOf(".package-info"));
            object4 = (String)object5.get("provides");
            object3 = (String)object5.get("owner");
            object2 = (String)object5.get("apiVersion");
            object = this.apiContainers.get(object4);
            if (object == null) {
                object = new ModAPIManager$APIContainer((String)object4, (String)object2, object7.getCandidate().getModContainer(), VersionParser.parseVersionReference((String)object3));
                this.apiContainers.put((String)object4, (ModAPIManager$APIContainer)object);
            } else {
                ((ModAPIManager$APIContainer)object).validate((String)object4, (String)object3, (String)object2);
            }
            ((ModAPIManager$APIContainer)object).addOwnedPackage(string);
            for (ModContainer modContainer : object7.getCandidate().getContainedMods()) {
                String string2 = modContainer.getModId();
                if (((ModAPIManager$APIContainer)object).currentReferents.contains(string2)) continue;
                FMLLog.fine("Found API %s (owned by %s providing %s) embedded in %s", string, object3, object4, string2);
                if (string2.equals(object3)) continue;
                ((ModAPIManager$APIContainer)object).addAPIReference(string2);
            }
        }
        for (ModAPIManager$APIContainer modAPIManager$APIContainer : this.apiContainers.values()) {
            for (String string : modAPIManager$APIContainer.packages) {
                object4 = dataTable.getCandidatesFor(string);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (ModCandidate)object3.next();
                    object = Lists.transform(((ModCandidate)object2).getContainedMods(), (Function)new ModIdFunction());
                    if (object.contains(modAPIManager$APIContainer.ownerMod.getLabel()) || modAPIManager$APIContainer.currentReferents.containsAll((Collection<?>)object)) continue;
                    FMLLog.info("Found mod(s) %s containing declared API package %s (owned by %s) without associated API reference", object, string, modAPIManager$APIContainer.ownerMod);
                    modAPIManager$APIContainer.addAPIReferences((List<String>)object);
                }
            }
            if (this.apiContainers.containsKey(modAPIManager$APIContainer.ownerMod.getLabel())) {
                ModAPIManager$APIContainer modAPIManager$APIContainer2;
                object5 = modAPIManager$APIContainer.ownerMod;
                do {
                    if ((modAPIManager$APIContainer2 = this.apiContainers.get(object5.getLabel())) == modAPIManager$APIContainer) {
                        FMLLog.finer("APIContainer %s is it's own parent. skipping", object5);
                        modAPIManager$APIContainer.markSelfReferenced();
                        break;
                    }
                    FMLLog.finer("Removing upstream parent %s from %s", modAPIManager$APIContainer2.ownerMod.getLabel(), modAPIManager$APIContainer);
                    modAPIManager$APIContainer.currentReferents.remove(modAPIManager$APIContainer2.ownerMod.getLabel());
                    modAPIManager$APIContainer.referredMods.remove(modAPIManager$APIContainer2.ownerMod);
                } while (this.apiContainers.containsKey((object5 = modAPIManager$APIContainer2.ownerMod).getLabel()));
            }
            FMLLog.fine("Creating API container dummy for API %s: owner: %s, dependents: %s", modAPIManager$APIContainer.providedAPI, modAPIManager$APIContainer.ownerMod, modAPIManager$APIContainer.referredMods);
        }
    }

    @ObfuscationIgnore
    public void manageAPI(ModClassLoader modClassLoader, ModDiscoverer discoverer) {
        this.registerDataTableAndParseAPI(discoverer.getASMTable());
        this.transformer = modClassLoader.addModAPITransformer(this.dataTable);
    }

    @ObfuscationIgnore
    public void injectAPIModContainers(List<ModContainer> mods, Map<String, ModContainer> nameLookup) {
        mods.addAll(this.apiContainers.values());
        nameLookup.putAll(this.apiContainers);
    }

    @ObfuscationIgnore
    public void cleanupAPIContainers(List<ModContainer> mods) {
        mods.removeAll(this.apiContainers.values());
    }

    @ObfuscationIgnore
    public boolean hasAPI(String modId) {
        return this.apiContainers.containsKey(modId);
    }

    @ObfuscationIgnore
    public Iterable<? extends ModContainer> getAPIList() {
        return this.apiContainers.values();
    }
}

