/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.asm.transformers.ModAPITransformer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class ModClassLoader
extends URLClassLoader {
    private static final List<String> STANDARD_LIBRARIES = ImmutableList.of((Object)"jinput.jar", (Object)"lwjgl.jar", (Object)"lwjgl_util.jar", (Object)"rt.jar");
    private LaunchClassLoader mainClassLoader;

    public ModClassLoader(ClassLoader parent) {
        super(new URL[0], (ClassLoader)null);
        if (parent instanceof LaunchClassLoader) {
            this.mainClassLoader = (LaunchClassLoader)parent;
        } else if (Launch.classLoader != null) {
            this.mainClassLoader = Launch.classLoader;
        } else {
            URL[] uRLArray;
            if (parent instanceof URLClassLoader) {
                uRLArray = ((URLClassLoader)parent).getURLs();
            } else {
                String string = System.getProperty("java.class.path", "");
                String string2 = System.getProperty("path.separator");
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
                ArrayList<URL> arrayList = new ArrayList<URL>();
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        File file = new File(stringTokenizer.nextToken());
                        arrayList.add(file.toURI().toURL());
                    }
                    catch (Throwable throwable) {}
                }
                uRLArray = arrayList.toArray(new URL[0]);
            }
            this.mainClassLoader = new LaunchClassLoader(uRLArray);
            Thread.currentThread().setContextClassLoader(this.mainClassLoader);
        }
    }

    public void addFile(File modFile) {
        URL uRL = modFile.toURI().toURL();
        this.mainClassLoader.addURL(uRL);
    }

    @Override
    public Class<?> loadClass(String name) {
        return this.mainClassLoader.loadClass(name);
    }

    public File[] getParentSources() {
        List<URL> list = this.mainClassLoader.getSources();
        File[] fileArray = new File[list.size()];
        try {
            for (int i = 0; i < list.size(); ++i) {
                fileArray[i] = new File(list.get(i).toURI());
            }
            return fileArray;
        }
        catch (URISyntaxException uRISyntaxException) {
            FMLLog.log(Level.ERROR, uRISyntaxException, "Unable to process our input to locate the minecraft code", new Object[0]);
            throw new LoaderException(uRISyntaxException);
        }
    }

    public List<String> getDefaultLibraries() {
        return STANDARD_LIBRARIES;
    }

    public void clearNegativeCacheFor(Set<String> classList) {
        this.mainClassLoader.clearNegativeEntries(classList);
    }

    public ModAPITransformer addModAPITransformer(ASMDataTable dataTable) {
        this.mainClassLoader.registerTransformer("cpw.mods.fml.common.asm.transformers.ModAPITransformer");
        return null;
    }
}

