/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import cpw.mods.fml.common.discovery.asm.ModAnnotation;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.regex.Pattern;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class ModContainerFactory {
    public static Map<String, Constructor<? extends ModContainer>> modTypes = Maps.newHashMap();
    private static Pattern modClass = Pattern.compile(".*(\\.|)(mod\\_[^\\s$]+)$");
    private static ModContainerFactory INSTANCE = new ModContainerFactory();

    private ModContainerFactory() {
        this.registerContainerType(Mod.class.getName(), FMLModContainer.class);
    }

    public static ModContainerFactory instance() {
        return INSTANCE;
    }

    public void registerContainerType(String annotationClassName, Class<? extends ModContainer> container) {
        try {
            Constructor<? extends ModContainer> constructor = container.getConstructor(String.class, ModCandidate.class, Map.class);
            modTypes.put(ModContainerFactory.normalizeAnnotationName(annotationClassName), constructor);
        }
        catch (Exception exception) {
            FMLLog.log(Level.ERROR, exception, "Critical error : cannot register mod container type %s, it has an invalid constructor", annotationClassName);
            Throwables.propagate((Throwable)exception);
        }
    }

    public ModContainer build(ASMModParser modParser, File modSource, ModCandidate container) {
        String string = modParser.getASMTypeName();
        if (modParser.isBaseMod(container.getRememberedBaseMods()) && modClass.matcher(string).find()) {
            FMLLog.severe("Found a BaseMod type mod %s", string);
            FMLLog.severe("This will not be loaded and will be ignored. ModLoader mechanisms are no longer available.", new Object[0]);
        } else if (modClass.matcher(string).find()) {
            FMLLog.fine("Identified a class %s following modloader naming convention but not directly a BaseMod or currently seen subclass", string);
            container.rememberModCandidateType(modParser);
        } else if (modParser.isBaseMod(container.getRememberedBaseMods())) {
            FMLLog.fine("Found a basemod %s of non-standard naming format", string);
            container.rememberBaseModType(string);
        }
        for (ModAnnotation modAnnotation : modParser.getAnnotations()) {
            String string2 = ModContainerFactory.normalizeAnnotationName(modAnnotation.getAnnotationName());
            if (!modTypes.containsKey(string2)) continue;
            FMLLog.fine("Identified a mod of type %s (%s) - loading", string2, string);
            try {
                return modTypes.get(string2).newInstance(string, container, modAnnotation.getValues());
            }
            catch (Exception exception) {
                FMLLog.log(Level.ERROR, exception, "Unable to construct %s container", string2);
                return null;
            }
        }
        return null;
    }

    private static String normalizeAnnotationName(String raw) {
        if (raw == null) {
            return null;
        }
        String string = raw;
        if (string.startsWith("L") && string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        string = string.replace('/', '.');
        return string;
    }
}

