/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.StartupQuery$AbortedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.server.MinecraftServer;

@ObfuscationIgnore
public class StartupQuery {
    private static volatile StartupQuery pending;
    private static volatile boolean aborted;
    private String text;
    private AtomicBoolean result;
    private CountDownLatch signal = new CountDownLatch(1);
    private volatile boolean synchronous;

    public static boolean confirm(String text) {
        StartupQuery startupQuery = new StartupQuery(text, new AtomicBoolean());
        startupQuery.execute();
        return startupQuery.getResult();
    }

    public static void notify(String text) {
        StartupQuery startupQuery = new StartupQuery(text, null);
        startupQuery.execute();
    }

    public static void abort() {
        MinecraftServer minecraftServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (minecraftServer != null) {
            minecraftServer.iIIIIiIiIIiIIIIIiiIIiiiIIiIiiIIiIIiIIIiiiiiiiiiIIiiIIiiiiiiIIiiI();
        }
        aborted = true;
        throw new StartupQuery$AbortedException();
    }

    public static void reset() {
        pending = null;
        aborted = false;
    }

    public static boolean check() {
        if (pending != null) {
            try {
                FMLCommonHandler.instance().queryUser(pending);
            }
            catch (InterruptedException interruptedException) {
                FMLLog.warning("query interrupted", new Object[0]);
                StartupQuery.abort();
            }
            pending = null;
        }
        return !aborted;
    }

    private StartupQuery(String text, AtomicBoolean result) {
        this.text = text;
        this.result = result;
    }

    public Boolean getResult() {
        return this.result == null ? null : Boolean.valueOf(this.result.get());
    }

    public void setResult(boolean result) {
        this.result.set(result);
    }

    public String getText() {
        return this.text;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void finish() {
        this.signal.countDown();
    }

    private void execute() {
        String string = System.getProperty("fml.queryResult");
        if (this.result != null && string != null) {
            FMLLog.info("Using fml.queryResult %s to answer the following query:\n%s", string, this.text);
            if (string.equalsIgnoreCase("confirm")) {
                this.setResult(true);
                return;
            }
            if (string.equalsIgnoreCase("cancel")) {
                this.setResult(false);
                return;
            }
            FMLLog.warning("Invalid value for fml.queryResult: %s, expected confirm or cancel", string);
        }
        this.synchronous = false;
        pending = this;
        if (FMLCommonHandler.instance().getSide().isServer() || FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.synchronous = true;
            StartupQuery.check();
        }
        try {
            this.signal.await();
            StartupQuery.reset();
        }
        catch (InterruptedException interruptedException) {
            FMLLog.warning("query interrupted", new Object[0]);
            StartupQuery.abort();
        }
    }

    static {
        aborted = false;
    }
}

