/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import java.io.PrintStream;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Logger;

@ObfuscationIgnore
public class TracingPrintStream
extends PrintStream {
    private Logger logger;
    private int BASE_DEPTH = 3;

    public TracingPrintStream(Logger logger, PrintStream original) {
        super(original);
        this.logger = logger;
    }

    @Override
    public void println(Object o) {
        this.logger.info(this.getPrefix() + String.valueOf(o));
    }

    @Override
    public void println(String s) {
        this.logger.info(this.getPrefix() + s);
    }

    private String getPrefix() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[this.BASE_DEPTH];
        if (stackTraceElement.getClassName().startsWith("kotlin.io.")) {
            stackTraceElement = stackTraceElementArray[this.BASE_DEPTH + 2];
        }
        return "[" + stackTraceElement.getClassName() + ":" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + "]: ";
    }
}

