/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.io.Files;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class ZipperUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ObfuscationIgnore
    public static void zip(File directory, File zipfile) {
        URI uRI = directory.toURI();
        LinkedList<File> linkedList = new LinkedList<File>();
        linkedList.push(directory);
        FileOutputStream fileOutputStream = new FileOutputStream(zipfile);
        try (Closeable closeable = null;){
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            closeable = zipOutputStream;
            while (!linkedList.isEmpty()) {
                directory = (File)linkedList.pop();
                for (File file : directory.listFiles()) {
                    Object object = uRI.relativize(file.toURI()).getPath();
                    if (file.isDirectory()) {
                        linkedList.push(file);
                        object = ((String)object).endsWith("/") ? object : (String)object + "/";
                        zipOutputStream.putNextEntry(new ZipEntry((String)object));
                        continue;
                    }
                    zipOutputStream.putNextEntry(new ZipEntry((String)object));
                    Files.copy((File)file, (OutputStream)zipOutputStream);
                    zipOutputStream.closeEntry();
                }
            }
        }
    }

    public static void backupWorld() {
        String string = FMLCommonHandler.instance().getMinecraftServerInstance().iiiIIiiIIiiiIIIIiiIIIiIIiiiIiiiIIIiIiiIIiIIIiIiiiiIiiIiiIIiIiIii();
        ZipperUtil.backupWorld(string);
    }

    @Deprecated
    public static void backupWorld(String dirName, String saveName) {
        ZipperUtil.backupWorld(dirName);
    }

    public static void backupWorld(String dirName) {
        File file = FMLCommonHandler.instance().getSavesDirectory();
        File file2 = new File(file, String.format("%s-%2$tY%2$tm%2$td-%2$tH%2$tM%2$tS.zip", dirName, System.currentTimeMillis()));
        try {
            ZipperUtil.zip(new File(file, dirName), file2);
        }
        catch (IOException iOException) {
            FMLLog.log(Level.WARN, iOException, "World backup failed.", new Object[0]);
            throw iOException;
        }
        FMLLog.info("World backup created at %s.", file2.getCanonicalPath());
    }
}

