/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.common.patcher.ClassPatchManager;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.Side;
import fgm.iiIiIiIiiIIiiiiIiIiiiiiiiiIiiiIIIIIIIiiiIiIIiIIIiIIIiiiIiiIiiiII;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class FMLSanityChecker
implements IFMLCallHook {
    private static final String FMLFINGERPRINT = "51:0A:FB:4C:AF:A4:A0:F2:F5:CF:C5:0E:B4:CC:3C:30:24:4A:E3:8E".toLowerCase().replace(":", "");
    private static final String FORGEFINGERPRINT = "E3:C3:D5:0C:7C:98:6D:F7:4C:64:5C:0A:C5:46:39:74:1C:90:A5:57".toLowerCase().replace(":", "");
    private static final String MCFINGERPRINT = "CD:99:95:96:56:F7:53:DC:28:D8:63:B4:67:69:F7:F8:FB:AE:FC:FC".toLowerCase().replace(":", "");
    private LaunchClassLoader cl;
    private boolean liveEnv;
    public static File fmlLocation = new File(iiIiIiIiiIIiiiiIiIiiiiiiiiIiiiIIIIIIIiiiIiIIiIIIiIIIiiiIiiIiiiII.IiIiIIiIiiIiiIiiIiiIIiiIiiiIiIIIiiiiIiIiIIIiiiiiIiiiIIiiIiiIIIII().iiiIIIiIiiIiIIiIIiIiiIiIIiIiIiIIIiIIIiiIiIIiiiIIIIiiIIIiiiIiiIiI, "FMLSanityChecker");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public Void call() {
        var1_1 = this.getClass().getProtectionDomain().getCodeSource();
        var2_2 = false;
        var3_3 = false;
        if (var1_1.getLocation().getProtocol().equals("jar")) {
            var3_3 = true;
            var4_4 = var1_1.getCertificates();
            if (var4_4 != null) {
                for (Object var8_16 : var4_4) {
                    var9_17 = CertificateHelper.getFingerprint((Certificate)var8_16);
                    if (var9_17.equals(FMLSanityChecker.FMLFINGERPRINT)) {
                        FMLRelaunchLog.info("Found valid fingerprint for FML. Certificate fingerprint %s", new Object[]{var9_17});
                        var2_2 = true;
                        continue;
                    }
                    if (var9_17.equals(FMLSanityChecker.FORGEFINGERPRINT)) {
                        FMLRelaunchLog.info("Found valid fingerprint for Minecraft Forge. Certificate fingerprint %s", new Object[]{var9_17});
                        var2_2 = true;
                        continue;
                    }
                    FMLRelaunchLog.severe("Found invalid fingerprint for FML: %s", new Object[]{var9_17});
                }
            }
        } else {
            var2_2 = true;
        }
        var4_5 = FMLLaunchHandler.side() == Side.SERVER || this.liveEnv == false;
        var5_7 = 0;
        try {
            var6_9 = Class.forName("fgm.IIIIIIIiIIIIiiIiIIiiIiIiIiiIiIIIIiiiiIiiiiIIIiIiIiiIIiiiIiiiIIiI", false, this.cl);
            var1_1 = var6_9.getProtectionDomain().getCodeSource();
        }
        catch (Exception var6_10) {
            var4_5 = true;
        }
        var6_9 = null;
        if (var3_3 && !var4_5 && var1_1.getLocation().getProtocol().equals("jar")) {
            try {
                var7_12 = var1_1.getLocation().getPath().substring(5);
                var7_12 = var7_12.substring(0, var7_12.lastIndexOf(33));
                var7_12 = URLDecoder.decode(var7_12, Charsets.UTF_8.name());
                var6_9 = new JarFile(var7_12, true);
                var6_9.getManifest();
                var8_16 = var6_9.getJarEntry("net/minecraft/client/ClientBrandRetriever.class");
                ByteStreams.toByteArray((InputStream)var6_9.getInputStream((ZipEntry)var8_16));
                var9_17 = var8_16.getCertificates();
                v0 = var5_7 = var9_17 != null ? var9_17.length : 0;
                if (var9_17 == null) ** GOTO lbl63
                for (Certificate var13_21 : var9_17) {
                    var14_22 = CertificateHelper.getFingerprint(var13_21);
                    if (!var14_22.equals(FMLSanityChecker.MCFINGERPRINT)) continue;
                    FMLRelaunchLog.info("Found valid fingerprint for Minecraft. Certificate fingerprint %s", new Object[]{var14_22});
                    var4_5 = true;
                }
            }
            catch (Throwable var7_14) {
                FMLRelaunchLog.log(Level.ERROR, var7_14, "A critical error occurred trying to read the minecraft jar file", new Object[0]);
            }
            finally {
                if (var6_9 != null) {
                    try {
                        var6_9.close();
                    }
                    catch (IOException var7_13) {}
                }
            }
        } else {
            var4_5 = true;
        }
lbl63:
        // 4 sources

        if (!var4_5) {
            FMLRelaunchLog.severe("The minecraft jar %s appears to be corrupt! There has been CRITICAL TAMPERING WITH MINECRAFT, it is highly unlikely minecraft will work! STOP NOW, get a clean copy and try again!", new Object[]{var1_1.getLocation().getFile()});
            if (!Boolean.parseBoolean(System.getProperty("fml.ignoreInvalidMinecraftCertificates", "false"))) {
                FMLRelaunchLog.severe("For your safety, FML will not launch minecraft. You will need to fetch a clean version of the minecraft jar file", new Object[0]);
                FMLRelaunchLog.severe("Technical information: The class net.minecraft.client.ClientBrandRetriever should have been associated with the minecraft jar file, and should have returned us a valid, intact minecraft jar location. This did not work. Either you have modified the minecraft jar file (if so run the forge installer again), or you are using a base editing jar that is changing this class (and likely others too). If you REALLY want to run minecraft in this configuration, add the flag -Dfml.ignoreInvalidMinecraftCertificates=true to the 'JVM settings' in your launcher profile.", new Object[0]);
                FMLCommonHandler.instance().exitJava(1, false);
            } else {
                FMLRelaunchLog.severe("FML has been ordered to ignore the invalid or missing minecraft certificate. This is very likely to cause a problem!", new Object[0]);
                FMLRelaunchLog.severe("Technical information: ClientBrandRetriever was at %s, there were %d certificates for it", new Object[]{var1_1.getLocation(), var5_7});
            }
        }
        if (!var2_2) {
            FMLRelaunchLog.severe("FML appears to be missing any signature data. This is not a good thing", new Object[0]);
        }
        return null;
    }

    @Override
    public void injectData(Map<String, Object> data) {
        this.liveEnv = (Boolean)data.get("runtimeDeobfuscationEnabled");
        this.cl = (LaunchClassLoader)data.get("classLoader");
        File file = (File)data.get("mcLocation");
        fmlLocation = (File)data.get("coremodLocation");
        ClassPatchManager.INSTANCE.setup(FMLLaunchHandler.side());
        FMLDeobfuscatingRemapper.INSTANCE.setup(file, this.cl, (String)data.get("deobfuscationFileName"));
    }
}

