/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.DirectoryDiscoverer$ClassFilter;
import cpw.mods.fml.common.discovery.ITypeDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class DirectoryDiscoverer
implements ITypeDiscoverer {
    private ASMDataTable table;

    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        this.table = table;
        ArrayList arrayList = Lists.newArrayList();
        FMLLog.fine("Examining directory %s for potential mods", candidate.getModContainer().getName());
        this.exploreFileSystem("", candidate.getModContainer(), arrayList, candidate, null);
        for (ModContainer modContainer : arrayList) {
            table.addContainer(modContainer);
        }
        return arrayList;
    }

    public void exploreFileSystem(String path, File modDir, List<ModContainer> harvestedMods, ModCandidate candidate, MetadataCollection mc) {
        Object[] objectArray;
        if (path.length() == 0) {
            objectArray = new File(modDir, "mcmod.info");
            try {
                FileInputStream fileInputStream = new FileInputStream((File)objectArray);
                mc = MetadataCollection.from(fileInputStream, modDir.getName());
                fileInputStream.close();
                FMLLog.fine("Found an mcmod.info file in directory %s", modDir.getName());
            }
            catch (Exception exception) {
                mc = MetadataCollection.from(null, "");
                FMLLog.fine("No mcmod.info file found in directory %s", modDir.getName());
            }
        }
        objectArray = modDir.listFiles(new DirectoryDiscoverer$ClassFilter(this));
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            Object object2;
            if (((File)object).isDirectory()) {
                FMLLog.finer("Recursing into package %s", path + ((File)object).getName());
                this.exploreFileSystem(path + ((File)object).getName() + ".", (File)object, harvestedMods, candidate, mc);
                continue;
            }
            Matcher matcher = classFile.matcher(((File)object).getName());
            if (!matcher.matches()) continue;
            String string = ((File)object).getName().substring(0, ((File)object).getName().length() - 6);
            String string2 = path + string;
            ASMModParser aSMModParser = null;
            try {
                object2 = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = Class.forName(string2, false, (ClassLoader)object2);
                for (Annotation annotation : clazz.getAnnotations()) {
                    if (!annotation.annotationType().getName().equals("cpw.mods.fml.common.Mod")) continue;
                    FMLLog.finer("[Discoverer] Detected @Mod on class %s", string2);
                    aSMModParser = new ASMModParser(string2, clazz);
                    candidate.addClassEntry(path + ((File)object).getName());
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (aSMModParser == null) {
                try {
                    object2 = new FileInputStream((File)object);
                    aSMModParser = new ASMModParser((InputStream)object2);
                    ((FileInputStream)object2).close();
                    candidate.addClassEntry(path + ((File)object).getName());
                }
                catch (Exception exception) {
                    continue;
                }
            }
            aSMModParser.validate();
            aSMModParser.sendToTable(this.table, candidate);
            object2 = ModContainerFactory.instance().build(aSMModParser, candidate.getModContainer(), candidate);
            if (object2 == null) continue;
            FMLLog.finer("[Discoverer] Added ModContainer for %s from %s", object2.getModId(), candidate.getModContainer());
            harvestedMods.add((ModContainer)object2);
            object2.bindMetadata(mc);
        }
    }
}

