/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ITypeDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class JarDiscoverer
implements ITypeDiscoverer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        ArrayList arrayList = Lists.newArrayList();
        FMLLog.fine("Examining file %s for potential mods", candidate.getModContainer().getName());
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(candidate.getModContainer());
            if (jarFile.getManifest() != null && (jarFile.getManifest().getMainAttributes().get("FMLCorePlugin") != null || jarFile.getManifest().getMainAttributes().get("TweakClass") != null)) {
                FMLLog.finer("Ignoring coremod or tweak system %s", candidate.getModContainer());
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            ZipEntry zipEntry = jarFile.getEntry("mcmod.info");
            MetadataCollection metadataCollection = null;
            if (zipEntry != null) {
                FMLLog.finer("Located mcmod.info file in file %s", candidate.getModContainer().getName());
                metadataCollection = MetadataCollection.from(jarFile.getInputStream(zipEntry), candidate.getModContainer().getName());
            } else {
                FMLLog.fine("The mod container %s appears to be missing an mcmod.info file", candidate.getModContainer().getName());
                metadataCollection = MetadataCollection.from(null, "");
            }
            for (ZipEntry zipEntry2 : Collections.list(jarFile.entries())) {
                Object object;
                if (zipEntry2.getName() != null && zipEntry2.getName().startsWith("__MACOSX")) continue;
                ASMModParser aSMModParser = null;
                Matcher matcher = classFile.matcher(zipEntry2.getName());
                if (matcher.matches()) {
                    object = zipEntry2.getName().substring(0, zipEntry2.getName().length() - 6).replace('/', '.');
                    try {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        Class<?> clazz = classLoader.loadClass((String)object);
                        Class<Mod> clazz2 = Mod.class;
                        if (clazz.isAnnotationPresent(clazz2)) {
                            FMLLog.info("[JarDiscoverer] Detected @Mod on class %s", object);
                            aSMModParser = new ASMModParser((String)object, clazz);
                            candidate.addClassEntry(zipEntry2.getName());
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                    catch (Throwable throwable) {
                        FMLLog.fine("[JarDiscoverer] Failed to load candidate class %s: %s", object, String.valueOf(throwable));
                    }
                    if (aSMModParser == null) {
                        try {
                            aSMModParser = new ASMModParser(jarFile.getInputStream(zipEntry2));
                            candidate.addClassEntry(zipEntry2.getName());
                        }
                        catch (LoaderException loaderException) {
                            FMLLog.log(Level.ERROR, loaderException, "There was a problem reading the entry %s in the jar %s - probably a corrupt zip", zipEntry2.getName(), candidate.getModContainer().getPath());
                            jarFile.close();
                            throw loaderException;
                        }
                    }
                }
                if (aSMModParser == null) continue;
                aSMModParser.validate();
                aSMModParser.sendToTable(table, candidate);
                object = ModContainerFactory.instance().build(aSMModParser, candidate.getModContainer(), candidate);
                if (object == null) continue;
                FMLLog.info("[JarDiscoverer] Added ModContainer for %s from %s", object.getModId(), candidate.getModContainer());
                arrayList.add(object);
                object.bindMetadata(metadataCollection);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }
}

