/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery.asm;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser$AnnotationType;
import cpw.mods.fml.common.discovery.asm.ModAnnotation;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class ASMModParser {
    private String asmTypeName;
    private int classVersion;
    private String asmSuperTypeName;
    private LinkedList<ModAnnotation> annotations = Lists.newLinkedList();
    private String baseModProperties;

    public ASMModParser(InputStream stream) {
        this.asmTypeName = "UnknownClass";
        this.classVersion = 61;
        this.asmSuperTypeName = "java/lang/Object";
        if (stream != null) {
            stream.close();
        }
    }

    public ASMModParser(String className, Class<?> clazz) {
        this.asmTypeName = className.replace('.', '/');
        this.classVersion = 61;
        this.asmSuperTypeName = clazz.getSuperclass() != null ? clazz.getSuperclass().getName().replace('.', '/') : "java/lang/Object";
        try {
            Annotation annotation = null;
            Object[] objectArray = clazz.getAnnotations();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation annotation2 = objectArray[i];
                if (!annotation2.annotationType().getName().equals("cpw.mods.fml.common.Mod")) continue;
                annotation = annotation2;
                break;
            }
            if (annotation != null) {
                this.startClassAnnotation("cpw/mods/fml/common/Mod");
                for (Object object : objectArray = annotation.annotationType().getDeclaredMethods()) {
                    try {
                        Object object2 = ((Method)object).invoke((Object)annotation, new Object[0]);
                        Object object3 = ((Method)object).getDefaultValue();
                        if (object2 == null || object2 instanceof String && ((String)object2).isEmpty()) continue;
                        if (object2.getClass().isArray()) {
                            int n2;
                            int n3;
                            int n4 = Array.getLength(object2);
                            if (n4 == 0) continue;
                            boolean bl = false;
                            if (object3 != null && object3.getClass().isArray() && (n3 = Array.getLength(object3)) == n4) {
                                bl = true;
                                for (n2 = 0; n2 < n4; ++n2) {
                                    Object object4 = Array.get(object2, n2);
                                    Object object5 = Array.get(object3, n2);
                                    if (object4 != null ? object4.equals(object5) : object5 == null) continue;
                                    bl = false;
                                    break;
                                }
                            }
                            if (bl) continue;
                            ArrayList<Object> arrayList = new ArrayList<Object>(n4);
                            for (n2 = 0; n2 < n4; ++n2) {
                                arrayList.add(Array.get(object2, n2));
                            }
                            this.addAnnotationProperty(((Method)object).getName(), arrayList);
                            continue;
                        }
                        if (object3 != null && object2.equals(object3)) continue;
                        this.addAnnotationProperty(((Method)object).getName(), object2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.scanMethodAnnotations(clazz);
    }

    private void scanMethodAnnotations(Class<?> clazz) {
        try {
            Method[] methodArray;
            for (Method method : methodArray = clazz.getDeclaredMethods()) {
                Annotation[] annotationArray;
                for (Annotation annotation : annotationArray = method.getAnnotations()) {
                    String string;
                    String string2 = annotation.annotationType().getName();
                    if ("cpw.mods.fml.common.Mod$EventHandler".equals(string2)) {
                        string = this.getMethodDescriptor(method);
                        this.startMethodAnnotation(method.getName(), string, "cpw/mods/fml/common/Mod$EventHandler");
                        this.scanAnnotationProperties(annotation);
                        continue;
                    }
                    if ("cpw.mods.fml.common.Mod$InstanceFactory".equals(string2)) {
                        string = this.getMethodDescriptor(method);
                        this.startMethodAnnotation(method.getName(), string, "cpw/mods/fml/common/Mod$InstanceFactory");
                        this.scanAnnotationProperties(annotation);
                        continue;
                    }
                    if (!string2.startsWith("cpw.mods.fml.common.Mod$")) continue;
                    string = this.getMethodDescriptor(method);
                    String string3 = string2.replace('.', '/').replace('$', '$');
                    this.startMethodAnnotation(method.getName(), string, string3);
                    this.scanAnnotationProperties(annotation);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getMethodDescriptor(Method method) {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(this.getTypeDescriptor(clazz));
        }
        stringBuilder.append(")");
        stringBuilder.append(this.getTypeDescriptor(method.getReturnType()));
        return stringBuilder.toString();
    }

    private String getTypeDescriptor(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz.isArray()) {
            return "[" + this.getTypeDescriptor(clazz.getComponentType());
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    private void scanAnnotationProperties(Annotation ann) {
        try {
            Method[] methodArray;
            for (Method method : methodArray = ann.annotationType().getDeclaredMethods()) {
                try {
                    Object object = method.invoke((Object)ann, new Object[0]);
                    Object object2 = method.getDefaultValue();
                    if (object == null || object instanceof String && ((String)object).isEmpty()) continue;
                    if (object.getClass().isArray()) {
                        int n;
                        int n2;
                        int n3 = Array.getLength(object);
                        if (n3 == 0) continue;
                        boolean bl = false;
                        if (object2 != null && object2.getClass().isArray() && (n2 = Array.getLength(object2)) == n3) {
                            bl = true;
                            for (n = 0; n < n3; ++n) {
                                Object object3 = Array.get(object, n);
                                Object object4 = Array.get(object2, n);
                                if (object3 != null ? object3.equals(object4) : object4 == null) continue;
                                bl = false;
                                break;
                            }
                        }
                        if (bl) continue;
                        ArrayList<Object> arrayList = new ArrayList<Object>(n3);
                        for (n = 0; n < n3; ++n) {
                            arrayList.add(Array.get(object, n));
                        }
                        this.addAnnotationProperty(method.getName(), arrayList);
                        continue;
                    }
                    if (object2 != null && object.equals(object2)) continue;
                    this.addAnnotationProperty(method.getName(), object);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void beginNewTypeName(String typeQName, int classVersion, String superClassQName) {
        this.asmTypeName = typeQName;
        this.classVersion = classVersion;
        this.asmSuperTypeName = !Strings.isNullOrEmpty((String)superClassQName) ? superClassQName : "java/lang/Object";
    }

    public void startClassAnnotation(String annotationName) {
        ModAnnotation modAnnotation = new ModAnnotation(ASMModParser$AnnotationType.CLASS, annotationName, this.asmTypeName);
        this.annotations.addFirst(modAnnotation);
    }

    public void addAnnotationProperty(String key, Object value) {
        if (!this.annotations.isEmpty()) {
            this.annotations.getFirst().addProperty(key, value);
        }
    }

    public void startFieldAnnotation(String fieldName, String annotationName) {
        ModAnnotation modAnnotation = new ModAnnotation(ASMModParser$AnnotationType.FIELD, annotationName, fieldName);
        this.annotations.addFirst(modAnnotation);
    }

    public String toString() {
        return Objects.toStringHelper((String)"ASMAnnotationDiscoverer").add("className", (Object)this.asmTypeName).add("classVersion", this.classVersion).add("superName", (Object)this.asmSuperTypeName).add("annotations", this.annotations).add("isBaseMod", this.isBaseMod(Collections.emptyList())).add("baseModProperties", (Object)this.baseModProperties).toString();
    }

    public String getASMTypeName() {
        return this.asmTypeName != null ? this.asmTypeName.replace('/', '.') : null;
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    public String getASMSuperTypeName() {
        return this.asmSuperTypeName;
    }

    public LinkedList<ModAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void validate() {
    }

    public boolean isBaseMod(List<String> rememberedTypes) {
        return "BaseMod".equals(this.asmSuperTypeName) || "net/minecraft/src/BaseMod".equals(this.asmSuperTypeName) || rememberedTypes.contains(this.asmSuperTypeName);
    }

    public void setBaseModProperties(String foundProperties) {
        this.baseModProperties = foundProperties;
    }

    public String getBaseModProperties() {
        return this.baseModProperties;
    }

    public void sendToTable(ASMDataTable table, ModCandidate candidate) {
        for (ModAnnotation modAnnotation : this.annotations) {
            table.addASMData(candidate, modAnnotation.getAnnotationName(), this.asmTypeName, modAnnotation.member, modAnnotation.values);
        }
    }

    public void addAnnotationArray(String name) {
        if (!this.annotations.isEmpty()) {
            this.annotations.getFirst().addArray(name);
        }
    }

    public void addAnnotationEnumProperty(String name, String desc, String value) {
        if (!this.annotations.isEmpty()) {
            this.annotations.getFirst().addEnumProperty(name, desc, value);
        }
    }

    public void endArray() {
        if (!this.annotations.isEmpty()) {
            this.annotations.getFirst().endArray();
        }
    }

    public void addSubAnnotation(String name, String desc) {
        if (!this.annotations.isEmpty()) {
            ModAnnotation modAnnotation = this.annotations.getFirst();
            this.annotations.addFirst(modAnnotation.addChildAnnotation(name, desc));
        }
    }

    public void endSubAnnotation() {
        if (this.annotations.size() > 1) {
            ModAnnotation modAnnotation = this.annotations.removeFirst();
            this.annotations.addLast(modAnnotation);
        }
    }

    public void startMethodAnnotation(String methodName, String methodDescriptor, String annotationName) {
        ModAnnotation modAnnotation = new ModAnnotation(ASMModParser$AnnotationType.METHOD, annotationName, methodName + methodDescriptor);
        this.annotations.addFirst(modAnnotation);
    }
}

