/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery.asm;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.discovery.asm.ASMModParser$AnnotationType;
import cpw.mods.fml.common.discovery.asm.ModAnnotation$EnumHolder;
import java.util.ArrayList;
import java.util.Map;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class ModAnnotation {
    ASMModParser$AnnotationType type;
    String annotationName;
    String member;
    Map<String, Object> values = Maps.newHashMap();
    private ArrayList<Object> arrayList;
    private String arrayName;

    public ModAnnotation(ASMModParser$AnnotationType type, String annotationName, String member) {
        this.type = type;
        this.annotationName = annotationName;
        this.member = member;
    }

    public ModAnnotation(ASMModParser$AnnotationType type, String annotationName, ModAnnotation parent) {
        this.type = type;
        this.annotationName = annotationName;
    }

    public String toString() {
        return Objects.toStringHelper((String)"Annotation").add("type", (Object)this.type).add("name", (Object)this.annotationName).add("member", (Object)this.member).add("values", this.values).toString();
    }

    public ASMModParser$AnnotationType getType() {
        return this.type;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getMember() {
        return this.member;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void addArray(String name) {
        this.arrayList = Lists.newArrayList();
        this.arrayName = name;
    }

    public void addProperty(String key, Object value) {
        if (this.arrayList != null) {
            this.arrayList.add(value);
        } else {
            this.values.put(key, value);
        }
    }

    public void addEnumProperty(String key, String enumName, String value) {
        this.values.put(key, new ModAnnotation$EnumHolder(this, enumName, value));
    }

    public void endArray() {
        this.values.put(this.arrayName, this.arrayList);
        this.arrayList = null;
    }

    public ModAnnotation addChildAnnotation(String name, String desc) {
        ModAnnotation modAnnotation = new ModAnnotation(ASMModParser$AnnotationType.SUBTYPE, desc, this);
        if (this.arrayList != null) {
            this.arrayList.add(modAnnotation.getValues());
        }
        return modAnnotation;
    }
}

