/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.eventhandler;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.eventhandler.Event$Result;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.ListenerList;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class Event {
    @ObfuscationIgnore
    private boolean isCanceled = false;
    @ObfuscationIgnore
    private Event$Result result = Event$Result.DEFAULT;
    @ObfuscationIgnore
    private static final ConcurrentHashMap<Class<?>, ListenerList> LISTS = new ConcurrentHashMap();
    @ObfuscationIgnore
    private EventPriority phase = null;

    @ObfuscationIgnore
    public Event() {
        this.setup();
    }

    @ObfuscationIgnore
    public boolean isCancelable() {
        return false;
    }

    @ObfuscationIgnore
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @ObfuscationIgnore
    public void setCanceled(boolean cancel) {
        if (!this.isCancelable()) {
            throw new IllegalArgumentException("Attempted to cancel a uncancelable event");
        }
        this.isCanceled = cancel;
    }

    @ObfuscationIgnore
    public boolean hasResult() {
        return false;
    }

    @ObfuscationIgnore
    public Event$Result getResult() {
        return this.result;
    }

    @ObfuscationIgnore
    public void setResult(Event$Result value) {
        this.result = value;
    }

    @ObfuscationIgnore
    protected void setup() {
    }

    @ObfuscationIgnore
    public ListenerList getListenerList() {
        return Event.getOrCreateListenerList(this.getClass());
    }

    private static ListenerList getOrCreateListenerList(Class<?> cls) {
        ListenerList listenerList;
        Object object;
        Class<?> clazz;
        ArrayDeque arrayDeque = new ArrayDeque();
        for (clazz = cls; clazz != null && Event.class.isAssignableFrom(clazz) && !LISTS.containsKey(clazz); clazz = clazz.getSuperclass()) {
            arrayDeque.push(clazz);
        }
        Object object2 = null;
        if (clazz != null && Event.class.isAssignableFrom(clazz) && (object2 = LISTS.get(clazz)) == null) {
            object = new ListenerList(null);
            listenerList = LISTS.putIfAbsent(clazz, (ListenerList)object);
            Object object3 = object2 = listenerList != null ? listenerList : object;
        }
        while (!arrayDeque.isEmpty()) {
            object = (Class)arrayDeque.pop();
            ListenerList listenerList2 = LISTS.putIfAbsent((Class<?>)object, listenerList = new ListenerList((ListenerList)object2));
            object2 = listenerList2 != null ? listenerList2 : listenerList;
        }
        return LISTS.get(cls);
    }

    static ListenerList getListenerListForClass(Class<?> cls) {
        return Event.getOrCreateListenerList(cls);
    }

    @Nullable
    @ObfuscationIgnore
    public EventPriority getPhase() {
        return this.phase;
    }

    @ObfuscationIgnore
    public void setPhase(@Nonnull EventPriority value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"setPhase argument must not be null");
        int n = this.phase == null ? -1 : this.phase.ordinal();
        Preconditions.checkArgument((n < value.ordinal() ? 1 : 0) != 0, (String)"Attempted to set event phase to %s when already %s", (Object[])new Object[]{value, this.phase});
        this.phase = value;
    }
}

