/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.eventhandler;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.ListenerList;
import java.util.ArrayList;
import java.util.Collection;

class ListenerList$ListenerListInst {
    private boolean rebuild = true;
    private IEventListener[] listeners;
    private ArrayList<ArrayList<IEventListener>> priorities;
    private ListenerList$ListenerListInst parent;

    private ListenerList$ListenerListInst(ListenerList listenerList) {
        int n = EventPriority.values().length;
        this.priorities = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.priorities.add(new ArrayList());
        }
    }

    public void dispose() {
        for (ArrayList<IEventListener> arrayList : this.priorities) {
            arrayList.clear();
        }
        this.priorities.clear();
        this.parent = null;
        this.listeners = null;
    }

    private ListenerList$ListenerListInst(ListenerList listenerList, ListenerList$ListenerListInst parent) {
        this(listenerList);
        this.parent = parent;
    }

    public ArrayList<IEventListener> getListeners(EventPriority priority) {
        ArrayList<IEventListener> arrayList = new ArrayList<IEventListener>((Collection)this.priorities.get(priority.ordinal()));
        if (this.parent != null) {
            arrayList.addAll(this.parent.getListeners(priority));
        }
        return arrayList;
    }

    public IEventListener[] getListeners() {
        if (this.shouldRebuild()) {
            this.buildCache();
        }
        return this.listeners;
    }

    protected boolean shouldRebuild() {
        return this.rebuild || this.parent != null && this.parent.shouldRebuild();
    }

    private void buildCache() {
        if (this.parent != null && this.parent.shouldRebuild()) {
            this.parent.buildCache();
        }
        ArrayList<IEventListener> arrayList = new ArrayList<IEventListener>();
        for (EventPriority eventPriority : EventPriority.values()) {
            ArrayList<IEventListener> arrayList2 = this.getListeners(eventPriority);
            if (arrayList2.size() <= 0) continue;
            arrayList.add(eventPriority);
            arrayList.addAll(arrayList2);
        }
        this.listeners = arrayList.toArray(new IEventListener[arrayList.size()]);
        this.rebuild = false;
    }

    public void register(EventPriority priority, IEventListener listener) {
        this.priorities.get(priority.ordinal()).add(listener);
        this.rebuild = true;
    }

    public void unregister(IEventListener listener) {
        for (ArrayList<IEventListener> arrayList : this.priorities) {
            if (!arrayList.remove(listener)) continue;
            this.rebuild = true;
        }
    }
}

