/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import fgm.iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii;
import fgm.iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII;
import fgm.iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.commons.lang3.Validate;

@ObfuscationIgnore
public class ByteBufUtils {
    public static int varIntByteCount(int toCount) {
        return (toCount & 0xFFFFFF80) == 0 ? 1 : ((toCount & 0xFFFFC000) == 0 ? 2 : ((toCount & 0xFFE00000) == 0 ? 3 : ((toCount & 0xF0000000) == 0 ? 4 : 5)));
    }

    public static int readVarInt(ByteBuf buf, int maxSize) {
        byte by;
        Validate.isTrue((maxSize < 6 && maxSize > 0 ? 1 : 0) != 0, (String)"Varint length is between 1 and 5, not %d", (long)maxSize);
        int n = 0;
        int n2 = 0;
        do {
            by = buf.readByte();
            n |= (by & 0x7F) << n2++ * 7;
            if (n2 <= maxSize) continue;
            throw new RuntimeException("VarInt too big");
        } while ((by & 0x80) == 128);
        return n;
    }

    public static int readVarShort(ByteBuf buf) {
        int n = buf.readUnsignedShort();
        int n2 = 0;
        if ((n & 0x8000) != 0) {
            n &= Short.MAX_VALUE;
            n2 = buf.readUnsignedByte();
        }
        return (n2 & 0xFF) << 15 | n;
    }

    public static void writeVarShort(ByteBuf buf, int toWrite) {
        int n = toWrite & Short.MAX_VALUE;
        int n2 = (toWrite & 0x7F8000) >> 15;
        if (n2 != 0) {
            n |= 0x8000;
        }
        buf.writeShort(n);
        if (n2 != 0) {
            buf.writeByte(n2);
        }
    }

    public static void writeVarInt(ByteBuf to, int toWrite, int maxSize) {
        Validate.isTrue((ByteBufUtils.varIntByteCount(toWrite) <= maxSize ? 1 : 0) != 0, (String)"Integer is too big for %d bytes", (long)maxSize);
        while ((toWrite & 0xFFFFFF80) != 0) {
            to.writeByte(toWrite & 0x7F | 0x80);
            toWrite >>>= 7;
        }
        to.writeByte(toWrite);
    }

    public static String readUTF8String(ByteBuf from) {
        int n = ByteBufUtils.readVarInt(from, 2);
        String string = from.toString(from.readerIndex(), n, Charsets.UTF_8);
        from.readerIndex(from.readerIndex() + n);
        return string;
    }

    public static void writeUTF8String(ByteBuf to, String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Validate.isTrue((ByteBufUtils.varIntByteCount(byArray.length) < 3 ? 1 : 0) != 0, (String)"The string is too long for this encoding.", (Object[])new Object[0]);
        ByteBufUtils.writeVarInt(to, byArray.length, 2);
        to.writeBytes(byArray);
    }

    public static void writeItemStack(ByteBuf to, iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII stack) {
        iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI2 = new iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI(to);
        try {
            iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(stack);
        }
        catch (IOException iOException) {
            throw Throwables.propagate((Throwable)iOException);
        }
    }

    public static iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII readItemStack(ByteBuf from) {
        iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI2 = new iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI(from);
        try {
            return iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI2.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI();
        }
        catch (IOException iOException) {
            throw Throwables.propagate((Throwable)iOException);
        }
    }

    public static void writeTag(ByteBuf to, iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii tag) {
        iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI2 = new iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI(to);
        try {
            iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(tag);
        }
        catch (IOException iOException) {
            throw Throwables.propagate((Throwable)iOException);
        }
    }

    public static iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii readTag(ByteBuf from) {
        iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI2 = new iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI(from);
        try {
            return iiiIiIiiIIiiiiiIIIIiiiIIIIIiiIIIiIIiIiIIIIiiIIIiiiIIIIIiiiIIiIiI2.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI();
        }
        catch (IOException iOException) {
            throw Throwables.propagate((Throwable)iOException);
        }
    }

    public static String getContentDump(ByteBuf buffer) {
        int n;
        int n2;
        int n3 = buffer.readableBytes();
        StringBuffer stringBuffer = new StringBuffer(n3 * 3 + n3 + n3 / 4 + 30);
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 != 0 && n2 % 16 == 0) {
                stringBuffer.append('\t');
                for (n = n2 - 16; n < n2; ++n) {
                    if (buffer.getByte(n) < 32 || buffer.getByte(n) > 127) {
                        stringBuffer.append('.');
                        continue;
                    }
                    stringBuffer.append((char)buffer.getByte(n));
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append(Integer.toString((buffer.getByte(n2) & 0xF0) >> 4, 16) + Integer.toString((buffer.getByte(n2) & 0xF) >> 0, 16));
            stringBuffer.append(' ');
        }
        if (n2 != 0 && n2 % 16 != 0) {
            for (n = 0; n < (16 - n2 % 16) * 3; ++n) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append('\t');
        for (n = n2 > 0 && n2 % 16 == 0 ? n2 - 16 : n2 - n2 % 16; n2 >= 0 && n < n2; ++n) {
            if (buffer.getByte(n) < 32 || buffer.getByte(n) > 127) {
                stringBuffer.append('.');
                continue;
            }
            stringBuffer.append((char)buffer.getByte(n));
        }
        stringBuffer.append('\n');
        stringBuffer.append("Length: " + n3);
        return stringBuffer.toString();
    }
}

