/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.FMLOutboundHandler$OutboundTarget;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkHandshakeEstablished;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.NetworkModHolder;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import fgm.IIIiiiIIiIIIiIiIiIIIiIiIIIiIiiiIiIIIiIiiiIIIiIIIIiIIIiIIIIiiiiiI;
import fgm.IIiiIIiIiiIiIiiiIiIiIIiiIiiiiiIiIiiIiiiiIiIiiiIiIiIiIIIiIIIIiiII;
import fgm.IiIIiIIIIIIIiIIiiiiiiIiiiIiiiiiIIiIIIIiiIiIiIiiIiiIIiiIIIIIiIiii;
import fgm.iIIIiiIiIiiIIIiiIIIIiIiIiiIIIIIiIiiIIiiIIiiIiiIiIiiiiiiiIIiIiIII;
import fgm.iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public enum NetworkRegistry {
    INSTANCE;

    private EnumMap<Side, Map<String, FMLEmbeddedChannel>> channels = Maps.newEnumMap(Side.class);
    private Map<ModContainer, NetworkModHolder> registry = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> serverGuiHandlers = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> clientGuiHandlers = Maps.newHashMap();
    public static final AttributeKey<String> FML_CHANNEL;
    public static final AttributeKey<Side> CHANNEL_SOURCE;
    public static final AttributeKey<ModContainer> MOD_CONTAINER;
    public static final AttributeKey<IIiiIIiIiiIiIiiiIiIiIIiiIiiiiiIiIiiIiiiiIiIiiiIiIiIiIIIiIIIIiiII> NET_HANDLER;
    public static final byte FML_PROTOCOL = 2;

    private NetworkRegistry() {
        this.channels.put(Side.CLIENT, Maps.newConcurrentMap());
        this.channels.put(Side.SERVER, Maps.newConcurrentMap());
    }

    public EnumMap<Side, FMLEmbeddedChannel> newChannel(String name, ChannelHandler ... handlers) {
        if (this.channels.containsKey(name) || name.startsWith("MC|") || name.startsWith("\u0001") || name.startsWith("FML")) {
            throw new RuntimeException("That channel is already registered");
        }
        EnumMap enumMap = Maps.newEnumMap(Side.class);
        for (Side side : Side.values()) {
            FMLEmbeddedChannel fMLEmbeddedChannel = new FMLEmbeddedChannel(name, side, handlers);
            this.channels.get((Object)side).put(name, fMLEmbeddedChannel);
            enumMap.put(side, fMLEmbeddedChannel);
        }
        return enumMap;
    }

    public SimpleNetworkWrapper newSimpleChannel(String name) {
        return new SimpleNetworkWrapper(name);
    }

    public FMLEventChannel newEventDrivenChannel(String name) {
        return new FMLEventChannel(name);
    }

    public EnumMap<Side, FMLEmbeddedChannel> newChannel(ModContainer container, String name, ChannelHandler ... handlers) {
        if (this.channels.containsKey(name) || name.startsWith("MC|") || name.startsWith("\u0001") || name.startsWith("FML") && !"FML".equals(container.getModId())) {
            throw new RuntimeException("That channel is already registered");
        }
        EnumMap enumMap = Maps.newEnumMap(Side.class);
        for (Side side : Side.values()) {
            FMLEmbeddedChannel fMLEmbeddedChannel = new FMLEmbeddedChannel(container, name, side, handlers);
            this.channels.get((Object)side).put(name, fMLEmbeddedChannel);
            enumMap.put(side, fMLEmbeddedChannel);
        }
        return enumMap;
    }

    public FMLEmbeddedChannel getChannel(String name, Side source) {
        return this.channels.get((Object)source).get(name);
    }

    public void registerGuiHandler(Object mod, IGuiHandler handler) {
        ModContainer modContainer = FMLCommonHandler.instance().findContainerFor(mod);
        if (modContainer == null) {
            FMLLog.log(Level.ERROR, "Mod of type %s attempted to register a gui network handler during a construction phase", mod.getClass().getName());
            throw new RuntimeException("Invalid attempt to create a GUI during mod construction. Use an EventHandler instead");
        }
        this.serverGuiHandlers.put(modContainer, handler);
        this.clientGuiHandlers.put(modContainer, handler);
    }

    public iIIIiiIiIiiIIIiiIIIIiIiIiiIIIIIiIiiIIiiIIiiIiiIiIiiiiiiiIIiIiIII getRemoteGuiContainer(ModContainer mc, iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII player, int modGuiId, IiIIiIIIIIIIiIIiiiiiiIiiiIiiiiiIIiIIIIiiIiIiIiiIiiIIiiIIIIIiIiii world, int x, int y, int z) {
        IGuiHandler iGuiHandler = this.serverGuiHandlers.get(mc);
        if (iGuiHandler != null) {
            return (iIIIiiIiIiiIIIiiIIIIiIiIiiIIIIIiIiiIIiiIIiiIiiIiIiiiiiiiIIiIiIII)iGuiHandler.getServerGuiElement(modGuiId, player, world, x, y, z);
        }
        return null;
    }

    public Object getLocalGuiContainer(ModContainer mc, IIIiiiIIiIIIiIiIiIIIiIiIIIiIiiiIiIIIiIiiiIIIiIIIIiIIIiIIIIiiiiiI player, int modGuiId, IiIIiIIIIIIIiIIiiiiiiIiiiIiiiiiIIiIIIIiiIiIiIiiIiiIIiiIIIIIiIiii world, int x, int y, int z) {
        IGuiHandler iGuiHandler = this.clientGuiHandlers.get(mc);
        return iGuiHandler.getClientGuiElement(modGuiId, player, world, x, y, z);
    }

    public boolean hasChannel(String channelName, Side source) {
        return this.channels.get((Object)source).containsKey(channelName);
    }

    public void register(ModContainer fmlModContainer, Class<?> clazz, String remoteVersionRange, ASMDataTable asmHarvestedData) {
        NetworkModHolder networkModHolder = new NetworkModHolder(fmlModContainer, clazz, remoteVersionRange, asmHarvestedData);
        this.registry.put(fmlModContainer, networkModHolder);
        networkModHolder.testVanillaAcceptance();
    }

    public boolean isVanillaAccepted(Side from) {
        boolean bl = true;
        for (Map.Entry<ModContainer, NetworkModHolder> entry : this.registry.entrySet()) {
            bl &= entry.getValue().acceptsVanilla(from);
        }
        return bl;
    }

    public Map<ModContainer, NetworkModHolder> registry() {
        return ImmutableMap.copyOf(this.registry);
    }

    public Set<String> channelNamesFor(Side side) {
        return this.channels.get((Object)side).keySet();
    }

    public void fireNetworkHandshake(NetworkDispatcher networkDispatcher, Side origin) {
        NetworkHandshakeEstablished networkHandshakeEstablished = new NetworkHandshakeEstablished(networkDispatcher, networkDispatcher.getNetHandler(), origin);
        for (Map.Entry<String, FMLEmbeddedChannel> entry : this.channels.get((Object)origin).entrySet()) {
            entry.getValue().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.DISPATCHER);
            entry.getValue().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)networkDispatcher);
            entry.getValue().pipeline().fireUserEventTriggered((Object)networkHandshakeEstablished);
        }
    }

    static {
        FML_CHANNEL = new AttributeKey("fml:channelName");
        CHANNEL_SOURCE = new AttributeKey("fml:channelSource");
        MOD_CONTAINER = new AttributeKey("fml:modContainer");
        NET_HANDLER = new AttributeKey("fml:netHandler");
    }
}

