/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.handshake;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLNetworkEvent$ClientConnectedToServerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent$ClientDisconnectionFromServerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent$ServerConnectionFromClientEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent$ServerDisconnectionFromClientEvent;
import cpw.mods.fml.common.network.FMLNetworkException;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.ChannelRegistrationHandler;
import cpw.mods.fml.common.network.handshake.FMLHandshakeClientState;
import cpw.mods.fml.common.network.handshake.FMLHandshakeCodec;
import cpw.mods.fml.common.network.handshake.FMLHandshakeServerState;
import cpw.mods.fml.common.network.handshake.HandshakeInjector;
import cpw.mods.fml.common.network.handshake.HandshakeMessageHandler;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher$1;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher$ConnectionState;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher$ConnectionType;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher$VanillaTimeoutWaiter;
import cpw.mods.fml.common.network.internal.FMLMessage$CompleteHandshake;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import fgm.IIiiIIiIiiIiIiiiIiIiIIiiIiiiiiIiIiiIiiiiIiIiiiIiIiIiIIIiIIIIiiII;
import fgm.IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii;
import fgm.IiiiiIiiiIIiiiiiiIIiiiIiiIIiiIiiIIIiiIiiIIiIiiIIIiIiIIIiiiIIiIIi;
import fgm.iIIiiIiIiIiIIIIiIiIIIIiiiIIIiIIIiiiIiIIiiIIiiiiiIiiIIIiiIiIiiiII;
import fgm.iIiIIIIIiIiIiiIIiIIIiiIIiIIiIIIIiIIiIIIiIiIiIiiIiIiIIIIiIiiIIIii;
import fgm.iIiIiIiIiiiiIiIiIiiiiIIIIIIIIIIiIiIIIIiiIIIiiIiIiIIIiiIiIiiIIiii;
import fgm.iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii;
import fgm.iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII;
import fgm.iiIIIIIiiiIIiIIIIiIiiiIIIIIiIIiiiiiiIIiiiiIIIiIIiiIiiiiiIiIiIiii;
import fgm.iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII;
import fgm.iiIIiIiiIIiiIIIIiiIIiiIIiiiIIIiIiiiiiiiiIIiiiIiIIiIiIiiIiiiiiIII;
import fgm.iiIiiIiIIIiIiiIiIiIiiiIiIIiIiIiIIIIIIiiIIIIIIIIIiIiiiiiiIIIiIIiI;
import fgm.iiiiiIiiIIIiIiIiiiiIiIIIIiIiIiiIIiIiIiiiiIiiIiiIiiiIiIiiiIiIiiii;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.Locale;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class NetworkDispatcher
extends SimpleChannelInboundHandler<IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii>
implements ChannelOutboundHandler {
    public static final AttributeKey<NetworkDispatcher> FML_DISPATCHER = new AttributeKey("fml:dispatcher");
    public static final AttributeKey<Boolean> IS_LOCAL = new AttributeKey("fml:isLocal");
    public final iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII manager;
    private final iiiiiIiiIIIiIiIiiiiIiIIIIiIiIiiIIiIiIiiiiIiiIiiIiiiIiIiiiIiIiiii scm;
    private iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII player;
    private NetworkDispatcher$ConnectionState state;
    private NetworkDispatcher$ConnectionType connectionType;
    private final Side side;
    private final EmbeddedChannel handshakeChannel;
    private iiIiiIiIIIiIiiIiIiIiiiIiIIiIiIiIIIIIIiiIIIIIIIIIiIiiiiiiIIIiIIiI serverHandler;
    private IIiiIIiIiiIiIiiiIiIiIIiiIiiiiiIiIiiIiiiiIiIiiiIiIiIiIIIiIIIIiiII netHandler;
    private int overrideLoginDim;

    public static NetworkDispatcher get(iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII manager) {
        return (NetworkDispatcher)((Object)manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().attr(FML_DISPATCHER).get());
    }

    public static NetworkDispatcher allocAndSet(iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII manager) {
        NetworkDispatcher networkDispatcher = new NetworkDispatcher(manager);
        manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().attr(FML_DISPATCHER).getAndSet((Object)networkDispatcher);
        return networkDispatcher;
    }

    public static NetworkDispatcher allocAndSet(iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII manager, iiiiiIiiIIIiIiIiiiiIiIIIIiIiIiiIIiIiIiiiiIiiIiiIiiiIiIiiiIiIiiii scm) {
        NetworkDispatcher networkDispatcher = new NetworkDispatcher(manager, scm);
        manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().attr(FML_DISPATCHER).getAndSet((Object)networkDispatcher);
        return networkDispatcher;
    }

    public NetworkDispatcher(iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII manager) {
        super(IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii.class, false);
        this.manager = manager;
        this.scm = null;
        this.side = Side.CLIENT;
        this.handshakeChannel = new EmbeddedChannel(new ChannelHandler[]{new HandshakeInjector(this), new ChannelRegistrationHandler(), new FMLHandshakeCodec(), new HandshakeMessageHandler<FMLHandshakeClientState>(FMLHandshakeClientState.class)});
        this.handshakeChannel.attr(FML_DISPATCHER).set((Object)this);
        this.handshakeChannel.attr(NetworkRegistry.CHANNEL_SOURCE).set((Object)Side.SERVER);
        this.handshakeChannel.attr(NetworkRegistry.FML_CHANNEL).set((Object)"FML|HS");
        this.handshakeChannel.attr(IS_LOCAL).set((Object)manager.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI());
    }

    public NetworkDispatcher(iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII manager, iiiiiIiiIIIiIiIiiiiIiIIIIiIiIiiIIiIiIiiiiIiiIiiIiiiIiIiiiIiIiiii scm) {
        super(IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii.class, false);
        this.manager = manager;
        this.scm = scm;
        this.side = Side.SERVER;
        this.handshakeChannel = new EmbeddedChannel(new ChannelHandler[]{new HandshakeInjector(this), new ChannelRegistrationHandler(), new FMLHandshakeCodec(), new HandshakeMessageHandler<FMLHandshakeServerState>(FMLHandshakeServerState.class)});
        this.handshakeChannel.attr(FML_DISPATCHER).set((Object)this);
        this.handshakeChannel.attr(NetworkRegistry.CHANNEL_SOURCE).set((Object)Side.CLIENT);
        this.handshakeChannel.attr(NetworkRegistry.FML_CHANNEL).set((Object)"FML|HS");
        this.handshakeChannel.attr(IS_LOCAL).set((Object)manager.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI());
    }

    public void serverToClientHandshake(iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII player) {
        this.player = player;
        this.insertIntoChannel();
    }

    private void insertIntoChannel() {
        this.manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().config().setAutoRead(false);
        this.manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().pipeline().addBefore("packet_handler", "fml:packet_handler", (ChannelHandler)this);
    }

    public void clientToServerHandshake() {
        this.insertIntoChannel();
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.state = NetworkDispatcher$ConnectionState.OPENING;
        this.handshakeChannel.pipeline().fireUserEventTriggered((Object)this);
        this.manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().config().setAutoRead(true);
    }

    int serverInitiateHandshake() {
        this.state = NetworkDispatcher$ConnectionState.AWAITING_HANDSHAKE;
        this.manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().pipeline().addFirst("fml:vanilla_detector", (ChannelHandler)new NetworkDispatcher$VanillaTimeoutWaiter(this));
        this.serverHandler = new iiIiiIiIIIiIiiIiIiIiiiIiIIiIiIiIIIIIIiiIIIIIIIIIiIiiiiiiIIIiIIiI(this.scm.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI(), this.manager, this.player);
        this.netHandler = this.serverHandler;
        this.player.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii = null;
        this.manager.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iiIIIIIiiiIIiIIIIiIiiiIIIIIiIIiiiiiiIIiiiiIIIiIIiiIiiiiiIiIiIiii.PLAY);
        iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2 = this.scm.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI(this.player);
        if (iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2 != null) {
            return iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii2.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII("Dimension");
        }
        return 0;
    }

    void clientListenForServerHandshake() {
        this.manager.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iiIIIIIiiiIIiIIIIiIiiiIIIIIiIIiiiiiiIIiiiiIIIiIIiiIiiiiiIiIiIiii.PLAY);
        FMLCommonHandler.instance().waitForPlayClient();
        this.netHandler = FMLCommonHandler.instance().getClientPlayHandler();
        this.state = NetworkDispatcher$ConnectionState.AWAITING_HANDSHAKE;
    }

    private void completeClientSideConnection(NetworkDispatcher$ConnectionType type) {
        this.connectionType = type;
        FMLLog.info("[%s] Client side %s connection established", Thread.currentThread().getName(), this.connectionType.name().toLowerCase(Locale.ENGLISH));
        this.state = NetworkDispatcher$ConnectionState.CONNECTED;
        FMLCommonHandler.instance().bus().post(new FMLNetworkEvent$ClientConnectedToServerEvent(this.manager, this.connectionType.name()));
    }

    private void completeServerSideConnection(NetworkDispatcher$ConnectionType type) {
        this.connectionType = type;
        FMLLog.info("[%s] Server side %s connection established", Thread.currentThread().getName(), this.connectionType.name().toLowerCase(Locale.ENGLISH));
        this.state = NetworkDispatcher$ConnectionState.CONNECTED;
        FMLCommonHandler.instance().bus().post(new FMLNetworkEvent$ServerConnectionFromClientEvent(this.manager));
        this.scm.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(this.manager, this.player, this.serverHandler);
    }

    protected void channelRead0(ChannelHandlerContext ctx, IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii msg) {
        boolean bl = false;
        if (msg instanceof iIiIIIIIiIiIiiIIiIIIiiIIiIIiIIIIiIIiIIIiIiIiIiiIiIiIIIIiIiiIIIii) {
            bl = this.handleServerSideCustomPacket((iIiIIIIIiIiIiiIIiIIIiiIIiIIiIIIIiIIiIIIiIiIiIiiIiIiIIIIiIiiIIIii)msg, ctx);
        } else if (msg instanceof iIiIiIiIiiiiIiIiIiiiiIIIIIIIIIIiIiIIIIiiIIIiiIiIiIIIiiIiIiiIIiii) {
            bl = this.handleClientSideCustomPacket((iIiIiIiIiiiiIiIiIiiiiIIIIIIIIIIiIiIIIIiiIIIiiIiIiIIIiiIiIiiIIiii)msg, ctx);
        } else if (this.state != NetworkDispatcher$ConnectionState.CONNECTED && this.state != NetworkDispatcher$ConnectionState.HANDSHAKECOMPLETE) {
            bl = this.handleVanilla(msg);
        }
        if (!bl) {
            ctx.fireChannelRead((Object)msg);
        }
    }

    private boolean handleVanilla(IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii msg) {
        if (this.state == NetworkDispatcher$ConnectionState.AWAITING_HANDSHAKE && msg instanceof iIIiiIiIiIiIIIIiIiIIIIiiiIIIiIIIiiiIiIIiiIIiiiiiIiiIIIiiIiIiiiII) {
            this.handshakeChannel.pipeline().fireUserEventTriggered((Object)msg);
        } else {
            FMLLog.info("Unexpected packet during modded negotiation - assuming vanilla or keepalives : %s", msg.getClass().getName());
        }
        return false;
    }

    public IIiiIIiIiiIiIiiiIiIiIIiiIiiiiiIiIiiIiiiiIiIiiiIiIiIiIIIiIIIIiiII getNetHandler() {
        return this.netHandler;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof NetworkDispatcher$ConnectionType && this.side == Side.SERVER) {
            FMLLog.info("Timeout occurred, assuming a vanilla client", new Object[0]);
            this.kickVanilla();
        }
    }

    private void kickVanilla() {
        this.kickWithMessage("This is modded. No modded response received. Bye!");
    }

    private void kickWithMessage(String message) {
        iiIIiIiiIIiiIIIIiiIIiiIIiiiIIIiIiiiiiiiiIIiiiIiIIiIiIiiIiiiiiIII iiIIiIiiIIiiIIIIiiIIiiIIiiiIIIiIiiiiiiiiIIiiiIiIIiIiIiiIiiiiiIII2 = new iiIIiIiiIIiiIIIIiiIIiiIIiiiIIIiIiiiiiiiiIIiiiIiIIiIiIiiIiiiiiIII(message);
        if (this.side == Side.CLIENT) {
            this.manager.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iiIIiIiiIIiiIIIIiiIIiiIIiiiIIIiIiiiiiiiiIIiiiIiIIiIiIiiIiiiiiIII2);
        } else {
            this.manager.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(new IiiiiIiiiIIiiiiiiIIiiiIiiIIiiIiiIIIiiIiiIIiIiiIIIiIiIIIiiiIIiIIi(iiIIiIiiIIiiIIIIiiIIiiIIiiiIIIiIiiiiiiiiIIiiiIiIIiIiIiiIiiiiiIII2), new NetworkDispatcher$1(this, iiIIiIiiIIiiIIIIiiIIiiIIiiiIIIiIiiiiiiiiIIiiiIiIIiIiIiiIiiiiiIII2));
        }
        this.manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().config().setAutoRead(false);
    }

    private boolean handleClientSideCustomPacket(iIiIiIiIiiiiIiIiIiiiiIIIIIIIIIIiIiIIIIiiIIIiiIiIiIIIiiIiIiiIIiii msg, ChannelHandlerContext context) {
        String string = msg.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii();
        if ("FML|HS".equals(string) || "REGISTER".equals(string) || "UNREGISTER".equals(string)) {
            FMLProxyPacket fMLProxyPacket = new FMLProxyPacket(msg);
            fMLProxyPacket.setDispatcher(this);
            this.handshakeChannel.writeInbound(new Object[]{fMLProxyPacket});
            for (Object e : this.handshakeChannel.inboundMessages()) {
                List<FMLProxyPacket> list = FMLNetworkHandler.forwardHandshake((FMLMessage$CompleteHandshake)e, this, Side.CLIENT);
                for (FMLProxyPacket fMLProxyPacket2 : list) {
                    fMLProxyPacket2.setTarget(Side.CLIENT);
                    fMLProxyPacket2.payload().resetReaderIndex();
                    context.fireChannelRead((Object)fMLProxyPacket2);
                }
            }
            this.handshakeChannel.inboundMessages().clear();
            return true;
        }
        if (NetworkRegistry.INSTANCE.hasChannel(string, Side.CLIENT)) {
            FMLProxyPacket fMLProxyPacket = new FMLProxyPacket(msg);
            fMLProxyPacket.setDispatcher(this);
            context.fireChannelRead((Object)fMLProxyPacket);
            return true;
        }
        return false;
    }

    private boolean handleServerSideCustomPacket(iIiIIIIIiIiIiiIIiIIIiiIIiIIiIIIIiIIiIIIiIiIiIiiIiIiIIIIiIiiIIIii msg, ChannelHandlerContext context) {
        String string;
        if (this.state == NetworkDispatcher$ConnectionState.AWAITING_HANDSHAKE) {
            this.manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().pipeline().remove("fml:vanilla_detector");
            this.state = NetworkDispatcher$ConnectionState.HANDSHAKING;
        }
        if ("FML|HS".equals(string = msg.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii()) || "REGISTER".equals(string) || "UNREGISTER".equals(string)) {
            FMLProxyPacket fMLProxyPacket = new FMLProxyPacket(msg);
            fMLProxyPacket.setDispatcher(this);
            this.handshakeChannel.writeInbound(new Object[]{fMLProxyPacket});
            for (Object e : this.handshakeChannel.inboundMessages()) {
                List<FMLProxyPacket> list = FMLNetworkHandler.forwardHandshake((FMLMessage$CompleteHandshake)e, this, Side.SERVER);
                for (FMLProxyPacket fMLProxyPacket2 : list) {
                    fMLProxyPacket2.setTarget(Side.SERVER);
                    fMLProxyPacket2.payload().resetReaderIndex();
                    context.fireChannelRead((Object)fMLProxyPacket2);
                }
            }
            this.handshakeChannel.inboundMessages().clear();
            return true;
        }
        if (NetworkRegistry.INSTANCE.hasChannel(string, Side.SERVER)) {
            FMLProxyPacket fMLProxyPacket = new FMLProxyPacket(msg);
            fMLProxyPacket.setDispatcher(this);
            context.fireChannelRead((Object)fMLProxyPacket);
            return true;
        }
        return false;
    }

    public void sendProxy(FMLProxyPacket msg) {
        this.manager.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(msg, new GenericFutureListener[0]);
    }

    public void rejectHandshake(String result) {
        this.kickWithMessage(result);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.side == Side.CLIENT) {
            FMLCommonHandler.instance().bus().post(new FMLNetworkEvent$ClientDisconnectionFromServerEvent(this.manager));
        } else {
            FMLCommonHandler.instance().bus().post(new FMLNetworkEvent$ServerDisconnectionFromClientEvent(this.manager));
        }
        this.cleanAttributes(ctx);
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.side == Side.CLIENT) {
            FMLCommonHandler.instance().bus().post(new FMLNetworkEvent$ClientDisconnectionFromServerEvent(this.manager));
        } else {
            FMLCommonHandler.instance().bus().post(new FMLNetworkEvent$ServerDisconnectionFromClientEvent(this.manager));
        }
        this.cleanAttributes(ctx);
        ctx.close(promise);
    }

    @Deprecated
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) {
        ctx.read();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof FMLProxyPacket) {
            if (this.side == Side.CLIENT) {
                ctx.write((Object)((FMLProxyPacket)msg).toC17Packet(), promise);
            } else {
                ctx.write((Object)((FMLProxyPacket)msg).toS3FPacket(), promise);
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    public void flush(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void completeHandshake(Side target) {
        if (this.state == NetworkDispatcher$ConnectionState.CONNECTED) {
            FMLLog.severe("Attempt to double complete the network connection!", new Object[0]);
            throw new FMLNetworkException("Attempt to double complete!");
        }
        if (this.side == Side.CLIENT) {
            this.completeClientSideConnection(NetworkDispatcher$ConnectionType.MODDED);
        } else {
            this.completeServerSideConnection(NetworkDispatcher$ConnectionType.MODDED);
        }
    }

    public void completeClientHandshake() {
        this.state = NetworkDispatcher$ConnectionState.HANDSHAKECOMPLETE;
    }

    public void abortClientHandshake(String type) {
        FMLLog.log(Level.INFO, "Aborting client handshake \"%s\"", type);
        FMLCommonHandler.instance().waitForPlayClient();
        this.completeClientSideConnection(NetworkDispatcher$ConnectionType.valueOf(type));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!(cause instanceof ClosedChannelException)) {
            FMLLog.log(Level.ERROR, cause, "NetworkDispatcher exception", new Object[0]);
        }
        super.exceptionCaught(ctx, cause);
    }

    private void cleanAttributes(ChannelHandlerContext ctx) {
        ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).remove();
        ctx.channel().attr(NetworkRegistry.NET_HANDLER).remove();
        ctx.channel().attr(FML_DISPATCHER).remove();
        this.handshakeChannel.attr(FML_DISPATCHER).remove();
        this.manager.iIiiiiIiiiiiiIiIIIiiIiIIiIiiiiiiIIiiIIIiiIIIIiIIIiiiiiiiIIIIiIIi().attr(FML_DISPATCHER).remove();
    }

    public void setOverrideDimension(int overrideDim) {
        this.overrideLoginDim = overrideDim;
        FMLLog.fine("Received override dimension %d", overrideDim);
    }

    public int getOverrideDimension(iIIiiIiIiIiIIIIiIiIIIIiiiIIIiIIIiiiIiIIiiIIiiiiiIiiIIIiiIiIiiiII p_147282_1_) {
        FMLLog.fine("Overriding dimension: using %d", this.overrideLoginDim);
        return this.overrideLoginDim != 0 ? this.overrideLoginDim : p_147282_1_.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII();
    }
}

