/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.FMLOutboundHandler$OutboundTarget;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.FMLHandshakeMessage$ModList;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.EntitySpawnHandler;
import cpw.mods.fml.common.network.internal.FMLMessage$CompleteHandshake;
import cpw.mods.fml.common.network.internal.FMLMessage$EntityAdjustMessage;
import cpw.mods.fml.common.network.internal.FMLMessage$EntitySpawnMessage;
import cpw.mods.fml.common.network.internal.FMLMessage$OpenGui;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.network.internal.FMLRuntimeCodec;
import cpw.mods.fml.common.network.internal.HandshakeCompletionHandler;
import cpw.mods.fml.common.network.internal.NetworkModHolder;
import cpw.mods.fml.common.network.internal.OpenGuiHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.EntityRegistry$EntityRegistration;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fgm.IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi;
import fgm.IIIiiiIIiIIIiIiIiIIIiIiIIIiIiiiIiIIIiIiiiIIIiIIIIiIIIiIIIIiiiiiI;
import fgm.IiIIiIIIIIIIiIIiiiiiiIiiiIiiiiiIIiIIIIiiIiIiIiiIiiIIiiIIIIIiIiii;
import fgm.IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii;
import fgm.iIIIiiIiIiiIIIiiIIIIiIiIiiIIIIIiIiiIIiiIIiiIiiIiIiiiiiiiIIiIiIII;
import fgm.iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII;
import fgm.iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII;
import fgm.iiiiiIiiIIIiIiIiiiiIiIIIIiIiIiiIIiIiIiiiiIiiIiiIiiiIiIiiiIiIiiii;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.core.util.Integers;

@ObfuscationIgnore
public class FMLNetworkHandler {
    public static final int READ_TIMEOUT = Integers.parseInt((String)System.getProperty("fml.readTimeout", "30"), (int)30);
    public static final int LOGIN_TIMEOUT = Integers.parseInt((String)System.getProperty("fml.loginTimeout", "600"), (int)600);
    private static EnumMap<Side, FMLEmbeddedChannel> channelPair;

    public static void fmlServerHandshake(iiiiiIiiIIIiIiIiiiiIiIIIIiIiIiiIIiIiIiiiiIiiIiiIiiiIiIiiiIiIiiii scm, iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII manager, iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII player) {
        NetworkDispatcher networkDispatcher = NetworkDispatcher.allocAndSet(manager, scm);
        networkDispatcher.serverToClientHandshake(player);
    }

    public static void fmlClientHandshake(iiIIIiIiiIiIIiIiiIIIIIiIIIiIIiiIIIiIiIiiiIiiiiIIiIiiIIiIiIIIIIII field_147393_d) {
        NetworkDispatcher networkDispatcher = NetworkDispatcher.allocAndSet(field_147393_d);
        networkDispatcher.clientToServerHandshake();
    }

    public static void openGui(IIIiiiIIiIIIiIiIiIIIiIiIIIiIiiiIiIIIiIiiiIIIiIIIIiIIIiIIIIiiiiiI entityPlayer, Object mod, int modGuiId, IiIIiIIIIIIIiIIiiiiiiIiiiIiiiiiIIiIIIIiiIiIiIiiIiiIIiiIIIIIiIiii world, int x, int y, int z) {
        ModContainer modContainer = FMLCommonHandler.instance().findContainerFor(mod);
        if (entityPlayer instanceof iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII) {
            iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2 = (iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII)entityPlayer;
            iIIIiiIiIiiIIIiiIIIIiIiIiiIIIIIiIiiIIiiIIiiIiiIiIiiiiiiiIIiIiIII iIIIiiIiIiiIIIiiIIIIiIiIiiIIIIIiIiiIIiiIIiiIiiIiIiiiiiiiIIiIiIII2 = NetworkRegistry.INSTANCE.getRemoteGuiContainer(modContainer, iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2, modGuiId, world, x, y, z);
            if (iIIIiiIiIiiIIIiiIIIIiIiIiiIIIIIiIiiIIiiIIiiIiiIiIiiiiiiiIIiIiIII2 != null) {
                iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2.IiiIiiIiIiIiIIiIiiIiiiiIIIIIiIIiiiiiIiIIIiiIIiIIIIiiiiiiiIIiiIii();
                iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2.iIIiiIIIiIIiIiIiiIiIIiiiiiIIiiiIiiiiiiIiIIiiIIIIiIiIiIiIIIIIiiii();
                int n = iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii;
                FMLMessage$OpenGui fMLMessage$OpenGui = new FMLMessage$OpenGui(n, modContainer.getModId(), modGuiId, x, y, z);
                EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.PLAYER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2);
                embeddedChannel.writeOutbound(new Object[]{fMLMessage$OpenGui});
                iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2.iiiIiIIiiIIIiIIiIiiiiiIiiIIiIIiiIIIIiIiiiiIiIIIIIiIIiIIIiIIIIIII = iIIIiiIiIiiIIIiiIIIIiIiIiiIIIIIiIiiIIiiIIiiIiiIiIiiiiiiiIIiIiIII2;
                iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2.iiiIiIIiiIIIiIIiIiiiiiIiiIIiIIiiIIIIiIiiiiIiIIIIIiIIiIIIiIIIIIII.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii = n;
                iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2.iiiIiIIiiIIIiIIiIiiiiiIiiIIiIIiiIIIIiIiiiiIiIIIIIiIIiIIIiIIIIIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII2);
            }
        } else if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            Object object = NetworkRegistry.INSTANCE.getLocalGuiContainer(modContainer, entityPlayer, modGuiId, world, x, y, z);
            FMLCommonHandler.instance().showGuiScreen(object);
        } else {
            FMLLog.fine("Invalid attempt to open a local GUI on a dedicated server. This is likely a bug. GUIID: %s,%d", modContainer.getModId(), modGuiId);
        }
    }

    public static void makeEntitySpawnAdjustment(IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi entity, iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII player, int serverX, int serverY, int serverZ) {
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.PLAYER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        embeddedChannel.writeOutbound(new Object[]{new FMLMessage$EntityAdjustMessage(entity, serverX, serverY, serverZ)});
    }

    public static IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii getEntitySpawningPacket(IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi entity) {
        EntityRegistry$EntityRegistration entityRegistry$EntityRegistration = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (entityRegistry$EntityRegistration == null) {
            return null;
        }
        if (entityRegistry$EntityRegistration.usesVanillaSpawning()) {
            return null;
        }
        return channelPair.get((Object)Side.SERVER).generatePacketFrom(new FMLMessage$EntitySpawnMessage(entityRegistry$EntityRegistration, entity, entityRegistry$EntityRegistration.getContainer()));
    }

    public static String checkModList(FMLHandshakeMessage$ModList modListPacket, Side side) {
        Map<String, String> map = modListPacket.modList();
        return FMLNetworkHandler.checkModList(map, side);
    }

    public static String checkModList(Map<String, String> listData, Side side) {
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<ModContainer, NetworkModHolder> entry : NetworkRegistry.INSTANCE.registry().entrySet()) {
            boolean bl = entry.getValue().check(listData, side);
            if (bl) continue;
            arrayList.add(entry.getKey());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        FMLLog.info("Rejecting connection %s: %s", new Object[]{side, arrayList});
        return String.format("Mod rejections %s", arrayList);
    }

    @SideOnly(value=Side.CLIENT)
    private static void addClientHandlers() {
        ChannelPipeline channelPipeline = channelPair.get((Object)Side.CLIENT).pipeline();
        String string = channelPair.get((Object)Side.CLIENT).findChannelHandlerNameForType(FMLRuntimeCodec.class);
        channelPipeline.addAfter(string, "GuiHandler", (ChannelHandler)new OpenGuiHandler());
        channelPipeline.addAfter(string, "EntitySpawnHandler", (ChannelHandler)new EntitySpawnHandler());
    }

    public static void registerChannel(FMLContainer container, Side side) {
        channelPair = NetworkRegistry.INSTANCE.newChannel(container, "FML", new ChannelHandler[]{new FMLRuntimeCodec(), new HandshakeCompletionHandler()});
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.NOWHERE);
        if (side == Side.CLIENT) {
            FMLNetworkHandler.addClientHandlers();
        }
    }

    public static List<FMLProxyPacket> forwardHandshake(FMLMessage$CompleteHandshake push, NetworkDispatcher target, Side side) {
        channelPair.get((Object)side).attr(NetworkDispatcher.FML_DISPATCHER).set((Object)target);
        channelPair.get((Object)side).writeOutbound(new Object[]{push});
        ArrayList<FMLProxyPacket> arrayList = new ArrayList<FMLProxyPacket>();
        for (Object e : channelPair.get((Object)side).outboundMessages()) {
            arrayList.add((FMLProxyPacket)e);
        }
        channelPair.get((Object)side).outboundMessages().clear();
        return arrayList;
    }

    public static void enhanceStatusQuery(JsonObject jsonobject) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", "FML");
        JsonArray jsonArray = new JsonArray();
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("modid", modContainer.getModId());
            jsonObject2.addProperty("version", modContainer.getVersion());
            jsonArray.add((JsonElement)jsonObject2);
        }
        jsonObject.add("modList", (JsonElement)jsonArray);
        jsonobject.add("journeymap/modinfo", (JsonElement)jsonObject);
    }
}

