/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ASMDataTable$ASMData;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.internal.NetworkModHolder$DefaultNetworkChecker;
import cpw.mods.fml.common.network.internal.NetworkModHolder$IgnoredChecker;
import cpw.mods.fml.common.network.internal.NetworkModHolder$MethodNetworkChecker;
import cpw.mods.fml.common.network.internal.NetworkModHolder$NetworkChecker;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class NetworkModHolder {
    private static int assignedIds = 1;
    private int localId;
    private int networkId;
    private ModContainer container;
    private Method checkHandler;
    private VersionRange acceptableRange;
    private NetworkModHolder$NetworkChecker checker;
    private boolean acceptsVanillaClient;
    private boolean acceptsVanillaServer;

    public NetworkModHolder(ModContainer container) {
        this.container = container;
        this.networkId = this.localId = assignedIds++;
    }

    public NetworkModHolder(ModContainer container, Class<?> modClass, String acceptableVersionRange, ASMDataTable table) {
        this(container);
        SetMultimap<String, ASMDataTable$ASMData> setMultimap = table.getAnnotationsFor(container);
        Set set = setMultimap != null ? setMultimap.get((Object)NetworkCheckHandler.class.getName()) : ImmutableSet.of();
        String string = null;
        Object object = set.iterator();
        while (object.hasNext()) {
            ASMDataTable$ASMData aSMDataTable$ASMData = (ASMDataTable$ASMData)object.next();
            if (!aSMDataTable$ASMData.getClassName().equals(modClass.getName())) continue;
            string = aSMDataTable$ASMData.getObjectName();
            string = string.substring(0, string.indexOf(40));
            break;
        }
        if (set.isEmpty()) {
            for (Method method : modClass.getMethods()) {
                if (!method.isAnnotationPresent(NetworkCheckHandler.class)) continue;
                if (method.getParameterTypes().length == 2 && method.getParameterTypes()[0].equals(Map.class) && method.getParameterTypes()[1].equals(Side.class)) {
                    this.checkHandler = method;
                    break;
                }
                FMLLog.severe("Found unexpected method signature for annotation NetworkCheckHandler", new Object[0]);
            }
        }
        if (string != null) {
            try {
                object = modClass.getDeclaredMethod(string, Map.class, Side.class);
                if (((AccessibleObject)object).isAnnotationPresent(NetworkCheckHandler.class)) {
                    this.checkHandler = object;
                }
            }
            catch (Exception exception) {
                FMLLog.log(Level.WARN, exception, "The declared version check handler method %s on network mod id %s is not accessible", string, container.getModId());
            }
        }
        if (this.checkHandler != null) {
            this.checker = new NetworkModHolder$MethodNetworkChecker(this);
        } else if (!Strings.isNullOrEmpty((String)acceptableVersionRange) && acceptableVersionRange.equals("*")) {
            this.checker = new NetworkModHolder$IgnoredChecker(this);
        } else {
            try {
                this.acceptableRange = VersionRange.createFromVersionSpec(acceptableVersionRange);
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                FMLLog.log(Level.WARN, invalidVersionSpecificationException, "Invalid bounded range %s specified for network mod id %s", acceptableVersionRange, container.getModId());
            }
            this.checker = new NetworkModHolder$DefaultNetworkChecker(this);
        }
        FMLLog.finer("Mod %s is using network checker : %s", container.getModId(), this.checker);
        FMLLog.finer("Testing mod %s to verify it accepts its own version in a remote connection", container.getModId());
        boolean bl = this.acceptVersion(container.getVersion());
        if (!bl) {
            FMLLog.severe("The mod %s appears to reject its own version number (%s) in its version handling. This is likely a severe bug in the mod!", container.getModId(), container.getVersion());
        } else {
            FMLLog.finer("The mod %s accepts its own version (%s)", container.getModId(), container.getVersion());
        }
    }

    public boolean acceptVersion(String version) {
        if (this.acceptableRange != null) {
            return this.acceptableRange.containsVersion(new DefaultArtifactVersion(version));
        }
        return this.container.getVersion().equals(version);
    }

    public boolean check(Map<String, String> data, Side side) {
        return this.checker.check(data, side);
    }

    public int getLocalId() {
        return this.localId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public ModContainer getContainer() {
        return this.container;
    }

    public void setNetworkId(int value) {
        this.networkId = value;
    }

    public void testVanillaAcceptance() {
        this.acceptsVanillaClient = this.check((Map<String, String>)ImmutableMap.of(), Side.CLIENT);
        this.acceptsVanillaServer = this.check((Map<String, String>)ImmutableMap.of(), Side.SERVER);
    }

    public boolean acceptsVanilla(Side from) {
        return from == Side.CLIENT ? this.acceptsVanillaClient : this.acceptsVanillaServer;
    }
}

