/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.simpleimpl;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.FMLOutboundHandler$OutboundTarget;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.NetworkRegistry$TargetPoint;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper;
import cpw.mods.fml.common.network.simpleimpl.SimpleIndexedCodec;
import cpw.mods.fml.relauncher.Side;
import fgm.IIiiIIiIiiIiIiiiIiIiIIiiIiiiiiIiIiiIiiiiIiIiiiIiIiIiIIIiIIIIiiII;
import fgm.IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii;
import fgm.iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class SimpleNetworkWrapper {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private SimpleIndexedCodec packetCodec = new SimpleIndexedCodec();

    public SimpleNetworkWrapper(String channelName) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{this.packetCodec});
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side) {
        this.registerMessage(SimpleNetworkWrapper.instantiate(messageHandler), requestMessageType, discriminator, side);
    }

    static <REQ extends IMessage, REPLY extends IMessage> IMessageHandler<? super REQ, ? extends REPLY> instantiate(Class<? extends IMessageHandler<? super REQ, ? extends REPLY>> handler) {
        try {
            return handler.newInstance();
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side) {
        this.packetCodec.addDiscriminator(discriminator, requestMessageType);
        FMLEmbeddedChannel fMLEmbeddedChannel = this.channels.get((Object)side);
        String string = fMLEmbeddedChannel.findChannelHandlerNameForType(SimpleIndexedCodec.class);
        if (side == Side.SERVER) {
            this.addServerHandlerAfter(fMLEmbeddedChannel, string, messageHandler, requestMessageType);
        } else {
            this.addClientHandlerAfter(fMLEmbeddedChannel, string, messageHandler, requestMessageType);
        }
    }

    private <REQ extends IMessage, REPLY extends IMessage, NH extends IIiiIIiIiiIiIiiiIiIiIIiiIiiiiiIiIiiIiiiiIiIiiiIiIiIiIIIiIIIIiiII> void addServerHandlerAfter(FMLEmbeddedChannel channel, String type, IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestType) {
        SimpleChannelHandlerWrapper<? super REQ, ? extends REPLY> simpleChannelHandlerWrapper = this.getHandlerWrapper(messageHandler, Side.SERVER, requestType);
        channel.pipeline().addAfter(type, messageHandler.getClass().getName(), simpleChannelHandlerWrapper);
    }

    private <REQ extends IMessage, REPLY extends IMessage, NH extends IIiiIIiIiiIiIiiiIiIiIIiiIiiiiiIiIiiIiiiiIiIiiiIiIiIiIIIiIIIIiiII> void addClientHandlerAfter(FMLEmbeddedChannel channel, String type, IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestType) {
        SimpleChannelHandlerWrapper<? super REQ, ? extends REPLY> simpleChannelHandlerWrapper = this.getHandlerWrapper(messageHandler, Side.CLIENT, requestType);
        channel.pipeline().addAfter(type, messageHandler.getClass().getName(), simpleChannelHandlerWrapper);
    }

    private <REPLY extends IMessage, REQ extends IMessage> SimpleChannelHandlerWrapper<REQ, REPLY> getHandlerWrapper(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Side side, Class<REQ> requestType) {
        return new SimpleChannelHandlerWrapper<REQ, REPLY>(messageHandler, side, requestType);
    }

    public IiIiIiiIiIiiIiiIiiIiIIiIiiIIiiiIIiIIIiiiiIiIIiIIIiiIIiIIIiiiIiii getPacketFrom(IMessage message) {
        return this.channels.get((Object)Side.SERVER).generatePacketFrom(message);
    }

    public void sendToAll(IMessage message) {
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.ALL);
        this.channels.get((Object)Side.SERVER).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(IMessage message, iIiiIIiiiiiIiiIIiIIIIIiiiiIIIiiiiiIiiiiIiIiiIIIiIiIIIIiiiiiiIIII player) {
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.PLAYER);
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get((Object)Side.SERVER).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry$TargetPoint point) {
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.ALLAROUNDPOINT);
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get((Object)Side.SERVER).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.DIMENSION);
        this.channels.get((Object)Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get((Object)Side.SERVER).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(IMessage message) {
        this.channels.get((Object)Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler$OutboundTarget.TOSERVER);
        this.channels.get((Object)Side.CLIENT).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }
}

