/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.EntityRegistry$EntityRegistration;
import fgm.IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi;
import fgm.IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII;
import fgm.IiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII;
import fgm.IiiiIIIIIiIiIIiIIIiiIiiIIiiIiIIiiIiIiIIIIiIiIIiIiiIIIiiiiiiiIiIi;
import fgm.IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII;
import fgm.iiiIIIiiiiiIIIiIIiIiiiIIIIiIiiiiIiiiiiIIIIiIiiIIIiiiiIIIIIiIiIii;
import fgm.iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private BitSet availableIndicies;
    private ListMultimap<ModContainer, EntityRegistry$EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private Map<String, ModContainer> entityNames = Maps.newHashMap();
    private BiMap<Class<? extends IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi>, EntityRegistry$EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
        this.availableIndicies = new BitSet(256);
        this.availableIndicies.set(1, 255);
        for (Object k : IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI.keySet()) {
            this.availableIndicies.clear((Integer)k);
        }
    }

    public static void registerModEntity(Class<? extends IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    private void doModEntityRegistration(Class<? extends IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer modContainer = FMLCommonHandler.instance().findContainerFor(mod);
        if (modContainer == null) {
            modContainer = Loader.instance().activeModContainer();
        }
        EntityRegistry$EntityRegistration entityRegistry$EntityRegistration = new EntityRegistry$EntityRegistration(this, modContainer, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)entityRegistry$EntityRegistration);
            this.entityNames.put(entityName, modContainer);
            if (!IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI.containsKey(entityClass)) {
                String string = String.format("%s.%s", modContainer.getModId(), entityName);
                IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI.put(entityClass, string);
                IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii.put(string, entityClass);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", modContainer.getModId(), entityName, string);
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered class %s", modContainer.getModId(), entityClass.getName());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FMLLog.log(Level.WARN, illegalArgumentException, "The mod %s tried to register the entity (name,class) (%s,%s) one or both of which are already registered", modContainer.getModId(), entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)modContainer, (Object)entityRegistry$EntityRegistration);
    }

    public static void registerGlobalEntityID(Class<? extends IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi> entityClass, String entityName, int id) {
        if (IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI.containsKey(entityClass)) {
            ModContainer modContainer = Loader.instance().activeModContainer();
            String string = "unknown";
            if (modContainer != null) {
                string = modContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", string, entityClass);
            return;
        }
        id = EntityRegistry.instance().validateAndClaimId(id);
        IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(entityClass, entityName, id);
    }

    private int validateAndClaimId(int id) {
        int n = id;
        if (id < -128) {
            FMLLog.warning("Compensating for modloader out of range compensation by mod : entityId %d for mod %s is now %d", id, Loader.instance().activeModContainer().getModId(), n);
            n += 3000;
        }
        if (n < 0) {
            n += 127;
        }
        try {
            UnsignedBytes.checkedCast((long)n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FMLLog.log(Level.ERROR, "The entity ID %d for mod %s is not an unsigned byte and may not work", id, Loader.instance().activeModContainer().getModId());
        }
        if (!this.availableIndicies.get(n)) {
            FMLLog.severe("The mod %s has attempted to register an entity ID %d which is already reserved. This could cause severe problems", Loader.instance().activeModContainer().getModId(), id);
        }
        this.availableIndicies.clear(n);
        return n;
    }

    public static void registerGlobalEntityID(Class<? extends IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi> entityClass, String entityName, int id, int backgroundEggColour, int foregroundEggColour) {
        if (IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI.containsKey(entityClass)) {
            ModContainer modContainer = Loader.instance().activeModContainer();
            String string = "unknown";
            if (modContainer != null) {
                string = modContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", string, entityClass);
            return;
        }
        EntityRegistry.instance().validateAndClaimId(id);
        IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(entityClass, entityName, id, backgroundEggColour, foregroundEggColour);
    }

    public static void addSpawn(Class<? extends iiiIIIiiiiiIIIiIIiIiiiIIIIiIiiiiIiiiiiIIIIiIiiIIIiiiiIIIIIiIiIii> entityClass, int weightedProb, int min, int max, IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII typeOfCreature, iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii ... biomes) {
        for (iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii2 : biomes) {
            List list = iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(typeOfCreature);
            for (IiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII iiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII : list) {
                if (iiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii != entityClass) continue;
                iiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII = weightedProb;
                iiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI = min;
                iiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII.IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI = max;
                break;
            }
            list.add(new IiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII spawnList, iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii ... biomes) {
        Class clazz = (Class)IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii.get(entityName);
        if (iiiIIIiiiiiIIIiIIiIiiiIIIIiIiiiiIiiiiiIIIIiIiiIIIiiiiIIIIIiIiIii.class.isAssignableFrom(clazz)) {
            EntityRegistry.addSpawn(clazz, weightedProb, min, max, spawnList, biomes);
        }
    }

    public static void removeSpawn(Class<? extends iiiIIIiiiiiIIIiIIiIiiiIIIIiIiiiiIiiiiiIIIIiIiiIIIiiiiIIIIIiIiIii> entityClass, IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII typeOfCreature, iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii ... biomes) {
        for (iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii2 : biomes) {
            Iterator iterator = iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii2.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(typeOfCreature).iterator();
            while (iterator.hasNext()) {
                IiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII iiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII = (IiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII)iterator.next();
                if (iiiIiIIiIIIiIiiIIIiiiiiIIIiiIiiiIIiIIIIIIiiIIiIiiIiIIIiIiiiIIIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii != entityClass) continue;
                iterator.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII spawnList, iiiIIiIIIiIIIIiIiiIiiiiiiiiIIiIiiIIIIiiIIIIiIIiIIiIiIIiIiiIIIiii ... biomes) {
        Class clazz = (Class)IiiiiIiiiIiIiiIiIIIIiiIiIIIIiIiIIIiIiiIiIiIIIIIiIIIiiIIIIiIIiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii.get(entityName);
        if (iiiIIIiiiiiIIIiIIiIiiiIIIIiIiiiiIiiiiiIIIIiIiiIIIiiiiIIIIIiIiIii.class.isAssignableFrom(clazz)) {
            EntityRegistry.removeSpawn(clazz, spawnList, biomes);
        }
    }

    public static int findGlobalUniqueEntityId() {
        int n = EntityRegistry.instance().availableIndicies.nextSetBit(0);
        if (n < 0) {
            throw new RuntimeException("No more entity indicies left");
        }
        return n;
    }

    public EntityRegistry$EntityRegistration lookupModSpawn(Class<? extends IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi> clazz, boolean keepLooking) {
        Class<? extends IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi> clazz2 = clazz;
        do {
            EntityRegistry$EntityRegistration entityRegistry$EntityRegistration;
            if ((entityRegistry$EntityRegistration = (EntityRegistry$EntityRegistration)this.entityClassRegistrations.get(clazz2)) == null) continue;
            return entityRegistry$EntityRegistration;
        } while (keepLooking = !Object.class.equals(clazz2 = clazz2.getSuperclass()));
        return null;
    }

    public EntityRegistry$EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistry$EntityRegistration entityRegistry$EntityRegistration : this.entityRegistrations.get((Object)mc)) {
            if (entityRegistry$EntityRegistration.getModEntityId() != modEntityId) continue;
            return entityRegistry$EntityRegistration;
        }
        return null;
    }

    public boolean tryTrackingEntity(IiiiIIIIIiIiIIiIIIiiIiiIIiiIiIIiiIiIiIIIIiIiIIiIiiIIIiiiiiiiIiIi entityTracker, IIIIiIIIiIiiIiiiIiIIiIIiIIIIiIiIIiiiIIiIiIIIIiIiIiIiiiiiiiIiiiIi entity) {
        EntityRegistry$EntityRegistration entityRegistry$EntityRegistration = this.lookupModSpawn(entity.getClass(), true);
        if (entityRegistry$EntityRegistration != null) {
            entityTracker.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(entity, entityRegistry$EntityRegistration.getTrackingRange(), entityRegistry$EntityRegistration.getUpdateFrequency(), entityRegistry$EntityRegistration.sendsVelocityUpdates());
            return true;
        }
        return false;
    }
}

