/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.functions.GenericIterableFactory;
import cpw.mods.fml.common.registry.ExistingSubstitutionException;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.IncompatibleSubstitutionException;
import cpw.mods.fml.common.registry.RegistryDelegate;
import cpw.mods.fml.common.registry.RegistryDelegate$Delegate;
import fgm.IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii;
import fgm.IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi;
import fgm.IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii;
import fgm.IiIiiiiIIIiiIIiiiiiIIiiiIIIiiIiIIiIiiiIIiiiiIIIiiiiiIiIiiiiIIiIi;
import fgm.IiiiIiIiiiIiIiiiIiiIiiIiIiIiiiIIIiIiiiIIiIiIIIiIiIIiIIiiIiIIiIII;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class FMLControlledNamespacedRegistry<I>
extends IiiiIiIiiiIiIiiiIiiIiiIiIiIiiiIIIiIiiiIIiIiIIIiIiIIiIIiiIiIIiIII {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugRegistryEntries", "false"));
    private final Class<I> superType;
    private String optionalDefaultName;
    private I optionalDefaultObject;
    private int maxId;
    private int minId;
    private char discriminator;
    private final Map<String, String> aliases = new HashMap<String, String>();
    private BiMap<String, I> persistentSubstitutions;
    private BiMap<String, I> activeSubstitutions = HashBiMap.create();

    FMLControlledNamespacedRegistry(String optionalDefault, int maxIdValue, int minIdValue, Class<I> type, char discriminator) {
        this.superType = type;
        this.discriminator = discriminator;
        this.optionalDefaultName = optionalDefault;
        this.maxId = maxIdValue;
        this.minId = minIdValue;
    }

    void validateContent(int maxId, String type, BitSet availabilityMap, Set<Integer> blockedIds, FMLControlledNamespacedRegistry<IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi> iBlockRegistry) {
        for (I i : this.typeSafeIterable()) {
            int n = this.getId(i);
            String string = this.getNameForObject(i);
            boolean bl = this.activeSubstitutions.containsKey((Object)string);
            if (!bl && n < 0) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s, doesn't yield an id.", type, i, string));
            }
            if (n > maxId) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", type, i, string));
            }
            if (string == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", type, i, n));
            }
            if (string.isEmpty()) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, yields an empty name.", type, i, n));
            }
            if (string.indexOf(58) == -1) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, has the non-prefixed name %s.", type, i, n, string));
            }
            if (bl) continue;
            if (this.getRaw(n) != i) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", n, string, type, i));
            }
            if (this.getRaw(string) != i) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", string, n, type, i));
            }
            if (this.getId(string) != n) {
                throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", string, n));
            }
            if (!availabilityMap.get(n)) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, name %s, marked as empty.", type, i, n, string));
            }
            if (blockedIds.contains(n)) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, name %s, marked as dangling.", type, i, n, string));
            }
            if (!(i instanceof IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii)) continue;
            IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi iIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi = ((IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii)i).iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI;
            if (iBlockRegistry.getId(iIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi) != n) {
                throw new IllegalStateException(String.format("Registry entry for ItemBlock %s, id %d, is missing or uses the non-matching id %d.", i, n, iBlockRegistry.getId(iIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi)));
            }
            if (n <= 4095) continue;
            throw new IllegalStateException(String.format("ItemBlock %s uses the id %d outside the block id range", string, n));
        }
    }

    void set(FMLControlledNamespacedRegistry<I> registry) {
        if (this.superType != registry.superType) {
            throw new IllegalArgumentException("incompatible registry");
        }
        this.discriminator = registry.discriminator;
        this.optionalDefaultName = registry.optionalDefaultName;
        this.maxId = registry.maxId;
        this.minId = registry.minId;
        this.aliases.clear();
        this.aliases.putAll(registry.aliases);
        this.activeSubstitutions.clear();
        this.underlyingIntegerMap = new IiIiiiiIIIiiIIiiiiiIIiiiIIIiiIiIIiIiiiIIiiiiIIIiiiiiIiIiiiiIIiIi();
        this.registryObjects.clear();
        for (I i : registry.typeSafeIterable()) {
            int n = registry.getId(i);
            this.addObjectRaw(n, registry.getNameForObject(i), i);
        }
        this.activeSubstitutions.putAll(registry.activeSubstitutions);
    }

    @Override
    @Deprecated
    public void addObject(int id, String name, Object thing) {
        GameData.getMain().register(thing, name, id);
    }

    @Override
    @Deprecated
    public void putObject(Object objName, Object obj) {
        String string = (String)objName;
        I i = this.cast(obj);
        if (string == null) {
            throw new NullPointerException("Can't use a null-name for the registry.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Can't use an empty name for the registry.");
        }
        if (i == null) {
            throw new NullPointerException("Can't add null-object to the registry.");
        }
        string = FMLControlledNamespacedRegistry.ensureNamespaced(string);
        String string2 = this.getNameForObject(i);
        if (string2 == null) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), not resolvable", string, i);
        } else if (string2.equals(string)) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), already added", string, i);
        } else {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), adding alias to %s instead", string, i, string2);
            this.addAlias(string, string2);
        }
    }

    public I getObject(String name) {
        I i = this.getRaw(name);
        return i == null ? this.optionalDefaultObject : i;
    }

    public I getObjectById(int id) {
        I i = this.getRaw(id);
        return i == null ? this.optionalDefaultObject : i;
    }

    @Deprecated
    public I get(int id) {
        return this.getObjectById(id);
    }

    @Deprecated
    public I get(String name) {
        return this.getObject(name);
    }

    public int getId(I thing) {
        return this.getIDForObject(thing);
    }

    public I getRaw(int id) {
        return this.cast(super.getObjectById(id));
    }

    private I cast(Object obj) {
        return (I)obj;
    }

    public I getRaw(String name) {
        I i = this.cast(super.getObject(name));
        if (i == null && (name = this.aliases.get(name)) != null) {
            return this.getRaw(name);
        }
        return i;
    }

    @Override
    public boolean containsKey(String name) {
        boolean bl = super.containsKey(name);
        if (!bl && (name = this.aliases.get(name)) != null) {
            return this.containsKey(name);
        }
        return bl;
    }

    public int getId(String itemName) {
        I i = this.getRaw(itemName);
        if (i == null) {
            return -1;
        }
        return this.getId(i);
    }

    @Deprecated
    public boolean contains(String itemName) {
        return this.containsKey(itemName);
    }

    public Iterable<I> typeSafeIterable() {
        return GenericIterableFactory.newCastingIterable(super.iterator(), this.superType);
    }

    public void serializeInto(Map<String, Integer> idMapping) {
        for (I i : this.typeSafeIterable()) {
            idMapping.put(this.discriminator + this.getNameForObject(i), this.getId(i));
        }
    }

    public Map<String, String> getAliases() {
        return ImmutableMap.copyOf(this.aliases);
    }

    int add(int id, String name, I thing, BitSet availabilityMap) {
        if (name == null) {
            throw new NullPointerException(String.format("Can't use a null-name for the registry, object %s.", thing));
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't use an empty name for the registry, object %s.", thing));
        }
        if (name.indexOf(58) == -1) {
            throw new IllegalArgumentException(String.format("Can't add the name (%s) without a prefix, object %s", name, thing));
        }
        if (thing == null) {
            throw new NullPointerException(String.format("Can't add null-object to the registry, name %s.", name));
        }
        if (name.equals(this.optionalDefaultName) && this.optionalDefaultObject == null) {
            this.optionalDefaultObject = thing;
        }
        if (this.getPersistentSubstitutions().containsValue(thing)) {
            throw new IllegalArgumentException(String.format("The object %s (%s) cannot be added to the registry. It is already being used as a substitute for %s", thing.getClass(), name, this.getPersistentSubstitutions().inverse().get(thing)));
        }
        int n = id;
        if (n < 0 || availabilityMap.get(n)) {
            n = availabilityMap.nextClearBit(this.minId);
        }
        if (n > this.maxId) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", n));
        }
        if (this.getRaw(name) == thing) {
            FMLLog.bigWarning("The object %s has been registered twice for the same name %s.", thing, name);
            return this.getId(thing);
        }
        if (this.getRaw(name) != null) {
            throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", name, this.getRaw(name), thing));
        }
        if (this.getId(thing) >= 0) {
            int n2 = this.getId(thing);
            I i = this.getRaw(n2);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", thing, System.identityHashCode(thing), this.getNameForObject(thing), name, i, System.identityHashCode(i)));
        }
        if (GameData.isFrozen(this)) {
            FMLLog.bigWarning("The object %s (name %s) is being added too late.", thing, name);
        }
        if (this.activeSubstitutions.containsKey((Object)name)) {
            thing = this.activeSubstitutions.get((Object)name);
        }
        this.addObjectRaw(n, name, thing);
        if (DEBUG) {
            FMLLog.finer("Registry add: %s %d %s (req. id %d)", name, n, thing, id);
        }
        return n;
    }

    void addAlias(String from, String to) {
        this.aliases.put(from, to);
        if (DEBUG) {
            FMLLog.finer("Registry alias: %s -> %s", from, to);
        }
    }

    Map<String, Integer> getEntriesNotIn(FMLControlledNamespacedRegistry<I> registry) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (I i : this.typeSafeIterable()) {
            if (registry.field_148758_b.containsKey(i) || registry.activeSubstitutions.containsKey((Object)this.getNameForObject(i))) continue;
            hashMap.put(this.getNameForObject(i), this.getId(i));
        }
        return hashMap;
    }

    void dump() {
        if (!DEBUG) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (I i : this.typeSafeIterable()) {
            arrayList.add(this.getId(i));
        }
        Collections.sort(arrayList);
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            I i = this.getRaw(n);
            FMLLog.finer("Registry: %d %s %s", n, this.getNameForObject(i), i);
        }
    }

    private void addObjectRaw(int id, String name, I thing) {
        if (name == null) {
            throw new NullPointerException("The name to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (thing == null) {
            throw new NullPointerException("The object to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (!this.superType.isInstance(thing)) {
            throw new IllegalArgumentException("The object to be added to the registry is not of the right type. Reflection/ASM hackery? Registry bug?");
        }
        this.underlyingIntegerMap.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(thing, id);
        super.putObject(name, thing);
    }

    public I getDefaultValue() {
        return this.optionalDefaultObject;
    }

    public RegistryDelegate<I> getDelegate(I thing, Class<I> clazz) {
        return GameData.buildDelegate(thing, clazz);
    }

    void activateSubstitution(String nameToReplace) {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace)) {
            Object object = this.getRaw(nameToReplace);
            if (this.superType == IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii.class) {
                IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii iiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii = (IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii)this.getPersistentSubstitutions().get((Object)nameToReplace);
                if (object == null) {
                    object = GameData.getItemRegistry().getRaw(nameToReplace);
                }
                FMLLog.log(Level.DEBUG, "Replacing %s with %s (name %s)", object, iiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii, nameToReplace);
                RegistryDelegate$Delegate registryDelegate$Delegate = (RegistryDelegate$Delegate)((IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii)object).iIiIIIIiIiIiiiIiIiiIiiIiIiiiIIiIiIiiiIIIiIiIiiiIIIIiIiIiiIiIiiiI;
                registryDelegate$Delegate.changeReference(iiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii);
                ((RegistryDelegate$Delegate)iiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii.iIiIIIIiIiIiiiIiIiiIiiIiIiiiIIiIiIiiiIIIiIiIiiiIIIIiIiIiiIiIiiiI).setName(nameToReplace);
            }
            this.activeSubstitutions.put((Object)nameToReplace, this.getPersistentSubstitutions().get((Object)nameToReplace));
        }
    }

    void addSubstitutionAlias(String modId, String nameToReplace, Object toReplace) {
        if (this.getPersistentSubstitutions().containsKey((Object)nameToReplace) || this.getPersistentSubstitutions().containsValue(toReplace)) {
            FMLLog.severe("The substitution of %s has already occured. You cannot duplicate substitutions", nameToReplace);
            throw new ExistingSubstitutionException(nameToReplace, toReplace);
        }
        I i = this.cast(toReplace);
        I i2 = this.getRaw(nameToReplace);
        if (i2 == null) {
            throw new NullPointerException("The replacement target is not present. This won't work");
        }
        if (!i2.getClass().isAssignableFrom(i.getClass())) {
            FMLLog.severe("The substitute %s for %s (type %s) is type incompatible. This won't work", i.getClass().getName(), nameToReplace, i2.getClass().getName());
            throw new IncompatibleSubstitutionException(nameToReplace, i, i2);
        }
        int n = this.getId(i);
        if (n != -1) {
            FMLLog.severe("The substitute %s for %s is registered into the game independently. This won't work", i.getClass().getName(), nameToReplace);
            throw new IllegalArgumentException("The object substitution is already registered. This won't work");
        }
        FMLLog.log(Level.DEBUG, "Adding substitution %s with %s (name %s)", i2, i, nameToReplace);
        this.getPersistentSubstitutions().put((Object)nameToReplace, i);
    }

    public void serializeSubstitutions(Set<String> blockSubs) {
        blockSubs.addAll(this.activeSubstitutions.keySet());
    }

    private BiMap<String, I> getPersistentSubstitutions() {
        if (this.persistentSubstitutions == null) {
            this.persistentSubstitutions = GameData.getMain().getPersistentSubstitutionMap(this.superType);
        }
        return this.persistentSubstitutions;
    }

    @Override
    public Iterator<I> iterator() {
        return Iterators.concat((Iterator)super.iterator(), this.getPersistentSubstitutions().values().iterator());
    }

    void resetSubstitutionDelegates() {
        for (I i : this.typeSafeIterable()) {
            RegistryDelegate$Delegate registryDelegate$Delegate = (RegistryDelegate$Delegate)((IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii)i).iIiIIIIiIiIiiiIiIiiIiiIiIiiiIIiIiIiiiIIIiIiIiiiIIIIiIiIiiIiIiiiI;
            registryDelegate$Delegate.changeReference((IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii)i);
        }
    }
}

