/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry$1;
import cpw.mods.fml.common.registry.GameRegistry$Type;
import cpw.mods.fml.common.registry.GameRegistry$UniqueIdentifier;
import fgm.IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii;
import fgm.IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi;
import fgm.IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii;
import fgm.IiIIiIIIIIIIiIIiiiiiiIiiiIiiiiiIIiIIIIiiIiIiIiiIiiIIiiIIIIIiIiii;
import fgm.IiIIiIIiIIIIiIIiiIiIIiiIIiiiiiiIIIiIIiIIiIIIiiIiIiiIIIiiIIiiiiIi;
import fgm.IiIiIIIIiiIIIIiiiiiIIiiIIiiIIiiiiiIiIiiiIiiIIiiIiiiIIIIiiiIIiIIi;
import fgm.IiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI;
import fgm.IiIiiIIiIiIiiiiIiiIIIIiIiiiIIIiIiIIIiIIiiiIIiIIIIIiIiiIIIiIiiIiI;
import fgm.IiIiiiIiIiIIiiIIIiIiiiIIIiIiiIiIIiIiIIiiIiiIIiiIiiiiIIiIiIiiIIII;
import fgm.iIIiiiIIiiiiIIIIIiIiiiiiIIIIiiIIIiiIIiiIiIiiIIIIIiIiIIiIIIIIiIiI;
import fgm.iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii;
import fgm.iiIIIiIiiiIiIiiIiIIiIIIiIiiIIiiiIiiIiIiiiiIIiIIiIiIIiIiIiIIIIIii;
import fgm.iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII;
import fgm.iiIiiiIIiIIIIiiiiIiIIIiIIiiIiIIiIiIiIIIIiiIiIIIIIiIIiiiiIIiiiIii;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
    }

    public static void generateWorld(int chunkX, int chunkZ, IiIIiIIIIIIIiIIiiiiiiIiiiIiiiiiIIiIIIIiiIiIiIiiIiiIIiiIIIIIiIiii world, IiIIiIIiIIIIiIIiiIiIIiiIIiiiiiiIIIiIIiIIiIIIiiIiIiiIIIiiIIiiiiIi chunkGenerator, IiIIiIIiIIIIiIIiiIiIIiiIIiiiiiiIIIiIIiIIiIIIiiIiIiiIIIiiIIiiiiIi chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long l = world.IIiIIIIiiiiiiiIIiiiiiiiiiiiIIIIIiIIIIiIiiiiIiIiIIiiIiiIiiIiIiiIi();
        Random random = new Random(l);
        long l2 = random.nextLong() >> 3;
        long l3 = random.nextLong() >> 3;
        long l4 = l2 * (long)chunkX + l3 * (long)chunkZ ^ l;
        for (IWorldGenerator iWorldGenerator : sortedGeneratorList) {
            random.setSeed(l4);
            iWorldGenerator.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private static void computeSortedGeneratorList() {
        ArrayList arrayList = Lists.newArrayList(worldGenerators);
        Collections.sort(arrayList, new GameRegistry$1());
        sortedGeneratorList = ImmutableList.copyOf((Collection)arrayList);
    }

    public static void registerItem(IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static void registerID(IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii item, String name, int id) {
        GameData.getMain().register(item, name, id);
    }

    public static void registerIDBlock(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi item, String name, int id) {
        GameData.getMain().register(item, name, id);
    }

    public static IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii registerItem(IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii item, String name, String modId) {
        GameData.getMain().registerItem(item, name);
        return item;
    }

    public static void addSubstitutionAlias(String nameToSubstitute, GameRegistry$Type type, Object object) {
        GameData.getMain().registerSubstitutionAlias(nameToSubstitute, type, object);
    }

    public static IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi registerBlock(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi block, String name) {
        return GameRegistry.registerBlock(block, IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii.class, name);
    }

    public static IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi registerBlock(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi block, Class<? extends IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii> itemclass, String name) {
        return GameRegistry.registerBlock(block, itemclass, name, new Object[0]);
    }

    public static IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi registerBlockID(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi block, Class<? extends IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii> itemclass, String name, int id) {
        return GameRegistry.registerBlockID(block, itemclass, name, id, new Object[0]);
    }

    @Deprecated
    public static IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi registerBlock(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi block, Class<? extends IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii> itemclass, String name, String modId, Object ... itemCtorArgs) {
        return GameRegistry.registerBlock(block, itemclass, name, itemCtorArgs);
    }

    public static IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi registerBlockID(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi block, Class<? extends IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii> itemclass, String name, int id, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii iIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii = null;
            if (itemclass != null) {
                Class[] classArray = new Class[itemCtorArgs.length + 1];
                classArray[0] = IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi.class;
                for (int i = 1; i < classArray.length; ++i) {
                    classArray[i] = itemCtorArgs[i - 1].getClass();
                }
                Constructor<? extends IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii> constructor = itemclass.getConstructor(classArray);
                iIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii = constructor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            GameData.getMain().registerBlockID(block, name, id);
            if (iIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii != null) {
                GameData.getMain().registerItem(iIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii, name);
            }
            return block;
        }
        catch (Exception exception) {
            FMLLog.log(Level.ERROR, exception, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(exception);
        }
    }

    public static IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi registerBlock(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi block, Class<? extends IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii> itemclass, String name, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii iIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii = null;
            if (itemclass != null) {
                Class[] classArray = new Class[itemCtorArgs.length + 1];
                classArray[0] = IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi.class;
                for (int i = 1; i < classArray.length; ++i) {
                    classArray[i] = itemCtorArgs[i - 1].getClass();
                }
                Constructor<? extends IIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii> constructor = itemclass.getConstructor(classArray);
                iIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii = constructor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            GameData.getMain().registerBlock(block, name);
            if (iIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii != null) {
                GameData.getMain().registerItem(iIiIIiIIIIiIiIiiiIiiIiiiiIiIiiIiiIIIiIiiiiIIiIiiiIIIiIiIIIiiIiii, name);
            }
            return block;
        }
        catch (Exception exception) {
            FMLLog.log(Level.ERROR, exception, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(exception);
        }
    }

    public static void addRecipe(iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static iiIiiiIIiIIIIiiiiIiIIIiIIiiIiIIiIiIiIIIIiiIiIIIIIiIIiiiiIIiiiIii addShapedRecipe(iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII output, Object ... params) {
        return iiIIIiIiiiIiIiiIiIIiIIIiIiiIIiiiIiiIiIiiiiIIiIIiIiIIiIiIiIIIIIii.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(output, params);
    }

    public static void addShapelessRecipe(iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII output, Object ... params) {
        iiIIIiIiiiIiIiiIiIIiIIIiIiiIIiiiIiiIiIiiiiIIiIIiIiIIiIiIiIIIIIii.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(output, params);
    }

    public static void addRecipe(iiIiiiIIiIIIIiiiiIiIIIiIIiiIiIIiIiIiIIIIiiIiIIIIIiIIiiiiIIiiiIii recipe) {
        iiIIIiIiiiIiIiiIiIIiIIIiIiiIIiiiIiiIiIiiiiIIiIIiIiIIiIiIiIIIIIii.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI().add(recipe);
    }

    public static void addSmelting(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi input, iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII output, float xp) {
        iIIiiiIIiiiiIIIIIiIiiiiiIIIIiiIIIiiIIiiIiIiiIIIIIiIiIIiIIIIIiIiI.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(input, output, xp);
    }

    public static void addSmelting(IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii input, iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII output, float xp) {
        iIIiiiIIiiiiIIIIIiIiiiiiIIIIiiIIIiiIIiiIiIiiIIIIIiIiIIiIIIIIiIiI.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(input, output, xp);
    }

    public static void addSmelting(iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII input, iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII output, float xp) {
        iIIiiiIIiiiiIIIIIiIiiiiiIIIIiiIIIiiIIiiIiIiiIIIIIiIiIIiIIIIIiIiI.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(input, output, xp);
    }

    public static void registerTileEntity(Class<? extends IiIiiIIiIiIiiiiIiiIIIIiIiiiIIIiIiIIIiIIiiiIIiIIIIIiIiiIIIiIiiIiI> tileEntityClass, String id) {
        IiIiiIIiIiIiiiiIiiIIIIiIiiiIIIiIiIIIiIIiiiIIiIIIIIiIiiIIIiIiiIiI.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(tileEntityClass, id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends IiIiiIIiIiIiiiiIiiIIIIiIiiiIIIiIiIIIiIIiiiIIiIIIIIiIiiIIIiIiiIiI> tileEntityClass, String id, String ... alternatives) {
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII itemStack) {
        int n = 0;
        for (IFuelHandler iFuelHandler : fuelHandlers) {
            n = Math.max(n, iFuelHandler.getBurnTime(itemStack));
        }
        return n;
    }

    public static IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    public static void registerCustomItemStack(String name, iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII itemStack) {
        GameData.registerCustomItemStack(name, itemStack);
    }

    public static iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII findItemStack(String modId, String name, int stackSize) {
        iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII2 = GameData.findItemStack(modId, name);
        if (iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII2 != null) {
            iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII3 = iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII2.iiiiiiiiiIiiIIiiiIIIiiIiIiIiiiiIIIiiiIIiIIiIiIiIIIiIIIIIiIiiiiiI();
            iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI = Math.min(stackSize, iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII3.IiIIiIiIIIiiIIIiiIIiIIIiIiIiiIiIIiIIiiIiiiiiiiIIIIIIiIIiIIiiIiii());
            return iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII3;
        }
        return null;
    }

    public static GameRegistry$UniqueIdentifier findUniqueIdentifierFor(IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi block) {
        return GameData.getUniqueName(block);
    }

    public static GameRegistry$UniqueIdentifier findUniqueIdentifierFor(IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii item) {
        return GameData.getUniqueName(item);
    }

    public static iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII makeItemStack(String itemName, int meta, int stackSize, String nbtString) {
        if (itemName == null) {
            throw new IllegalArgumentException("The itemName cannot be null");
        }
        IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii iiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii = GameData.getItemRegistry().getObject(itemName);
        if (iiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii == null) {
            FMLLog.getLogger().log(Level.TRACE, "Unable to find item with name {}", (Object)itemName);
            return null;
        }
        iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII2 = new iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII(iiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii, 1, meta);
        if (!Strings.isNullOrEmpty((String)nbtString)) {
            IiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI iiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI = null;
            try {
                iiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI = IiIiiiIiIiIIiiIIIiIiiiIIIiIiiIiIIiIiIIiiIiiIIiiIiiiiIIiIiIiiIIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(nbtString);
            }
            catch (IiIiIIIIiiIIIIiiiiiIIiiIIiiIIiiiiiIiIiiiIiiIIiiIiiiIIIIiiiIIiIIi iiIiIIIIiiIIIIiiiiiIIiiIIiiIIiiiiiIiIiiiIiiIIiiIiiiIIIIiiiIIiIIi) {
                FMLLog.getLogger().log(Level.WARN, "Encountered an exception parsing ItemStack NBT string {}", (Object)nbtString, (Object)iiIiIIIIiiIIIIiiiiiIIiiIIiiIIiiiiiIiIiiiIiiIIiiIiiiIIIIiiiIIiIIi);
                throw Throwables.propagate((Throwable)iiIiIIIIiiIIIIiiiiiIIiiIIiiIIiiiiiIiIiiiIiiIIiiIiiiIIIIiiiIIiIIi);
            }
            if (!(iiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI instanceof iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)) {
                FMLLog.getLogger().log(Level.WARN, "Unexpected NBT string - multiple values {}", (Object)nbtString);
                throw new RuntimeException("Invalid NBT JSON");
            }
            iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII2.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII((iIiIiiiiiiiiIiIIIIiiiiIiIIIIiiiIiIIIiiiIIIiIIIIiIiIiIIIIiIiIIIii)iiIiIiiIiIiIIIiiiIIIIIiIIIiIIiIiiIiIiiIIiIIIiiiiiiiIiiiIiIIIIiiI);
        }
        return iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII2;
    }
}

