/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import fgm.IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi;
import fgm.IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii;
import fgm.iIIIIIiIIiiiiIiIiIIiIIiIIiIIiIiiIIIIIIiIIiIIIIiIIIiIIIiiiIiIIIIi;
import fgm.iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class LanguageRegistry {
    private static final LanguageRegistry INSTANCE = new LanguageRegistry();
    private Map<String, Properties> modLanguageData = new HashMap<String, Properties>();
    private static final Pattern assetENUSLang = Pattern.compile("assets/(.*)/lang/(?:.+/|)([\\w_-]+).lang");

    public static LanguageRegistry instance() {
        return INSTANCE;
    }

    public String getStringLocalization(String key) {
        return this.getStringLocalization(key, FMLCommonHandler.instance().getCurrentLanguage());
    }

    public String getStringLocalization(String key, String lang) {
        String string = "";
        Properties properties = this.modLanguageData.get(lang);
        if (properties != null && properties.getProperty(key) != null) {
            string = properties.getProperty(key);
        }
        return string;
    }

    @Deprecated
    public void addStringLocalization(String key, String value) {
        this.addStringLocalization(key, "en_US", value);
    }

    @Deprecated
    public void addStringLocalization(String key, String lang, String value) {
        Properties properties = this.modLanguageData.get(lang);
        if (properties == null) {
            properties = new Properties();
            this.modLanguageData.put(lang, properties);
        }
        properties.put(key, value);
    }

    @Deprecated
    public void addStringLocalization(Properties langPackAdditions) {
        this.addStringLocalization(langPackAdditions, "en_US");
    }

    @Deprecated
    public void addStringLocalization(Properties langPackAdditions, String lang) {
        Properties properties = this.modLanguageData.get(lang);
        if (properties == null) {
            properties = new Properties();
            this.modLanguageData.put(lang, properties);
        }
        if (langPackAdditions != null) {
            properties.putAll((Map<?, ?>)langPackAdditions);
        }
    }

    @Deprecated
    public void addNameForObject(Object objectToName, String lang, String name) {
        Object object;
        if (objectToName instanceof IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii) {
            object = ((IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii)objectToName).iiIiiiiiiiiIIiIIIiiiIIiiIiIiIIiIiIiIIiIiIiIIiIiIiiiiiiiIIIiiiIII();
        } else if (objectToName instanceof IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi) {
            object = ((IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi)objectToName).h_();
        } else if (objectToName instanceof iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII) {
            object = ((iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII)objectToName).IIiiiIIiiiIiiiIiIIiIIiiIIIiIiiIiiiiiIiiiiiIiiiIIiIIiIIiiIiIIiIiI().d_((iiIiIiiiIIiIIIiiIIIiIiiIIIiiiIIIIiIiIiiiiiiIiIIIIiIIiiiiiIiiIiII)objectToName);
        } else {
            throw new IllegalArgumentException(String.format("Illegal object for naming %s", objectToName));
        }
        object = (String)object + ".name";
        this.addStringLocalization((String)object, lang, name);
    }

    @Deprecated
    public static void addName(Object objectToName, String name) {
        LanguageRegistry.instance().addNameForObject(objectToName, "en_US", name);
    }

    @Deprecated
    public void mergeLanguageTable(Map field_135032_a, String lang) {
        Properties properties;
        Properties properties2 = this.modLanguageData.get(lang);
        if (properties2 != null) {
            this.mergeWithoutOverwrite(properties2, field_135032_a);
        }
        if ((properties = this.modLanguageData.get("en_US")) != null) {
            this.mergeWithoutOverwrite(properties, field_135032_a);
        }
    }

    @Deprecated
    private <K, V> void mergeWithoutOverwrite(Map<? extends K, ? extends V> from, Map<K, V> to) {
        for (Map.Entry<K, V> entry : from.entrySet()) {
            if (to.containsKey(entry.getKey())) continue;
            to.put(entry.getKey(), entry.getValue());
        }
    }

    @Deprecated
    public void loadLocalization(String localizationFile, String lang, boolean isXML) {
        URL uRL = this.getClass().getResource(localizationFile);
        if (uRL != null) {
            this.loadLocalization(uRL, lang, isXML);
        } else {
            ModContainer modContainer = Loader.instance().activeModContainer();
            if (modContainer != null) {
                FMLLog.log(modContainer.getModId(), Level.ERROR, "The language resource %s cannot be located on the classpath. This is a programming error.", localizationFile);
            } else {
                FMLLog.log(Level.ERROR, "The language resource %s cannot be located on the classpath. This is a programming error.", localizationFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void loadLocalization(URL localizationFile, String lang, boolean isXML) {
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            inputStream = localizationFile.openStream();
            if (isXML) {
                properties.loadFromXML(inputStream);
            } else {
                properties.load(new InputStreamReader(inputStream, Charsets.UTF_8));
            }
            this.addStringLocalization(properties, lang);
        }
        catch (IOException iOException) {
            FMLLog.log(Level.ERROR, iOException, "Unable to load localization from file %s", localizationFile);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void injectLanguage(String language, HashMap<String, String> parsedLangFile) {
        Properties properties = this.modLanguageData.get(language);
        if (properties == null) {
            properties = new Properties();
            this.modLanguageData.put(language, properties);
        }
        properties.putAll((Map<?, ?>)parsedLangFile);
    }

    public void loadLanguagesFor(ModContainer container, Side side) {
        File file = container.getSource();
        try {
            if (file.isDirectory()) {
                this.searchDirForLanguages(file, "", side);
            } else {
                this.searchZipForLanguages(file, side);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void searchZipForLanguages(File source, Side side) {
        ZipFile zipFile = new ZipFile(source);
        ArrayList arrayList = Lists.newArrayList();
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            Matcher matcher = assetENUSLang.matcher(zipEntry.getName());
            if (!matcher.matches()) continue;
            String string = matcher.group(2);
            arrayList.add(string);
            LanguageRegistry.instance().injectLanguage(string, iIIIIIiIIiiiiIiIiIIiIIiIIiIIiIiiIIIIIIiIIiIIIIiIIIiIIIiiiIiIIIIi.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(zipFile.getInputStream(zipEntry)));
            if (!"en_US".equals(string) || side != Side.SERVER) continue;
            iIIIIIiIIiiiiIiIiIIiIIiIIiIIiIiiIIIIIIiIIiIIIIiIIIiIIIiiiIiIIIIi.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(zipFile.getInputStream(zipEntry));
        }
        if (arrayList.size() > 0) {
            FMLLog.fine("Found translations in %s [%s]", source.getName(), Joiner.on((String)", ").join((Iterable)arrayList));
        }
        zipFile.close();
    }

    private void searchDirForLanguages(File source, String path, Side side) {
        for (File file : source.listFiles()) {
            Matcher matcher;
            String string = path + file.getName();
            if (file.isDirectory()) {
                this.searchDirForLanguages(file, string + "/", side);
            }
            if (!(matcher = assetENUSLang.matcher(string)).matches()) continue;
            String string2 = matcher.group(2);
            FMLLog.fine("Injecting found translation assets for lang %s at %s into language system", string2, string);
            LanguageRegistry.instance().injectLanguage(string2, iIIIIIiIIiiiiIiIiIIiIIiIIiIIiIiiIIIIIIiIIiIIIIiIIIiIIIiiiIiIIIIi.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(new FileInputStream(file)));
            if (!"en_US".equals(string2) || side != Side.SERVER) continue;
            iIIIIIiIIiiiiIiIiIIiIIiIIiIIiIiiIIIIIIiIIiIIIIiIIIiIIIiiiIiIIIIi.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(new FileInputStream(file));
        }
    }
}

