/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import fgm.IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi;
import fgm.IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii;
import fgm.iIIIiiiIiIIIIIiIIiIiiIiiiIIiIiIIiIIiiiIiIiiiIIIIIiIIiiIiiiiiiiiI;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.logging.log4j.Level;

class ObjectHolderRef {
    private Field field;
    private String injectedObject;
    private boolean isBlock;
    private boolean isItem;
    private static Field modifiersField;

    ObjectHolderRef(Field field, String injectedObject, boolean extractFromExistingValues) {
        this.field = field;
        this.isBlock = IIiiIiIiiiIiiiiIiIiIiiiiIIiiiIIIIiiiiIIiiIiIIiiIiiiiIIIiIiIIIIIi.class.isAssignableFrom(field.getType());
        this.isItem = IiIIIiIiiiiIiIIIiIIIIiIiIIIiiiiiiIIIiiIiIiiIiiIiIIIIiIiIIiiIIiii.class.isAssignableFrom(field.getType());
        if (extractFromExistingValues) {
            try {
                Object object = field.get(null);
                if (object == null || object == GameData.getBlockRegistry().getDefaultValue()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isBlock = false;
                    this.isItem = false;
                    return;
                }
                this.injectedObject = this.isBlock ? GameData.getBlockRegistry().getNameForObject(object) : (this.isItem ? GameData.getItemRegistry().getNameForObject(object) : null);
            }
            catch (Exception exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        } else {
            this.injectedObject = injectedObject;
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that is not an Item or Block (found : %s at %s.%s)", field.getType().getName(), field.getClass().getName(), field.getName()));
        }
        ObjectHolderRef.makeWritable(field);
    }

    private static void makeWritable(Field f) {
        try {
            if (modifiersField == null) {
                try {
                    modifiersField = Field.class.getDeclaredField("modifiers");
                    modifiersField.setAccessible(true);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    modifiersField = null;
                }
            }
            if (modifiersField != null) {
                modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            }
            f.setAccessible(true);
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    public boolean isValid() {
        return this.isBlock || this.isItem;
    }

    public void apply() {
        Object object;
        if (this.isBlock) {
            object = GameData.getBlockRegistry().getObject(this.injectedObject);
            if (object == iIIIiiiIiIIIIIiIIiIiiIiiiIIiIiIIiIIiiiIiIiiiIIIIIiIIiiIiiiiiiiiI.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii) {
                object = null;
            }
        } else {
            object = this.isItem ? GameData.getItemRegistry().getObject(this.injectedObject) : null;
        }
        if (object == null) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", (Object)this.injectedObject, (Object)this.field);
            return;
        }
        if (Modifier.isFinal(this.field.getModifiers())) {
            FMLLog.getLogger().log(Level.DEBUG, "Skipping write to final field {} with value {} ({}).", (Object)this.field, object, (Object)this.injectedObject);
            return;
        }
        try {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandles.Lookup lookup2 = MethodHandles.privateLookupIn(this.field.getDeclaringClass(), lookup);
                VarHandle varHandle = lookup2.unreflectVarHandle(this.field);
                varHandle.set(object);
                return;
            }
            catch (Throwable throwable) {
                this.field.set(null, object);
                return;
            }
        }
        catch (Exception exception) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to set {} with value {} ({}): {}", (Object)this.field, object, (Object)this.injectedObject, (Object)exception.toString());
            return;
        }
    }
}

